/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption;
import org.fenixedu.academic.domain.accounting.postingRules.BaseAmountPlusAmountPerUnitPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public abstract class BaseAmountPlusAmountPerUnitPR
extends BaseAmountPlusAmountPerUnitPR_Base {
    protected BaseAmountPlusAmountPerUnitPR() {
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money maximumAmount) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(baseAmount, amountPerUnit, maximumAmount);
        super.setBaseAmount(baseAmount);
        super.setAmountPerUnit(amountPerUnit);
        super.setMaximumAmount(maximumAmount);
    }

    private void checkParameters(Money baseAmount, Money amountPerUnit, Money maximumAmount) {
        if (baseAmount == null) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.baseAmount.cannot.be.null", new String[0]);
        }
        if (amountPerUnit == null) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.amountPerUnit.cannot.be.null", new String[0]);
        }
        if (maximumAmount == null) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.maximumAmount.cannot.be.null", new String[0]);
        }
    }

    public void setBaseAmount(Money baseAmount) {
        throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.cannot.modify.baseAmount", new String[0]);
    }

    public void setAmountPerUnit(Money amountPerUnit) {
        throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.cannot.modify.amountPerUnit", new String[0]);
    }

    public void setMaximumAmount(Money maximumAmount) {
        throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.cannot.modify.maximumAmount", new String[0]);
    }

    public Money getAmountForUnits(Event event) {
        return this.getAmountForUnits(this.getNumberOfUnits(event));
    }

    public Money getAmountForUnits(Integer numberOfUnits) {
        return this.getAmountPerUnit().multiply(new BigDecimal(numberOfUnits));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        return this.getBaseAmount().add(this.getAmountForUnits(event));
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (!event.getExemptionsSet().isEmpty()) {
            Set<Exemption> exemptions = event.getExemptionsSet();
            for (Exemption exemption : exemptions) {
                AcademicEventExemption academicEventExemption = (AcademicEventExemption)((Object)exemption);
                amountToPay = amountToPay.subtract(academicEventExemption.getValue());
            }
        }
        if (amountToPay.isNegative()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.compareTo(event.calculateAmountToPay(when)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    protected abstract Integer getNumberOfUnits(Event var1);

    public String getMaximumAmountDescription() {
        if (Money.ZERO.equals(this.getMaximumAmount())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.base.amount.plus.units.with.no.maximum.value", (String[])new String[0]);
        }
        return this.getMaximumAmount().getAmountAsString();
    }
}

