/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.insurance;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.events.insurance.IInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent_Base;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.UnitServiceAgreementTemplate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class InsuranceEvent
extends InsuranceEvent_Base
implements IInsuranceEvent {
    private InsuranceEvent() {
    }

    public InsuranceEvent(Person person, ExecutionYear executionYear) {
        this();
        this.init(EventType.INSURANCE, person, executionYear);
    }

    protected void init(EventType eventType, Person person, ExecutionYear executionYear) {
        this.checkRulesToCreate(person, executionYear);
        super.init(eventType, person, executionYear);
    }

    private void checkRulesToCreate(Person person, ExecutionYear executionYear) {
        if (person.hasInsuranceEventOrAdministrativeOfficeFeeInsuranceEventFor(executionYear)) {
            throw new DomainException("error.accounting.events.insurance.InsuranceEvent.person.already.has.insurance.event.for.execution.year", new String[0]);
        }
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    protected UnitServiceAgreementTemplate getServiceAgreementTemplate() {
        return this.getInstitutionUnit().getUnitServiceAgreementTemplate();
    }

    public Account getToAccount() {
        return this.getInstitutionUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    private Unit getInstitutionUnit() {
        return Bennu.getInstance().getInstitutionUnit();
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        ((AccountingEventPaymentCode)((Object)this.getNonProcessedPaymentCodes().iterator().next())).update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
        return this.getNonProcessedPaymentCodes();
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        return Collections.singletonList(AccountingEventPaymentCode.create(PaymentCodeType.INSURANCE, new YearMonthDay(), this.calculatePaymentCodeEndDate(), (Event)((Object)this), entryDTO.getAmountToPay(), entryDTO.getAmountToPay(), this.getPerson()));
    }

    private YearMonthDay calculatePaymentCodeEndDate() {
        return this.calculateNextEndDate(new YearMonthDay());
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        HashSet<EntryType> result = new HashSet<EntryType>();
        result.add(EntryType.INSURANCE_FEE);
        return result;
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(new EntryDTO(EntryType.INSURANCE_FEE, (Event)((Object)this), amountToPay)), transactionDetail);
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public boolean hasInsuranceExemption() {
        return this.getInsuranceExemption() != null;
    }

    public Exemption getInsuranceExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!exemption.isForInsurance()) continue;
            return exemption;
        }
        return null;
    }

    public boolean isInsuranceEvent() {
        return true;
    }

    static {
        InsuranceEvent.getRelationPersonAccountingEvent().addListener((RelationListener)new RelationAdapter<Party, Event>(){

            public void beforeAdd(Party party, Event event) {
                if (event instanceof InsuranceEvent) {
                    Person person = (Person)((Object)party);
                    InsuranceEvent insuranceEvent = (InsuranceEvent)((Object)event);
                    if (person != null && (person.hasAdministrativeOfficeFeeInsuranceEventFor(insuranceEvent.getExecutionYear()) || person.hasInsuranceEventFor(insuranceEvent.getExecutionYear()))) {
                        throw new DomainException("error.accounting.events.insurance.InsuranceEvent.person.already.has.insurance.event.for.execution.year", new String[0]);
                    }
                }
            }
        });
    }
}

