/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent_Base;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class DfaGratuityEvent
extends DfaGratuityEvent_Base {
    protected DfaGratuityEvent() {
    }

    public DfaGratuityEvent(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        this();
        this.checkRulesToCreate(studentCurricularPlan);
        this.init(administrativeOffice, person, studentCurricularPlan, executionYear);
    }

    private void checkRulesToCreate(StudentCurricularPlan studentCurricularPlan) {
        if (!studentCurricularPlan.getDegreeType().isAdvancedFormationDiploma()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent.invalid.degreeType", new String[0]);
        }
    }

    public boolean canApplyExemption(GratuityExemptionJustificationType justificationType) {
        if (this.isCustomEnrolmentModel()) {
            return justificationType == GratuityExemptionJustificationType.OTHER_INSTITUTION || justificationType == GratuityExemptionJustificationType.DIRECTIVE_COUNCIL_AUTHORIZATION;
        }
        return true;
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        if (!this.getNonProcessedPaymentCodes().isEmpty()) {
            ((AccountingEventPaymentCode)((Object)this.getNonProcessedPaymentCodes().iterator().next())).update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
        }
        return this.getNonProcessedPaymentCodes();
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        return Collections.singletonList(AccountingEventPaymentCode.create(PaymentCodeType.TOTAL_GRATUITY, new YearMonthDay(), this.calculatePaymentCodeEndDate(), (Event)((Object)this), entryDTO.getAmountToPay(), entryDTO.getAmountToPay(), this.getStudent().getPerson()));
    }

    private Student getStudent() {
        return this.getStudentCurricularPlan().getRegistration().getStudent();
    }

    private YearMonthDay calculatePaymentCodeEndDate() {
        return this.calculateNextEndDate(new YearMonthDay());
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(new EntryDTO(EntryType.GRATUITY_FEE, (Event)((Object)this), amountToPay)), transactionDetail);
    }

    public boolean isOtherPartiesPaymentsSupported() {
        return true;
    }

    public static Set<AccountingTransaction> readPaymentsFor(YearMonthDay startDate, YearMonthDay endDate) {
        return DfaGratuityEvent.readPaymentsFor(DfaGratuityEvent.class, (YearMonthDay)startDate, (YearMonthDay)endDate);
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.GRATUITY_FEE);
    }

    public boolean isDfaGratuityEvent() {
        return true;
    }
}

