/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent_Base;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsurancePenaltyExemption;
import org.fenixedu.academic.domain.accounting.events.administrativeOfficeFee.IAdministrativeOfficeFeeEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.IInsuranceEvent;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.postingRules.AdministrativeOfficeFeeAndInsurancePR;
import org.fenixedu.academic.domain.accounting.postingRules.AdministrativeOfficeFeePR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class AdministrativeOfficeFeeAndInsuranceEvent
extends AdministrativeOfficeFeeAndInsuranceEvent_Base
implements IAdministrativeOfficeFeeEvent,
IInsuranceEvent {
    protected AdministrativeOfficeFeeAndInsuranceEvent() {
    }

    public AdministrativeOfficeFeeAndInsuranceEvent(AdministrativeOffice administrativeOffice, Person person, ExecutionYear executionYear) {
        this();
        this.init(administrativeOffice, EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE, person, executionYear);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    protected AdministrativeOfficeServiceAgreementTemplate getServiceAgreementTemplate() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate();
    }

    protected Account getFromAccount() {
        return this.getPerson().getExternalAccount();
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getInternalAccount();
    }

    public boolean isInsuranceAmountIncludedInDebt() {
        return !this.getPerson().hasInsuranceEventFor(this.getExecutionYear());
    }

    public boolean hasToPayInsurance() {
        if (!this.isInsuranceAmountIncludedInDebt()) {
            return false;
        }
        if (this.hasInsuranceExemption()) {
            return false;
        }
        return this.getInsurancePayedAmount().lessThan(this.getInsuranceAmount());
    }

    public boolean hasToPayAdministrativeOfficeFee() {
        return this.getAdministrativeOfficeFeePayedAmount().lessThan(this.getAdministrativeOfficeFeeAmount());
    }

    private AdministrativeOfficeFeeAndInsurancePR getAdministrativeOfficeFeeAndInsurancePR() {
        return (AdministrativeOfficeFeeAndInsurancePR)((Object)this.getPostingRule());
    }

    public Money getAdministrativeOfficeFeeAmount() {
        return this.getAdministrativeOfficeFeeAndInsurancePR().getAdministrativeOfficeFeeAmount(this.getStartDate(), this.getEndDate());
    }

    public YearMonthDay getAdministrativeOfficeFeePaymentLimitDate() {
        return this.getPaymentEndDate() != null ? this.getPaymentEndDate() : this.getAdministrativeOfficeFeeAndInsurancePR().getAdministrativeOfficeFeePaymentLimitDate(this.getStartDate(), this.getEndDate());
    }

    public Money getAdministrativeOfficeFeePenaltyAmount() {
        return this.getAdministrativeOfficeFeeAndInsurancePR().getAdministrativeOfficeFeePenaltyAmount(this.getStartDate(), this.getEndDate());
    }

    public Money getInsuranceAmount() {
        return this.getAdministrativeOfficeFeeAndInsurancePR().getInsuranceAmount(this.getStartDate(), this.getEndDate());
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        AccountingEventPaymentCode paymentCode = this.findPaymentCodeInStudentCandidacy();
        if (paymentCode != null) {
            paymentCode.setAccountingEvent((Event)((Object)this));
            return Collections.singletonList(paymentCode);
        }
        Money totalAmount = this.calculateTotalAmount();
        return Collections.singletonList(AccountingEventPaymentCode.create(PaymentCodeType.ADMINISTRATIVE_OFFICE_FEE_AND_INSURANCE, new YearMonthDay(), this.calculatePaymentCodeEndDate(), (Event)((Object)this), totalAmount, totalAmount, this.getPerson()));
    }

    private AccountingEventPaymentCode findPaymentCodeInStudentCandidacy() {
        if (this.getPerson().getStudent() == null) {
            return null;
        }
        if (this.getPerson().getStudent().getActiveRegistrationsIn(this.getExecutionYear().getFirstExecutionPeriod()).size() != 1) {
            return null;
        }
        StudentCandidacy studentCandidacy = this.getActiveDgesCandidacy(this.getPerson());
        if (studentCandidacy == null) {
            return null;
        }
        for (PaymentCode paymentCode : studentCandidacy.getAvailablePaymentCodesSet()) {
            AccountingEventPaymentCode accountingEventPaymentCode;
            if (!paymentCode.isNew() || !((Object)((Object)paymentCode)).getClass().equals(AccountingEventPaymentCode.class) || (accountingEventPaymentCode = (AccountingEventPaymentCode)((Object)paymentCode)).getAccountingEvent() != null || !PaymentCodeType.ADMINISTRATIVE_OFFICE_FEE_AND_INSURANCE.equals((Object)accountingEventPaymentCode.getType()) || !this.getExecutionYear().containsDate(accountingEventPaymentCode.getStartDate().toDateTimeAtMidnight())) continue;
            return accountingEventPaymentCode;
        }
        return null;
    }

    private StudentCandidacy getActiveDgesCandidacy(Person person) {
        for (Candidacy candidacy : person.getCandidaciesSet()) {
            if (!candidacy.isActive() || !(candidacy instanceof StudentCandidacy)) continue;
            return (StudentCandidacy)((Object)candidacy);
        }
        return null;
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        Money totalAmount = this.calculateTotalAmount();
        AccountingEventPaymentCode nonProcessedPaymentCode = this.getNonProcessedPaymentCode();
        if (nonProcessedPaymentCode != null) {
            nonProcessedPaymentCode.update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), totalAmount, totalAmount);
        } else {
            AccountingEventPaymentCode paymentCode = this.getCancelledPaymentCode();
            if (paymentCode != null) {
                paymentCode.update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), totalAmount, totalAmount);
                paymentCode.setState(PaymentCodeState.NEW);
            }
        }
        return this.getNonProcessedPaymentCodes();
    }

    private AccountingEventPaymentCode getCancelledPaymentCode() {
        return this.getCancelledPaymentCodes().isEmpty() ? null : (AccountingEventPaymentCode)((Object)this.getCancelledPaymentCodes().iterator().next());
    }

    private AccountingEventPaymentCode getNonProcessedPaymentCode() {
        return this.getNonProcessedPaymentCodes().isEmpty() ? null : (AccountingEventPaymentCode)((Object)this.getNonProcessedPaymentCodes().iterator().next());
    }

    private YearMonthDay calculatePaymentCodeEndDate() {
        YearMonthDay today = new YearMonthDay();
        YearMonthDay administrativeOfficeFeePaymentLimitDate = this.getAdministrativeOfficeFeePaymentLimitDate();
        return today.isBefore((ReadablePartial)administrativeOfficeFeePaymentLimitDate) ? administrativeOfficeFeePaymentLimitDate : this.calculateNextEndDate(today);
    }

    private Money calculateTotalAmount() {
        Money totalAmount = Money.ZERO;
        for (EntryDTO entryDTO : this.calculateEntries()) {
            totalAmount = totalAmount.add(entryDTO.getAmountToPay());
        }
        return totalAmount;
    }

    public AccountingEventPaymentCode calculatePaymentCode() {
        return (AccountingEventPaymentCode)((Object)this.calculatePaymentCodes().iterator().next());
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, this.buildEntryDTOsFrom(amountToPay), transactionDetail);
    }

    public boolean isInDebt() {
        return this.isOpen() && (this.getPaymentEndDate() != null && this.getPaymentEndDate().isBefore((ReadablePartial)new YearMonthDay()) || this.getSpecificPostingRule().getWhenToApplyFixedAmountPenalty().isBefore((ReadablePartial)new YearMonthDay()));
    }

    private AdministrativeOfficeFeePR getSpecificPostingRule() {
        return (AdministrativeOfficeFeePR)((Object)this.getServiceAgreementTemplate().findPostingRuleBy(EventType.ADMINISTRATIVE_OFFICE_FEE, this.getStartDate(), this.getEndDate()));
    }

    private List<EntryDTO> buildEntryDTOsFrom(Money amountToPay) {
        Money remainingAmount;
        ArrayList<EntryDTO> result = new ArrayList<EntryDTO>(2);
        Money insuranceAmountToDiscount = Money.ZERO;
        if (this.hasToPayInsurance()) {
            insuranceAmountToDiscount = this.getInsuranceAmount();
            result.add(this.buildInsuranceEntryDTO(insuranceAmountToDiscount));
        }
        if ((remainingAmount = amountToPay.subtract(insuranceAmountToDiscount)).isPositive()) {
            result.add(this.buildAdministrativeOfficeFeeEntryDTO(remainingAmount));
        }
        return result;
    }

    private EntryDTO buildAdministrativeOfficeFeeEntryDTO(Money administrativeOfficeFeeAmountToDiscount) {
        return new EntryDTO(EntryType.ADMINISTRATIVE_OFFICE_FEE, (Event)((Object)this), administrativeOfficeFeeAmountToDiscount);
    }

    private EntryDTO buildInsuranceEntryDTO(Money insuranceAmountToDiscount) {
        return new EntryDTO(EntryType.INSURANCE_FEE, (Event)((Object)this), insuranceAmountToDiscount);
    }

    public void changePaymentCodeState(DateTime whenRegistered, PaymentMode paymentMode) {
        if (this.canCloseEvent(whenRegistered) && this.hasNonProcessedPaymentCode()) {
            this.getNonProcessedPaymentCode().setState(this.getPaymentCodeStateFor(paymentMode));
        }
    }

    private boolean hasNonProcessedPaymentCode() {
        return this.getNonProcessedPaymentCode() != null;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" ").appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public boolean hasAdministrativeOfficeFeeAndInsurancePenaltyExemption() {
        return this.getAdministrativeOfficeFeeAndInsurancePenaltyExemption() != null;
    }

    public AdministrativeOfficeFeeAndInsurancePenaltyExemption getAdministrativeOfficeFeeAndInsurancePenaltyExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof AdministrativeOfficeFeeAndInsurancePenaltyExemption)) continue;
            return (AdministrativeOfficeFeeAndInsurancePenaltyExemption)((Object)exemption);
        }
        return null;
    }

    public boolean hasAdministrativeOfficeFeeAndInsuranceExemption() {
        return this.getAdministrativeOfficeFeeAndInsuranceExemption() != null;
    }

    public Exemption getAdministrativeOfficeFeeAndInsuranceExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!exemption.isForAdministrativeOfficeFee()) continue;
            return exemption;
        }
        return null;
    }

    public void setPaymentEndDate(YearMonthDay paymentEndDate) {
        if (!this.isOpen()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent.payment.end.date.can.only.be.modified.on.open.events", new String[0]);
        }
        super.setPaymentEndDate(paymentEndDate);
    }

    public Money getInsurancePayedAmount() {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getToAccountEntry().getEntryType() != EntryType.INSURANCE_FEE) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Money getInsurancePayedAmountFor(int civilYear) {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getToAccountEntry().getEntryType() != EntryType.INSURANCE_FEE || !transaction.isPayed(civilYear)) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Money getAdministrativeOfficeFeePayedAmount() {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getToAccountEntry().getEntryType() != EntryType.ADMINISTRATIVE_OFFICE_FEE) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Money getAdministrativeOfficeFeePayedAmountFor(int civilYear) {
        Money result = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.getToAccountEntry().getEntryType() != EntryType.ADMINISTRATIVE_OFFICE_FEE || !transaction.isPayed(civilYear)) continue;
            result = result.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return result;
    }

    public Money calculateAmountToPay(DateTime whenRegistered) {
        Money result = super.calculateAmountToPay(whenRegistered);
        if (result.isZero()) {
            return result;
        }
        result = result.subtract(this.getPerson().hasInsuranceEventFor(this.getExecutionYear()) ? this.getInsuranceAmount() : Money.ZERO);
        return result.isPositive() ? result : Money.ZERO;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        HashSet<EntryType> result = new HashSet<EntryType>();
        result.add(EntryType.ADMINISTRATIVE_OFFICE_FEE);
        result.add(EntryType.INSURANCE_FEE);
        return result;
    }

    public boolean isOpen() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).greaterThan(Money.ZERO);
    }

    public boolean isClosed() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).lessOrEqualThan(Money.ZERO);
    }

    public boolean isInState(EventState eventState) {
        if (eventState == EventState.OPEN) {
            return this.isOpen();
        }
        if (eventState == EventState.CLOSED) {
            return this.isClosed();
        }
        if (eventState == EventState.CANCELLED) {
            return this.isCancelled();
        }
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent.unexpected.state.to.test", new String[0]);
    }

    public boolean isAdministrativeOfficeAndInsuranceEvent() {
        return true;
    }

    public Exemption getInsuranceExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!exemption.isForInsurance()) continue;
            return exemption;
        }
        return null;
    }

    public boolean hasInsuranceExemption() {
        return this.getInsuranceExemption() != null;
    }

    static {
        AdministrativeOfficeFeeAndInsuranceEvent.getRelationPersonAccountingEvent().addListener((RelationListener)new RelationAdapter<Party, Event>(){

            public void beforeAdd(Party party, Event event) {
                AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent;
                Person person;
                if (event instanceof AdministrativeOfficeFeeAndInsuranceEvent && party != null && party instanceof Person && (person = (Person)((Object)party)).hasAdministrativeOfficeFeeInsuranceEventFor((administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event)).getExecutionYear())) {
                    throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent.event.is.already.defined.for.execution.year", new String[0]);
                }
            }
        });
    }
}

