/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager$callable$createInsuranceEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.InvocationResult;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AccountingEventsManager {
    private final Predicate<DegreeType> acceptedDegreeTypesForAdministrativeOfficeFeeAndInsuranceEvent = DegreeType.oneOf(DegreeType::isPreBolonhaDegree, DegreeType::isBolonhaDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree, DegreeType::isEmpty);
    private final Predicate<DegreeType> acceptedDegreeTypesForGratuityEvent = DegreeType.oneOf(DegreeType::isPreBolonhaDegree, DegreeType::isBolonhaDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree, DegreeType::isAdvancedFormationDiploma, DegreeType::isSpecializationDegree);
    private final Predicate<DegreeType> acceptedDegreeTypesForInsuranceEvent = DegreeType.oneOf(DegreeType::isAdvancedFormationDiploma, DegreeType::isSpecializationDegree);
    public static final Advice advice$createInsuranceEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public InvocationResult createStandaloneEnrolmentGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        return InvocationResult.createSuccess();
    }

    private boolean hasStandaloneCurriculumGroupAndEnrolmentsFor(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        return studentCurricularPlan.hasStandaloneCurriculumGroup() && studentCurricularPlan.getStandaloneCurriculumGroup().hasEnrolment(executionYear);
    }

    public InvocationResult createGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        return this.createGratuityEvent(studentCurricularPlan, executionYear, true);
    }

    public InvocationResult createGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        if (studentCurricularPlan.getDegreeCurricularPlan().isPast()) {
            throw new DomainException("error.AccountingEventsManager.invalid.degree.curricular.plan.type", new String[0]);
        }
        if (studentCurricularPlan.getDegreeType().isAdvancedFormationDiploma()) {
            return this.createDfaGratuityEvent(studentCurricularPlan, executionYear, checkConditions);
        }
        if (studentCurricularPlan.getDegreeType().isSpecializationDegree()) {
            return this.createSpecializationDegreeGratuityEvent(studentCurricularPlan, executionYear, checkConditions);
        }
        if (studentCurricularPlan.getDegreeType().isEmpty()) {
            return this.createStandaloneEnrolmentGratuityEvent(studentCurricularPlan, executionYear);
        }
        return this.createGratuityEventWithPaymentPlan(studentCurricularPlan, executionYear, checkConditions);
    }

    private InvocationResult createDfaGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        return InvocationResult.createSuccess();
    }

    private InvocationResult createSpecializationDegreeGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        return InvocationResult.createSuccess();
    }

    private InvocationResult createGratuityEventWithPaymentPlan(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        return InvocationResult.createSuccess();
    }

    private InvocationResult verifyConditionsToCreateGratuityEvent(ExecutionYear executionYear, StudentCurricularPlan studentCurricularPlan) {
        InvocationResult result = new InvocationResult().setSuccess(false);
        Registration registration = studentCurricularPlan.getRegistration();
        if (this.verifyCommonConditionsToCreateGratuityAndAdministrativeOfficeEvents(executionYear, studentCurricularPlan, registration) && studentCurricularPlan.getDegree().canCreateGratuityEvent()) {
            if (!this.acceptedDegreeTypesForGratuityEvent.test(studentCurricularPlan.getDegreeType())) {
                result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.cannot.create.gratuity.event.for.degree.type", studentCurricularPlan.getDegree().getPresentationName());
                return result;
            }
            result.setSuccess(true);
        } else {
            result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.registration.for.student.does.not.respect.requirements.to.create.gratuity.event", studentCurricularPlan.getRegistration().getStudent().getNumber().toString(), studentCurricularPlan.getDegree().getPresentationName());
        }
        return result;
    }

    public InvocationResult createAdministrativeOfficeFeeAndInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        return this.createAdministrativeOfficeFeeAndInsuranceEvent(studentCurricularPlan, executionYear, true);
    }

    public InvocationResult createAdministrativeOfficeFeeAndInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        return InvocationResult.createSuccess();
    }

    public void createEnrolmentOutOfPeriodEvent(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Integer numberOfDelayDays) {
    }

    private AdministrativeOffice getAdministrativeOffice(StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan.getDegree().getAdministrativeOffice();
    }

    private InvocationResult verifyConditionsToCreateAdministrativeOfficeFeeAndInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        InvocationResult result = new InvocationResult().setSuccess(false);
        Registration registration = studentCurricularPlan.getRegistration();
        if (this.verifyCommonConditionsToCreateGratuityAndAdministrativeOfficeEvents(executionYear, studentCurricularPlan, registration)) {
            if (!this.acceptedDegreeTypesForAdministrativeOfficeFeeAndInsuranceEvent.test(studentCurricularPlan.getDegreeType())) {
                result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.cannot.create.administrativeoffice.fee.and.insurance.event.for.degree.type", studentCurricularPlan.getDegree().getPresentationName());
                return result;
            }
            result.setSuccess(true);
        } else {
            result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.registration.for.student.does.not.respect.requirements.to.create.administrativeoffice.fee.and.insurance.event", studentCurricularPlan.getRegistration().getStudent().getNumber().toString(), studentCurricularPlan.getDegree().getPresentationName());
        }
        return result;
    }

    private boolean verifyCommonConditionsToCreateGratuityAndAdministrativeOfficeEvents(ExecutionYear executionYear, StudentCurricularPlan studentCurricularPlan, Registration registration) {
        return registration.hasToPayGratuityOrInsurance() && registration.isActive() && studentCurricularPlan.getDegreeCurricularPlan().hasExecutionDegreeFor(executionYear) && (registration.isInMobilityState() || registration.hasAnyEnrolmentsIn(executionYear) || this.isSecondCycleInternalCandidacyAndStartedOn(registration, executionYear));
    }

    private boolean isSecondCycleInternalCandidacyAndStartedOn(Registration registration, ExecutionYear executionYear) {
        return registration.isSecondCycleInternalCandidacyIngression() && executionYear.containsDate(registration.getStartDate().toDateTimeAtMidnight());
    }

    public InvocationResult createInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        return this.createInsuranceEvent(studentCurricularPlan, executionYear, true);
    }

    public InvocationResult createInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, boolean checkConditions) {
        return InvocationResult.createSuccess();
    }

    private InvocationResult verifyConditionsToCreateInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        InvocationResult result = new InvocationResult().setSuccess(false);
        Registration registration = studentCurricularPlan.getRegistration();
        if (this.verifyCommonConditionsToCreateGratuityAndAdministrativeOfficeEvents(executionYear, studentCurricularPlan, registration)) {
            if (!this.acceptedDegreeTypesForInsuranceEvent.test(studentCurricularPlan.getDegreeType())) {
                result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.cannot.create.insurance.event.for.degree.type", studentCurricularPlan.getDegree().getPresentationName());
                return result;
            }
            result.setSuccess(true);
        } else {
            result.addMessage("resources.ApplicationResources", "error.accounting.events.AccountingEventsManager.registration.for.student.does.not.respect.requirements.to.create.insurance.event", studentCurricularPlan.getRegistration().getStudent().getNumber().toString(), studentCurricularPlan.getDegree().getPresentationName());
        }
        return result;
    }

    public InvocationResult createInsuranceEvent(Person person, ExecutionYear executionYear) {
        return (InvocationResult)advice$createInsuranceEvent.perform((Callable)new AccountingEventsManager$callable$createInsuranceEvent(this, person, executionYear));
    }

    static /* synthetic */ InvocationResult advised$createInsuranceEvent(AccountingEventsManager this_, Person person, ExecutionYear executionYear) {
        return InvocationResult.createSuccess();
    }
}

