/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Comparator;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.CreditNote;
import org.fenixedu.academic.domain.accounting.CreditNoteEntry_Base;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.ReadableInstant;

public class CreditNoteEntry
extends CreditNoteEntry_Base {
    public static Comparator<CreditNoteEntry> COMPARATOR_BY_WHEN_REGISTERED = new Comparator<CreditNoteEntry>(){

        @Override
        public int compare(CreditNoteEntry leftCreditNoteEntry, CreditNoteEntry rightCreditNoteEntry) {
            int comparationResult = leftCreditNoteEntry.getAccountingEntry().getWhenRegistered().compareTo((ReadableInstant)rightCreditNoteEntry.getAccountingEntry().getWhenRegistered());
            return comparationResult == 0 ? leftCreditNoteEntry.getExternalId().compareTo(rightCreditNoteEntry.getExternalId()) : comparationResult;
        }
    };

    CreditNoteEntry(CreditNote creditNote, Entry accountingEntry, Money amount) {
        super.setRootDomainObject(Bennu.getInstance());
        this.init(creditNote, accountingEntry, amount);
    }

    private void init(CreditNote creditNote, Entry accountingEntry, Money amount) {
        this.checkParameters(creditNote, accountingEntry, amount);
        this.checkRulesToCreate(accountingEntry, amount);
        super.setCreditNote(creditNote);
        super.setAccountingEntry(accountingEntry);
        super.setAmount(amount);
    }

    private void checkRulesToCreate(Entry accountingEntry, Money amount) {
        if (!accountingEntry.canApplyReimbursement(amount)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.CreditNoteEntry.amount.to.reimburse.exceeds.entry.amount", accountingEntry.getDescription());
        }
    }

    private void checkParameters(CreditNote creditNote, Entry accountingEntry, Money amount) {
        if (creditNote == null) {
            throw new DomainException("error.accounting.CreditNoteEntry.creditNote.cannot.be.null", new String[0]);
        }
        if (accountingEntry == null) {
            throw new DomainException("error.accounting.CreditNoteEntry.accountingEntry.cannot.be.null", new String[0]);
        }
        if (amount == null) {
            throw new DomainException("error.accounting.CreditNoteEntry.amount.cannot.be.null", new String[0]);
        }
        if (amount.lessOrEqualThan(Money.ZERO)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.CreditNoteEntry.amount.to.reimburse.must.be.greater.than.zero", accountingEntry.getDescription());
        }
    }

    public void setAccountingEntry(Entry accountingEntry) {
        throw new DomainException("error.accounting.CreditNoteEntry.cannot.modify.accountingEntry", new String[0]);
    }

    public void setCreditNote(CreditNote creditNote) {
        throw new DomainException("error.accounting.enclosing_type.cannot.modify.creditNote", new String[0]);
    }

    public void setAdjustmentAccountingEntry(Entry adjustmentAccountingEntry) {
        throw new DomainException("error.accounting.CreditNoteEntry.cannot.modify.adjustmentAccountingEntry", new String[0]);
    }

    public void setAmount(Money amount) {
        throw new DomainException("error.accounting.CreditNoteEntry.cannot.modify.amount", new String[0]);
    }

    void createAdjustmentAccountingEntry(User responsibleUser, PaymentMode paymentMode) {
        AccountingTransaction transaction = this.getAccountingEntry().getAccountingTransaction().reimburse(responsibleUser, paymentMode, this.getAmount());
        super.setAdjustmentAccountingEntry(transaction.getToAccountEntry());
    }
}

