/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.DocumentType;
import org.fenixedu.academic.domain.GraduationType;
import org.fenixedu.academic.domain.Price_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class Price
extends Price_Base {
    public Price() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Price(GraduationType graduationType, DocumentType documentType, String description, Double price) {
        this();
        this.setDescription(description);
        this.setDocumentType(documentType);
        this.setGraduationType(graduationType);
        this.setPrice(price);
    }

    public static Price readByGraduationTypeAndDocumentTypeAndDescription(GraduationType graduationType, DocumentType documentType, String description) {
        for (Price price : Bennu.getInstance().getPricesSet()) {
            if (price.getGraduationType() != graduationType || price.getDocumentType() != documentType || !price.getDescription().equals(description)) continue;
            return price;
        }
        return null;
    }

    public static List<Price> readByGraduationTypeAndDocumentTypes(GraduationType graduationType, List<DocumentType> documentTypes) {
        ArrayList<Price> result = new ArrayList<Price>();
        for (Price price : Bennu.getInstance().getPricesSet()) {
            if (price.getGraduationType() != graduationType || !documentTypes.contains((Object)price.getDocumentType())) continue;
            result.add(price);
        }
        return result;
    }
}

