/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.List;
import org.fenixedu.academic.domain.CurricularYearList;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference_Base;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class OccupationPeriodReference
extends OccupationPeriodReference_Base {
    private OccupationPeriodReference() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public OccupationPeriodReference(OccupationPeriod period, ExecutionDegree degree, OccupationPeriodType type, Integer semester, CurricularYearList curricularYears) {
        this();
        if (period == null || degree == null) {
            throw new DomainException("exception.null.arguments", new String[0]);
        }
        this.setOccupationPeriod(period);
        this.setExecutionDegree(degree);
        this.setPeriodType(type);
        this.setSemester(semester);
        this.setCurricularYears(curricularYears);
    }

    @Deprecated
    public OccupationPeriodType getPeriodType() {
        switch (super.getPeriodType()) {
            case EXAMS: {
                if (!this.getEvaluationSeasonSet().stream().anyMatch(EvaluationSeason::isSpecial)) break;
                return OccupationPeriodType.EXAMS_SPECIAL_SEASON;
            }
            case GRADE_SUBMISSION: {
                if (!this.getEvaluationSeasonSet().stream().anyMatch(EvaluationSeason::isSpecial)) break;
                return OccupationPeriodType.GRADE_SUBMISSION_SPECIAL_SEASON;
            }
        }
        return super.getPeriodType();
    }

    @Deprecated
    public void setPeriodType(OccupationPeriodType periodType) {
        switch (periodType) {
            case EXAMS: {
                this.addEvaluationSeason(EvaluationSeason.readNormalSeason());
                this.addEvaluationSeason(EvaluationSeason.readImprovementSeason());
                super.setPeriodType(periodType);
                break;
            }
            case EXAMS_SPECIAL_SEASON: {
                this.addEvaluationSeason(EvaluationSeason.readSpecialSeason());
                super.setPeriodType(OccupationPeriodType.EXAMS);
                break;
            }
            case GRADE_SUBMISSION: {
                this.addEvaluationSeason(EvaluationSeason.readNormalSeason());
                this.addEvaluationSeason(EvaluationSeason.readImprovementSeason());
                super.setPeriodType(periodType);
                break;
            }
            case GRADE_SUBMISSION_SPECIAL_SEASON: {
                this.addEvaluationSeason(EvaluationSeason.readSpecialSeason());
                super.setPeriodType(OccupationPeriodType.GRADE_SUBMISSION);
                break;
            }
            default: {
                super.setPeriodType(periodType);
            }
        }
    }

    public void delete() {
        this.setOccupationPeriod(null);
        this.setExecutionDegree(null);
        this.setRootDomainObject(null);
        this.getEvaluationSeasonSet().forEach(s -> this.removeEvaluationSeason((EvaluationSeason)s));
        this.deleteDomainObject();
    }

    public String getCurricularYearsString() {
        CurricularYearList years = this.getCurricularYears();
        if (years == null) {
            return "-1";
        }
        List<Integer> yearList = years.getYears();
        StringBuilder returnStr = new StringBuilder();
        for (Integer year : yearList) {
            if (returnStr.length() > 0) {
                returnStr.append(",");
            }
            returnStr.append(year);
        }
        return returnStr.toString();
    }

    public String getCurricularYearsPresentationString() {
        CurricularYearList years = this.getCurricularYears();
        if (years == null || years.hasAll()) {
            return "Todos os anos";
        }
        List<Integer> yearList = years.getYears();
        StringBuilder returnStr = new StringBuilder();
        for (Integer year : yearList) {
            if (returnStr.length() > 0) {
                returnStr.append(", ");
            }
            returnStr.append(year + "\u00ba");
        }
        if (yearList.size() > 1) {
            returnStr.append(" Anos");
        } else {
            returnStr.append(" Ano");
        }
        return returnStr.toString();
    }
}

