/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.phd;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.commons.configuration.ConfigurationInvocationHandler;
import org.fenixedu.commons.configuration.ConfigurationManager;
import org.fenixedu.commons.configuration.ConfigurationProperty;

public class InstitutionPhdCandidacyProcessProperties {
    public static String getPublicCandidacyAccessLink(Locale locale) {
        return InstitutionPhdCandidacyProcessProperties.getConfiguration().phdInstitutionPublicCandidacyAccessLink().get(InstitutionPhdCandidacyProcessProperties.readLanguageCode(locale));
    }

    public static String getPublicCandidacySubmissionLink(Locale locale) {
        return InstitutionPhdCandidacyProcessProperties.getConfiguration().phdInstitutionPublicCandidacySubmissionLink().get(InstitutionPhdCandidacyProcessProperties.readLanguageCode(locale));
    }

    public static String getPublicCandidacyRefereeFormLink(Locale locale) {
        return InstitutionPhdCandidacyProcessProperties.getConfiguration().phdInstitutionPublicCandidacyRefereeFormLink().get(InstitutionPhdCandidacyProcessProperties.readLanguageCode(locale));
    }

    public static String getPublicCandidacyAccessLink(PhdProgramPublicCandidacyHashCode candidacyProcessHashCode, Locale locale) {
        return String.format("%s?hash=%s", InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(locale), candidacyProcessHashCode.getValue());
    }

    public static ConfigurationProperties getConfiguration() {
        return (ConfigurationProperties)ConfigurationInvocationHandler.getConfiguration(ConfigurationProperties.class);
    }

    private static String readLanguageCode(Locale locale) {
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String result = null;
        if (!StringUtils.isEmpty((String)language)) {
            result = language.toUpperCase();
        } else if (!StringUtils.isEmpty((String)country)) {
            result = country.toUpperCase();
        }
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        return "PT";
    }

    @ConfigurationManager(description="Phd Institution Public Candidacy Properties")
    public static interface ConfigurationProperties {
        @ConfigurationProperty(key="phd.institution.public.candidacy.access.link.*")
        public Map<String, String> phdInstitutionPublicCandidacyAccessLink();

        @ConfigurationProperty(key="phd.institution.public.candidacy.submission.link.*")
        public Map<String, String> phdInstitutionPublicCandidacySubmissionLink();

        @ConfigurationProperty(key="phd.institution.public.candidacy.referee.form.link.*")
        public Map<String, String> phdInstitutionPublicCandidacyRefereeFormLink();
    }
}

