/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberToWordsConverter {
    private static final Logger logger = LoggerFactory.getLogger(NumberToWordsConverter.class);
    private static final String[] ONES = new String[]{"zero", "um", "dois", "tr\u00eas", "quatro", "cinco", "seis", "sete", "oito", "nove", "dez", "onze", "doze", "treze", "catorze", "quinze", "dezasseis", "dezassete", "dezoito", "dezanove"};
    private static final String[] ONES_EN = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "treze", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] TENS = new String[]{"", "", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa", "cem"};
    private static final String[] TENS_EN = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred"};
    private static final String[] HUNDREDS = new String[]{"", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"};
    private static final String[] HUNDREDS_EN = new String[]{"", "hundred", "two hundred", "three hundred", "four hundred", "five hundred", "six hundred", "seven hundred", "eight hundred", "nine hundred"};
    private static final String[] THOUSAND_SINGLE = new String[]{"", "mil", "milh\u00e3o", "bili\u00e3o"};
    private static final String[] THOUSAND_EN = new String[]{"", "thousand", "million", "billion"};
    private static final String[] THOUSAND_PLURAL = new String[]{"", "mil", "milh\u00f5es", "bili\u00f5es"};
    private static final String ZERO = ONES[0];
    private static final String ZERO_EN = ONES_EN[0];
    private static final String SEPARATOR = " e ";
    private static final String SEPARATOR_EN = " and ";

    public static String convert(int value) {
        return NumberToWordsConverter.convert(value, new Locale("pt", "PT"));
    }

    public static String convert(int value, Locale locale) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return value == 0 ? ZERO_EN : NumberToWordsConverter.thousandsEn(value);
        }
        return value == 0 ? ZERO : NumberToWordsConverter.thousands(value);
    }

    private static String ones(int value) {
        return ONES[value];
    }

    private static String tens(int value) {
        return value < 20 ? NumberToWordsConverter.ones(value) : TENS[value / 10] + (value % 10 == 0 ? "" : SEPARATOR + NumberToWordsConverter.ones(value % 10));
    }

    private static String hundreds(int value) {
        return value <= 100 ? NumberToWordsConverter.tens(value) : HUNDREDS[value / 100] + (value % 100 == 0 ? "" : SEPARATOR + NumberToWordsConverter.tens(value % 100));
    }

    private static String thousands(int value) {
        if (value < 1000) {
            return NumberToWordsConverter.hundreds(value);
        }
        int quotient = value / 1000;
        int remainder = value % 1000;
        return quotient == 1 ? THOUSAND_SINGLE[quotient] + (remainder == 0 ? "" : SEPARATOR + NumberToWordsConverter.hundreds(remainder)) : NumberToWordsConverter.thousands(value, 1);
    }

    private static String thousands(int value, int level) {
        if (value < 1000) {
            return NumberToWordsConverter.hundreds(value);
        }
        int quotient = value / 1000;
        int remainder = value % 1000;
        int nextRemainder = quotient % 1000;
        if (nextRemainder == 0) {
            return NumberToWordsConverter.thousands(quotient, level + 1) + (remainder == 0 ? "" : SEPARATOR + NumberToWordsConverter.hundreds(remainder));
        }
        if (nextRemainder == 1) {
            return NumberToWordsConverter.thousands(quotient, level + 1) + " " + THOUSAND_SINGLE[level] + (remainder == 0 ? "" : SEPARATOR + NumberToWordsConverter.hundreds(remainder));
        }
        return NumberToWordsConverter.thousands(quotient, level + 1) + " " + THOUSAND_PLURAL[level] + (remainder == 0 ? "" : SEPARATOR + NumberToWordsConverter.hundreds(remainder));
    }

    private static String thousandsEn(int value) {
        if (value < 1000) {
            return NumberToWordsConverter.hundredsEn(value);
        }
        int quotient = value / 1000;
        int remainder = value % 1000;
        return quotient == 1 ? THOUSAND_EN[quotient] + (remainder == 0 ? "" : SEPARATOR_EN + NumberToWordsConverter.hundredsEn(remainder)) : NumberToWordsConverter.thousandsEn(value, 1);
    }

    private static String thousandsEn(int value, int level) {
        if (value < 1000) {
            return NumberToWordsConverter.hundredsEn(value);
        }
        int quotient = value / 1000;
        int remainder = value % 1000;
        int nextRemainder = quotient % 1000;
        if (nextRemainder == 0) {
            return NumberToWordsConverter.thousandsEn(quotient, level + 1) + (remainder == 0 ? "" : SEPARATOR_EN + NumberToWordsConverter.hundredsEn(remainder));
        }
        if (nextRemainder == 1) {
            return NumberToWordsConverter.thousandsEn(quotient, level + 1) + " " + THOUSAND_EN[level] + (remainder == 0 ? "" : SEPARATOR_EN + NumberToWordsConverter.hundredsEn(remainder));
        }
        return NumberToWordsConverter.thousandsEn(quotient, level + 1) + " " + THOUSAND_EN[level] + (remainder == 0 ? "" : SEPARATOR_EN + NumberToWordsConverter.hundredsEn(remainder));
    }

    private static String hundredsEn(int value) {
        return value <= 100 ? NumberToWordsConverter.tensEn(value) : HUNDREDS_EN[value / 100] + (value % 100 == 0 ? "" : SEPARATOR_EN + NumberToWordsConverter.tensEn(value % 100));
    }

    private static String onesEn(int value) {
        return ONES_EN[value];
    }

    private static String tensEn(int value) {
        return value < 20 ? NumberToWordsConverter.onesEn(value) : TENS_EN[value / 10] + (value % 10 == 0 ? "" : NumberToWordsConverter.onesEn(value % 10));
    }

    public static void main(String[] args) {
        int[] values;
        for (int value : values = new int[]{1, 23, 52, 100, 102, 223, 1000, 1023, 2000, 2453, 9000, 10000, 10001, 11342, 100000, 1000000, 2000000, 10000000, 100000000, 1000000000}) {
            int quotient = value / 1000;
            int remainder = value % 1000;
            int nextRemainder = quotient % 1000;
            logger.info(StringUtils.rightPad((String)("V: " + value), (int)11, (char)' ') + "\t");
            logger.info(StringUtils.rightPad((String)("Q: " + quotient), (int)11, (char)' '));
            logger.info("\tR: " + remainder);
            logger.info("\tRQ: " + nextRemainder);
            logger.info("\twords: " + NumberToWordsConverter.convert(value));
        }
    }
}

