/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.student.firstTimeCandidacy;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.commons.student.StudentNumberBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=ManagerApplications.ManagerStudentsApp.class, path="first-time-candidacy", titleKey="title.first.time.candidacy.summary")
@Mapping(path="/candidacySummary", module="manager")
@Forwards(value={@Forward(name="prepare", path="/manager/student/candidacies/manageFirstCandidacySummaryFile.jsp")})
public class FirstTimeCandidacySummaryFileDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentNumberBean", (Object)new StudentNumberBean());
        return mapping.findForward("prepare");
    }

    public ActionForward searchCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentNumberBean numberBean = (StudentNumberBean)this.getRenderedObject("student-number-bean");
        StudentCandidacy studentCandidacy = this.findCandidacy(numberBean.getNumber());
        request.setAttribute("candidacy", (Object)studentCandidacy);
        if (studentCandidacy != null && studentCandidacy.getSummaryFile() != null) {
            request.setAttribute("hasPDF", (Object)"true");
        }
        return mapping.findForward("prepare");
    }

    private StudentCandidacy findCandidacy(Integer studentNumber) {
        Student student = Student.readStudentByNumber(studentNumber);
        Set<Registration> registrations = student.getRegistrationsSet();
        if (registrations != null && registrations.size() > 0) {
            return ((Registration)((Object)registrations.iterator().next())).getStudentCandidacy();
        }
        return null;
    }
}

