/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeLog;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.dto.coordinator.SearchDegreeLogBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="coordinator", path="/searchDLog", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="search", path="/coordinator/viewLogSearch.jsp")})
public class SearchDegreeLogAction
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepareInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeCurricularPlanOID = SearchDegreeLogAction.newFindDegreeCurricularPlanID(request);
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanOID);
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanOID);
        ExecutionDegree executionDegree = degreeCurricularPlan.getMostRecentExecutionDegree();
        Degree degree = executionDegree.getDegree();
        SearchDegreeLogBean sdlb = new SearchDegreeLogBean(degree);
        sdlb.setDegreeLogTypes(new ArrayList<DegreeLog.DegreeLogTypes>());
        request.setAttribute("searchBean", (Object)sdlb);
        request.setAttribute("degree", (Object)sdlb.getDegree());
        return mapping.findForward("search");
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan dcp = (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanID"));
        SearchDegreeLogBean sdlb = this.readSearchBean(request, dcp.getDegree());
        this.searchLogs(sdlb);
        request.setAttribute("searchBean", (Object)sdlb);
        request.setAttribute("degree", (Object)sdlb.getDegree());
        this.prepareAttendsCollectionPages(request, sdlb, sdlb.getDegree());
        return mapping.findForward("search");
    }

    private SearchDegreeLogBean readSearchBean(HttpServletRequest request, Degree degree) {
        String degreeID = request.getParameter("degree");
        if (degreeID != null) {
            SearchDegreeLogBean sdlb = new SearchDegreeLogBean((Degree)FenixFramework.getDomainObject((String)degreeID));
            String viewPhoto = request.getParameter("viewPhoto");
            if (viewPhoto != null && viewPhoto.equalsIgnoreCase("true")) {
                sdlb.setViewPhoto(true);
            } else {
                sdlb.setViewPhoto(false);
            }
            String logTypes = request.getParameter("degreeLogTypes");
            if (logTypes != null) {
                ArrayList<DegreeLog.DegreeLogTypes> list = new ArrayList<DegreeLog.DegreeLogTypes>();
                for (String logType : logTypes.split(":")) {
                    list.add(DegreeLog.DegreeLogTypes.valueOf(logType));
                }
                sdlb.setDegreeLogTypes(list);
            }
            return sdlb;
        }
        return new SearchDegreeLogBean(degree);
    }

    private void prepareAttendsCollectionPages(HttpServletRequest request, SearchDegreeLogBean seclb, Degree degree) {
        Collection<DegreeLog> dLogs = seclb.getDegreeLogs();
        ArrayList<DegreeLog> listDLogs = new ArrayList<DegreeLog>(dLogs);
        Collections.sort(listDLogs, DegreeLog.COMPARATOR_BY_WHEN_DATETIME);
        int entriesPerPage = 20;
        CollectionPager<DegreeLog> pager = new CollectionPager<DegreeLog>(listDLogs, entriesPerPage);
        request.setAttribute("numberOfPages", (Object)(listDLogs.size() / entriesPerPage + 1));
        String pageParameter = request.getParameter("pageNumber");
        Integer page = StringUtils.isEmpty((String)pageParameter) ? Integer.valueOf(1) : Integer.valueOf(pageParameter);
        request.setAttribute("pageNumber", (Object)page);
        SearchDegreeLogBean logPagesBean = new SearchDegreeLogBean(degree);
        this.searchLogs(logPagesBean);
        logPagesBean.setDegreeLogs(pager.getPage(page));
        if (seclb.getViewPhoto().booleanValue()) {
            logPagesBean.setViewPhoto(true);
        }
        request.setAttribute("logPagesBean", (Object)logPagesBean);
    }

    private void searchLogs(SearchDegreeLogBean bean) {
        Predicate<DegreeLog> filter = bean.getFilters();
        HashSet<DegreeLog> validLogs = new HashSet<DegreeLog>();
        for (DegreeLog log : bean.getDegree().getDegreeLogsSet()) {
            if (!filter.test(log)) continue;
            validLogs.add(log);
        }
        bean.setDegreeLogs(validLogs);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlanID", request.getAttribute("degreeCurricularPlanID"));
        SearchDegreeLogBean bean = (SearchDegreeLogBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        this.searchLogs(bean);
        request.setAttribute("searchBean", (Object)bean);
        request.setAttribute("degree", (Object)bean.getDegree());
        this.prepareAttendsCollectionPages(request, bean, bean.getDegree());
        return mapping.findForward("search");
    }

    private static String newFindDegreeCurricularPlanID(HttpServletRequest request) {
        String degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
        if (degreeCurricularPlanID == null) {
            degreeCurricularPlanID = (String)request.getAttribute("degreeCurricularPlanID");
        }
        return degreeCurricularPlanID;
    }
}

