/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegime;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.AddAttendsBean;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.dto.student.RegistrationCurriculumBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.administrativeOffice.student.RegistrationConclusionProcess;
import org.fenixedu.academic.service.services.enrollment.shift.WriteStudentAttendingCourse;
import org.fenixedu.academic.service.services.registration.DeleteRegistrationRegime;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.StudentRegistrationDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/registration", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="chooseCycleForViewRegistrationCurriculum", path="/academicAdminOffice/student/registration/chooseCycleForViewRegistrationCurriculum.jsp"), @Forward(name="chooseProgramConclusion", path="/academicAdminOffice/student/registration/chooseProgramConclusion.jsp"), @Forward(name="view-registration-curriculum", path="/academicAdminOffice/student/registration/viewRegistrationCurriculum.jsp"), @Forward(name="registrationConclusion", path="/academicAdminOffice/student/registration/registrationConclusion.jsp"), @Forward(name="registrationConclusionDocument", path="/academicAdminOffice/student/registration/registrationConclusionDocument.jsp"), @Forward(name="viewAttends", path="/academicAdminOffice/student/registration/viewAttends.jsp"), @Forward(name="addAttends", path="/academicAdminOffice/student/registration/addAttends.jsp"), @Forward(name="showRegimes", path="/academicAdminOffice/student/registration/showRegimes.jsp"), @Forward(name="createRegime", path="/academicAdminOffice/student/registration/createRegime.jsp"), @Forward(name="view-application", path="/academicAdminOffice/student/registration/application.jsp")})
public class RegistrationDA
extends StudentRegistrationDA {
    public ActionForward prepareViewRegistrationCurriculum(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        Registration registration = this.getAndSetRegistration(request);
        RegistrationCurriculumBean registrationCurriculumBean = new RegistrationCurriculumBean(registration);
        request.setAttribute("registrationCurriculumBean", (Object)registrationCurriculumBean);
        String degreeCurricularPlanID = this.getStringFromRequest(request, "degreeCurricularPlanID");
        if (degreeCurricularPlanID != null) {
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        return mapping.findForward("chooseCycleForViewRegistrationCurriculum");
    }

    public ActionForward prepareViewRegistrationCurriculumInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registrationCurriculumBean", (Object)this.getRegistrationCurriculumBeanFromViewState());
        request.setAttribute("degreeCurricularPlanID", (Object)registration.getLastDegreeCurricularPlan().getExternalId());
        return mapping.findForward("chooseCycleForViewRegistrationCurriculum");
    }

    private RegistrationCurriculumBean getRegistrationCurriculumBeanFromViewState() {
        return (RegistrationCurriculumBean)this.getObjectFromViewState("registrationCurriculumBean");
    }

    public ActionForward chooseCycleForViewRegistrationCurriculum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationCurriculumBean registrationCurriculumBean = this.getRegistrationCurriculumBeanFromViewState();
        request.setAttribute("registrationCurriculumBean", (Object)registrationCurriculumBean);
        request.setAttribute("registration", (Object)registrationCurriculumBean.getRegistration());
        Person studentPerson = registrationCurriculumBean.getStudent().getPerson();
        request.setAttribute("studentPerson", (Object)studentPerson);
        return mapping.findForward("view-registration-curriculum");
    }

    public ActionForward viewRegistrationCurriculum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistrationCurriculumBean registrationCurriculumBean = this.getRegistrationCurriculumBeanFromViewState();
        String degreeCurricularPlanID = this.getStringFromRequest(request, "degreeCurricularPlanID");
        if (degreeCurricularPlanID != null) {
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        request.setAttribute("registrationCurriculumBean", (Object)registrationCurriculumBean);
        return mapping.findForward("view-registration-curriculum");
    }

    public ActionForward prepareRegistrationConclusionProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registrationConclusionBean", (Object)new RegistrationConclusionBean(registration));
        return mapping.findForward("chooseProgramConclusion");
    }

    public ActionForward prepareRegistrationConclusionProcessInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetRegistration(request);
        request.setAttribute("registrationConclusionBean", (Object)this.getRegistrationConclusionBeanFromViewState());
        return mapping.findForward("chooseProgramConclusion");
    }

    private RegistrationConclusionBean getRegistrationConclusionBeanFromViewState() {
        return (RegistrationConclusionBean)this.getObjectFromViewState("registrationConclusionBean");
    }

    public ActionForward doRegistrationConclusion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationConclusionBean registrationConclusionBean = this.getRegistrationConclusionBeanFromViewState();
        try {
            RegistrationConclusionProcess.run(registrationConclusionBean);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("illegal.access", request, "error.not.authorized.to.registration.conclusion.process");
            request.setAttribute("registrationConclusionBean", (Object)registrationConclusionBean);
            return mapping.findForward("registrationConclusion");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getLocalizedMessage(), false);
            request.setAttribute("registrationConclusionBean", (Object)registrationConclusionBean);
            return mapping.findForward("registrationConclusion");
        }
        request.setAttribute("registrationId", (Object)registrationConclusionBean.getRegistration().getExternalId());
        return this.visualizeRegistration(mapping, form, request, response);
    }

    public ActionForward revertRegistrationConclusionLastVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationConclusionBean registrationConclusionBean = this.getRegistrationConclusionBeanFromViewState();
        try {
            RegistrationConclusionProcess.revert(registrationConclusionBean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getLocalizedMessage(), false);
            request.setAttribute("registrationConclusionBean", (Object)registrationConclusionBean);
            return mapping.findForward("registrationConclusion");
        }
        request.setAttribute("registrationId", (Object)registrationConclusionBean.getRegistration().getExternalId());
        return this.visualizeRegistration(mapping, form, request, response);
    }

    public ActionForward chooseProgramConclusion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegistrationConclusionBean registrationConclusionBean = this.getRegistrationConclusionBeanFromViewState();
        request.setAttribute("registrationConclusionBean", (Object)registrationConclusionBean);
        request.setAttribute("registration", (Object)registrationConclusionBean.getRegistration());
        return mapping.findForward("registrationConclusion");
    }

    public ActionForward prepareRegistrationConclusionDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)this.getDomainObject(request, "curriculumGroupId"));
        if (curriculumGroup == null || curriculumGroup.getDegreeModule().getProgramConclusion() == null) {
            this.addActionMessage(request, BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.program.conclusion.empty", (String[])new String[0]), false);
        }
        RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(registration, curriculumGroup);
        request.setAttribute("registrationConclusionBean", (Object)registrationConclusionBean);
        String degreePresentationName = registration.getDegree().getPresentationName(registrationConclusionBean.getConclusionYear());
        request.setAttribute("degreePresentationName", (Object)degreePresentationName);
        return mapping.findForward("registrationConclusionDocument");
    }

    public ActionForward viewAttends(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        if (registration != null) {
            TreeMap<ExecutionSemester, TreeSet<Attends>> attendsMap = new TreeMap<ExecutionSemester, TreeSet<Attends>>();
            for (Attends attends : registration.getAssociatedAttendsSet()) {
                ExecutionSemester executionSemester = attends.getExecutionPeriod();
                TreeSet<Attends> attendsSet = (TreeSet<Attends>)attendsMap.get(executionSemester);
                if (attendsSet == null) {
                    attendsSet = new TreeSet<Attends>(Attends.ATTENDS_COMPARATOR);
                    attendsMap.put(executionSemester, attendsSet);
                }
                attendsSet.add(attends);
            }
            request.setAttribute("attendsMap", attendsMap);
        }
        return mapping.findForward("viewAttends");
    }

    public ActionForward prepareAddAttends(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        AddAttendsBean addAttendsBean = (AddAttendsBean)this.getObjectFromViewState("addAttendsBean");
        if (addAttendsBean == null) {
            addAttendsBean = new AddAttendsBean();
            ExecutionSemester executionPeriod = ExecutionSemester.readActualExecutionSemester();
            ExecutionYear executionYear = executionPeriod.getExecutionYear();
            Degree degree = registration.getDegree();
            ExecutionDegree executionDegree = this.getExecutionDegree(executionYear, degree);
            addAttendsBean.setExecutionPeriod(executionPeriod);
            addAttendsBean.setExecutionYear(executionYear);
            addAttendsBean.setExecutionDegree(executionDegree);
        }
        request.setAttribute("addAttendsBean", (Object)addAttendsBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("addAttends");
    }

    protected ExecutionDegree getExecutionDegree(ExecutionYear executionYear, Degree degree) {
        for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != executionYear) continue;
                return executionDegree;
            }
        }
        return null;
    }

    public ActionForward addAttends(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        AddAttendsBean addAttendsBean = (AddAttendsBean)this.getObjectFromViewState("addAttendsBean");
        ExecutionCourse executionCourse = addAttendsBean.getExecutionCourse();
        WriteStudentAttendingCourse.runWriteStudentAttendingCourse(registration, executionCourse.getExternalId());
        return this.viewAttends(mapping, actionForm, request, response);
    }

    public ActionForward deleteAttends(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        String attendsIdString = request.getParameter("attendsId");
        Attends attends = (Attends)FenixFramework.getDomainObject((String)attendsIdString);
        try {
            registration.removeAttendFor(attends.getExecutionCourse());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return this.viewAttends(mapping, actionForm, request, response);
    }

    public ActionForward deleteShiftEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        String attendsIdString = request.getParameter("attendsId");
        Attends attends = (Attends)FenixFramework.getDomainObject((String)attendsIdString);
        if (attends != null) {
            attends.deleteShiftEnrolments();
        }
        return this.viewAttends(mapping, actionForm, request, response);
    }

    public ActionForward showRegimes(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getAndSetRegistration(request);
        ArrayList regimes = new ArrayList(registration.getRegistrationRegimesSet());
        Collections.sort(regimes, new ReverseComparator(RegistrationRegime.COMPARATOR_BY_EXECUTION_YEAR));
        request.setAttribute("registrationRegimes", regimes);
        return mapping.findForward("showRegimes");
    }

    public ActionForward prepareCreateRegime(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.getAndSetRegistration(request);
        return mapping.findForward("createRegime");
    }

    public ActionForward deleteRegime(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            RegistrationRegime regime = this.getRegistrationRegime(request);
            DeleteRegistrationRegime.run(regime);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return this.showRegimes(mapping, actionForm, request, response);
    }

    private RegistrationRegime getRegistrationRegime(HttpServletRequest request) {
        return (RegistrationRegime)((Object)this.getDomainObject(request, "registrationRegimeId"));
    }

    public ActionForward viewApplication(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getAndSetRegistration(request);
        request.setAttribute("registration", (Object)registration);
        return mapping.findForward("view-application");
    }
}

