/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.payments;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.dto.accounting.PaymentsManagementDTO;
import org.fenixedu.academic.report.accounting.GuideDocument;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.payments.PaymentsManagementDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/guides", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showGuide", path="/academicAdminOffice/payments/guides/showGuide.jsp"), @Forward(name="showEvents", path="/academicAdministration/payments.do?method=showEvents")})
public class GuidesManagementDA
extends PaymentsManagementDispatchAction {
    @Override
    public ActionForward preparePrintGuide(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PaymentsManagementDTO managementDTO = (PaymentsManagementDTO)RenderUtils.getViewState((String)"paymentsManagementDTO").getMetaObject().getObject();
        request.setAttribute("paymentsManagementDTO", (Object)managementDTO);
        if (managementDTO.getSelectedEntries().isEmpty()) {
            this.addActionMessage("context", request, "error.payments.guide.entries.selection.is.required");
            request.setAttribute("personId", (Object)managementDTO.getPerson().getExternalId());
            return mapping.findForward("showEvents");
        }
        return mapping.findForward("showGuide");
    }

    public ActionForward printGuide(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PaymentsManagementDTO managementDTO = (PaymentsManagementDTO)RenderUtils.getViewState((String)"paymentsManagementDTO").getMetaObject().getObject();
        GuideDocument document = new GuideDocument(managementDTO);
        byte[] data = ReportsUtils.generateReport(document).getData();
        response.setContentLength(data.length);
        response.setContentType("application/pdf");
        response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
        response.getOutputStream().write(data);
        return null;
    }
}

