/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Mark_Base;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Shift_Base;
import org.fenixedu.academic.domain.StudentGroup_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.ui.spring.controller.teacher.ExecutionCourseController;
import org.fenixedu.academic.ui.spring.controller.teacher.StudentGroupService;
import org.fenixedu.academic.ui.spring.controller.teacher.TeacherView;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.util.WorkingStudentSelectionType;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.RedirectView;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.FenixFramework;

@Controller
@RequestMapping(value={"/teacher/{executionCourse}/attends/"})
public class AttendsSearchController
extends ExecutionCourseController {
    @Autowired
    StudentGroupService studentGroupService;

    @Override
    protected Class<?> getFunctionalityType() {
        return ManageExecutionCourseDA.class;
    }

    @Override
    Boolean getPermission(Professorship prof) {
        return prof.getPermissions().getStudents();
    }

    @RequestMapping(value={"/show"}, method={RequestMethod.GET})
    public TeacherView searchAttends(Model model) {
        JsonArray studentAttendsStateTypes = new JsonArray();
        for (Attends.StudentAttendsStateType type : Attends.StudentAttendsStateType.values()) {
            JsonObject typeJson = new JsonObject();
            typeJson.addProperty("type", BundleUtil.getString((String)"resources.EnumerationResources", (String)type.getQualifiedName(), (String[])new String[0]));
            studentAttendsStateTypes.add((JsonElement)typeJson);
        }
        JsonArray workingStudentSelectionType = new JsonArray();
        for (WorkingStudentSelectionType wsstype : WorkingStudentSelectionType.values()) {
            JsonObject object = new JsonObject();
            object.addProperty("name", BundleUtil.getString((String)"resources.EnumerationResources", (String)wsstype.getQualifiedName(), (String[])new String[0]));
            object.addProperty("working", Boolean.valueOf(wsstype.equals((Object)WorkingStudentSelectionType.WORKING_STUDENT)));
            workingStudentSelectionType.add((JsonElement)object);
        }
        model.addAttribute("attendsStates", (Object)studentAttendsStateTypes);
        model.addAttribute("groupings", (Object)this.view(this.executionCourse.getGroupings()));
        model.addAttribute("curricularPlans", (Object)this.view(this.executionCourse.getAttendsDegreeCurricularPlans()));
        model.addAttribute("shifts", (Object)this.view(this.executionCourse.getShiftsOrderedByLessons()));
        model.addAttribute("shiftTypes", (Object)this.view(this.executionCourse.getShiftTypes()));
        model.addAttribute("workingStudentTypes", (Object)workingStudentSelectionType);
        return new TeacherView("executionCourse/attendsSearch/viewStudentList", this.executionCourse);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> listAttends() {
        return new ResponseEntity((Object)this.view(this.executionCourse.getAttendsSet().stream().filter(attendee -> attendee.getRegistration() != null && !AttendsSearchController.hasEnrolmentAnnuled(attendee.getRegistration(), this.executionCourse))), HttpStatus.OK);
    }

    private static boolean hasEnrolmentAnnuled(Registration registration, ExecutionCourse course) {
        Attends attends = registration == null ? null : (Attends)registration.getAssociatedAttendsSet().stream().filter(a -> a.getExecutionCourse() == course).findAny().orElse(null);
        return attends != null && attends.getEnrolment().isAnnulled();
    }

    @RequestMapping(value={"/studentSpreadsheet"}, method={RequestMethod.POST})
    public void generateSpreadsheet(@RequestParam String filteredAttendsJson, HttpServletResponse response) throws IOException {
        TreeSet<Attends> attends = new TreeSet<Attends>(Attends.COMPARATOR_BY_STUDENT_NUMBER);
        for (JsonElement elem : new JsonParser().parse(filteredAttendsJson).getAsJsonArray()) {
            JsonObject object = elem.getAsJsonObject();
            attends.add((Attends)FenixFramework.getDomainObject((String)object.get("id").getAsString()));
        }
        SpreadsheetBuilder builder = new SpreadsheetBuilder();
        builder.addSheet(this.executionCourse.getPrettyAcronym().concat(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.students", (String[])new String[0])), (SheetData)new SheetData<Attends>(attends){

            protected String getLabel(String key) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)key, (String[])new String[0]);
            }

            protected void makeLine(Attends attends) {
                this.addCell(this.getLabel("label.username"), attends.getRegistration().getPerson().getUsername());
                this.addCell(this.getLabel("label.number"), attends.getRegistration().getNumber());
                this.addCell(this.getLabel("label.name"), attends.getRegistration().getPerson().getName());
                this.addCell(this.getLabel("label.email"), attends.getRegistration().getPerson().getDefaultEmailAddressValue());
                AttendsSearchController.this.executionCourse.getGroupings().forEach(gr -> this.addCell(this.getLabel("label.projectGroup") + " " + gr.getName(), attends.getStudentGroupsSet().stream().filter(sg -> sg.getGrouping().equals(gr)).map(StudentGroup_Base::getGroupNumber).map(gn -> gn.toString()).findAny().orElse("")));
                AttendsSearchController.this.executionCourse.getShiftTypes().forEach(shiftType -> this.addCell(this.getLabel("label.shift") + " " + shiftType.getFullNameTipoAula(), Optional.ofNullable(attends.getRegistration().getShiftFor(attends.getExecutionCourse(), (ShiftType)((Object)shiftType))).map(Shift_Base::getNome).orElse("")));
                if (attends.getEnrolment() != null) {
                    this.addCell(this.getLabel("label.numberOfEnrollments"), attends.getEnrolment().getNumberOfTotalEnrolmentsInThisCourse(attends.getEnrolment().getExecutionPeriod()));
                } else {
                    this.addCell(this.getLabel("label.numberOfEnrollments"), "--");
                }
                this.addCell(this.getLabel("label.attends.enrollmentState"), BundleUtil.getString((String)"resources.EnumerationResources", (String)attends.getAttendsStateType().getQualifiedName(), (String[])new String[0]));
                RegistrationState registrationState = attends.getRegistration().getLastRegistrationState(attends.getExecutionYear());
                this.addCell(this.getLabel("label.registration.state"), registrationState == null ? "" : registrationState.getStateType().getDescription());
                this.addCell(this.getLabel("label.Degree"), attends.getStudentCurricularPlanFromAttends().getDegreeCurricularPlan().getPresentationName());
                this.addCell(this.getLabel("label.students.statutes"), attends.getRegistration().getStudent().getStatutes(attends.getExecutionPeriod()).stream().map(statute -> statute.getDescription()).collect(Collectors.joining("; ")));
            }
        });
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", String.format("attachment; filename=%s.xls", Joiner.on((String)" - ").join((Object)this.executionCourse.getSigla(), (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.students", (String[])new String[0]), new Object[0]).replace(" ", "_")));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            builder.build(WorkbookExportFormat.EXCEL, (OutputStream)response.getOutputStream());
        }
    }

    @RequestMapping(value={"/studentEvaluationsSpreadsheet"}, method={RequestMethod.POST})
    public void generateSpreadsheet(HttpServletResponse response) throws IOException {
        Set attends = this.executionCourse.getAttendsSet();
        SpreadsheetBuilder builder = new SpreadsheetBuilder();
        builder.addSheet(this.executionCourse.getPrettyAcronym().concat(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grades", (String[])new String[0])), (SheetData)new SheetData<Attends>((Iterable)attends){

            protected String getLabel(String key) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)key, (String[])new String[0]);
            }

            protected void makeLine(Attends attends) {
                this.addCell(this.getLabel("label.username"), attends.getRegistration().getPerson().getUsername());
                this.addCell(this.getLabel("label.number"), attends.getRegistration().getNumber());
                this.addCell(this.getLabel("label.name"), attends.getRegistration().getPerson().getPresentationName());
                this.addCell(this.getLabel("label.Degree"), attends.getStudentCurricularPlanFromAttends().getDegreeCurricularPlan().getPresentationName());
                this.addCell(this.getLabel("label.attends.enrollmentState"), BundleUtil.getString((String)"resources.EnumerationResources", (String)attends.getAttendsStateType().getQualifiedName(), (String[])new String[0]));
                AttendsSearchController.this.executionCourse.getAssociatedEvaluationsSet().forEach(ev -> this.addCell(ev.getPresentationName(), attends.getAssociatedMarksSet().stream().filter(mark -> mark.getEvaluation() == ev).map(Mark_Base::getMark).findAny().orElse("")));
            }
        });
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", String.format("attachment; filename=%s.xls", Joiner.on((String)" - ").join((Object)this.executionCourse.getSigla(), (Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grades", (String[])new String[0]), new Object[0]).replace(" ", "_")));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            builder.build(WorkbookExportFormat.EXCEL, (OutputStream)response.getOutputStream());
        }
    }

    @RequestMapping(value={"/sendEmail"}, method={RequestMethod.POST})
    public RedirectView sendEmail(Model model, HttpServletRequest request, HttpSession session, @RequestParam(value="filteredAttendsJson") String filteredAttendsJson, @RequestParam(value="filtersJson") String filtersJson) {
        Object object;
        String attendTypeValues = "";
        String degreeNameValues = "";
        String shiftsValues = "";
        String workingStudentsValues = "";
        JsonObject filters = new JsonParser().parse(filtersJson).getAsJsonObject();
        for (JsonElement elem : filters.get("attendsStates").getAsJsonArray()) {
            object = elem.getAsJsonObject();
            if (!object.get("value").getAsBoolean()) continue;
            if (!attendTypeValues.isEmpty()) {
                attendTypeValues = attendTypeValues + ", ";
            }
            attendTypeValues = attendTypeValues + object.get("type");
        }
        for (JsonElement elem : filters.get("curricularPlans").getAsJsonArray()) {
            object = elem.getAsJsonObject();
            if (!object.get("value").getAsBoolean()) continue;
            if (!degreeNameValues.isEmpty()) {
                degreeNameValues = degreeNameValues + ", ";
            }
            degreeNameValues = degreeNameValues + object.get("name");
        }
        for (JsonElement elem : filters.get("shifts").getAsJsonArray()) {
            object = elem.getAsJsonObject();
            if (!object.get("value").getAsBoolean()) continue;
            if (!shiftsValues.isEmpty()) {
                shiftsValues = shiftsValues + ", ";
            }
            shiftsValues = shiftsValues + object.get("name");
        }
        for (JsonElement elem : filters.get("workingStudentTypes").getAsJsonArray()) {
            object = elem.getAsJsonObject();
            if (!object.get("value").getAsBoolean()) continue;
            if (!workingStudentsValues.isEmpty()) {
                workingStudentsValues = workingStudentsValues + ", ";
            }
            workingStudentsValues = workingStudentsValues + object.get("name");
        }
        String label = String.format("%s : %s \n%s : %s \n%s : %s \n%s", BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.selectStudents", (String[])new String[0]), attendTypeValues, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.attends.courses", (String[])new String[0]), degreeNameValues, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.selectShift", (String[])new String[0]), shiftsValues, workingStudentsValues);
        TreeSet<User> users = new TreeSet<User>(User.COMPARATOR_BY_NAME);
        for (JsonElement elem : new JsonParser().parse(filteredAttendsJson).getAsJsonArray()) {
            JsonObject object2 = elem.getAsJsonObject();
            users.add(((Attends)FenixFramework.getDomainObject((String)object2.get("id").getAsString())).getRegistration().getPerson().getUser());
        }
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        recipients.add(Recipient.newInstance(label, UserGroup.of(users)));
        String sendEmailUrl = UriBuilder.fromUri((String)"/messaging/emails.do").queryParam("method", new Object[]{"newEmail"}).queryParam("sender", new Object[]{ExecutionCourseSender.newInstance(this.executionCourse).getExternalId()}).queryParam("recipient", recipients.stream().filter(r -> r != null).map(r -> r.getExternalId()).toArray()).build(new Object[0]).toString();
        String sendEmailWithChecksumUrl = GenericChecksumRewriter.injectChecksumInUrl((String)request.getContextPath(), (String)sendEmailUrl, (HttpSession)session);
        return new RedirectView(sendEmailWithChecksumUrl, true);
    }
}

