/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.scientificCouncil.curricularPlans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.faces.component.html.HtmlInputText;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.DegreeSpecializationArea;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.ChangeDegreeOfficialPublicationReference;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegree;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegreeOfficialPublication;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegreeSpecializationArea;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.DeleteDegree;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.DeleteDegreeSpecializationArea;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.EditDegree;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;

public class DegreeManagementBackingBean
extends FenixBackingBean {
    private static final Logger logger = LoggerFactory.getLogger(DegreeManagementBackingBean.class);
    private final String NO_SELECTION = "noSelection";
    private String degreeId;
    private Degree degree;
    private String name;
    private String nameEn;
    private String acronym;
    private String bolonhaDegreeType;
    private String gradeScale;
    private Double ectsCredits;
    private String prevailingScientificArea;
    private String selectedExecutionYearID;
    private String academicAdminOfficeId;
    private String code;
    private String ministryCode;
    private HtmlInputText nameInputComponent;
    private HtmlInputText nameEnInputComponent;
    private final List<OfficialPubBeanPrint> officialPublicationsBeanPrettyPrints = new ArrayList<OfficialPubBeanPrint>();
    private OfficialPublicationBean officialPublicationBean;
    private boolean pairsCreated;
    private String degreeOfficialPublicationId;

    public String getDegreeOfficialPublicationId() {
        return this.degreeOfficialPublicationId;
    }

    public void setDegreeOfficialPublicationId(String degreeOfficialPublicationId) {
        this.degreeOfficialPublicationId = degreeOfficialPublicationId;
    }

    public List<Degree> getBolonhaDegrees() {
        List<Degree> result = Degree.readBolonhaDegrees();
        Collections.sort(result, Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        return result;
    }

    public List<Degree> getFilteredBolonhaDegrees() {
        HashSet<Degree> result = new HashSet<Degree>();
        for (Degree degree : Degree.readBolonhaDegrees()) {
            for (DegreeCurricularPlan dcp : degree.getDegreeCurricularPlansSet()) {
                if (!dcp.getCurricularStage().equals((Object)CurricularStage.PUBLISHED) && !dcp.getCurricularStage().equals((Object)CurricularStage.APPROVED) && !dcp.getCurricularPlanMembersGroup().isMember(this.getUserView())) continue;
                result.add(degree);
            }
        }
        ArrayList<Degree> orderedResult = new ArrayList<Degree>(result);
        Collections.sort(orderedResult, Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        return orderedResult;
    }

    public String getDegreeId() {
        return this.degreeId == null ? (this.degreeId = this.getAndHoldStringParameter("degreeId")) : this.degreeId;
    }

    public void setDegreeId(String degreeId) {
        this.degreeId = degreeId;
    }

    public Degree getDegree() {
        return this.degree == null ? (this.degree = (Degree)FenixFramework.getDomainObject((String)this.getDegreeId())) : this.degree;
    }

    public String getName() {
        return this.name == null && this.getDegree() != null ? (this.name = this.getDegree().getNameFor(this.getSelectedExecutionYear()).getContent(MultiLanguageString.pt)) : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameEn() {
        return this.nameEn == null && this.getDegree() != null ? (this.nameEn = this.getDegree().getNameFor(this.getSelectedExecutionYear()).getContent(MultiLanguageString.en)) : this.nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getAcronym() {
        return this.acronym == null && this.getDegree() != null ? (this.acronym = this.getDegree().getSigla()) : this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public String getBolonhaDegreeType() {
        return this.bolonhaDegreeType == null && this.getDegree() != null ? (this.bolonhaDegreeType = this.getDegree().getDegreeType().getExternalId()) : this.bolonhaDegreeType;
    }

    public DegreeType getDegreeType() {
        return (DegreeType)FenixFramework.getDomainObject((String)this.getBolonhaDegreeType());
    }

    public void setBolonhaDegreeType(String bolonhaDegreeType) {
        this.bolonhaDegreeType = bolonhaDegreeType;
    }

    public String getGradeScale() {
        return this.gradeScale == null && this.getDegree() != null ? (this.gradeScale = this.getDegree().getGradeScale() != null ? this.getDegree().getGradeScale().getName() : null) : this.gradeScale;
    }

    public void setGradeScale(String gradeScale) {
        this.gradeScale = gradeScale;
    }

    public String getCode() {
        return this.code == null && this.getDegree() != null ? (this.code = this.getDegree().getCode()) : this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMinistryCode() {
        return this.ministryCode == null && this.getDegree() != null ? (this.ministryCode = this.getDegree().getMinistryCode()) : this.ministryCode;
    }

    public void setMinistryCode(String ministryCode) {
        this.ministryCode = ministryCode;
    }

    public Double getEctsCredits() {
        if (this.ectsCredits == null) {
            if (this.getDegree() != null) {
                this.ectsCredits = this.getDegree().getEctsCredits();
            } else if (this.getBolonhaDegreeType() != null && !this.getBolonhaDegreeType().equals("noSelection")) {
                this.ectsCredits = 0.0;
            }
        }
        return this.ectsCredits;
    }

    public void setEctsCredits(Double ectsCredits) {
        this.ectsCredits = ectsCredits;
    }

    public String getPrevailingScientificArea() {
        return this.prevailingScientificArea == null && this.getDegree() != null ? (this.prevailingScientificArea = this.getDegree().getPrevailingScientificArea()) : this.prevailingScientificArea;
    }

    public void setPrevailingScientificArea(String prevailingScientificArea) {
        this.prevailingScientificArea = prevailingScientificArea;
    }

    public List<SelectItem> getBolonhaDegreeTypes() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose", (String[])new String[0])));
        DegreeType.all().filter(type -> !type.isEmpty()).filter(DegreeType::isBolonhaType).forEach(type -> result.add(new SelectItem((Object)type.getExternalId(), type.getName().getContent())));
        return result;
    }

    public List<SelectItem> getAcademicAdminOffices() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose", (String[])new String[0])));
        for (AdministrativeOffice administrativeOffice : rootDomainObject.getAdministrativeOfficesSet()) {
            result.add(new SelectItem((Object)administrativeOffice.getExternalId(), administrativeOffice.getName().getContent()));
        }
        return result;
    }

    public List<SelectItem> getGradeScales() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose", (String[])new String[0])));
        result.add(new SelectItem((Object)GradeScale.TYPE20.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)GradeScale.TYPE20.name(), (String[])new String[0])));
        result.add(new SelectItem((Object)GradeScale.TYPE5.name(), BundleUtil.getString((String)"resources.EnumerationResources", (String)GradeScale.TYPE5.name(), (String[])new String[0])));
        return result;
    }

    public String createDegree() {
        if (this.bolonhaDegreeType.equals(this.NO_SELECTION)) {
            this.setErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose.degreeType", (String[])new String[0]));
            return "";
        }
        if (this.getAcademicAdminOfficeId().equals(this.NO_SELECTION)) {
            this.setErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose.administrativeOffice", (String[])new String[0]));
            return "";
        }
        if (this.name == null || this.name.length() == 0 || this.nameEn == null || this.nameEn.length() == 0 || this.acronym == null || this.acronym.length() == 0 || this.gradeScale.equals(this.NO_SELECTION)) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"please.fill.mandatory.fields", (String[])new String[0]));
            return "";
        }
        try {
            AdministrativeOffice administrativeOffice = (AdministrativeOffice)FenixFramework.getDomainObject((String)this.getAcademicAdminOfficeId());
            CreateDegree.run(this.name, this.nameEn, this.acronym, (DegreeType)FenixFramework.getDomainObject((String)this.bolonhaDegreeType), this.getEctsCredits(), GradeScale.valueOf(this.gradeScale), this.prevailingScientificArea, administrativeOffice);
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.creatingDegree", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degree.created", (String[])new String[0]));
        return "curricularPlansManagement";
    }

    public String editDegree() {
        if (this.bolonhaDegreeType != null && this.bolonhaDegreeType.equals(this.NO_SELECTION) || this.gradeScale.equals(this.NO_SELECTION)) {
            this.setErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"choose.request", (String[])new String[0]));
            return "";
        }
        String name = (String)this.getNameInputComponent().getValue();
        String nameEn = (String)this.getNameEnInputComponent().getValue();
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)nameEn) || StringUtils.isEmpty((String)this.acronym)) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"please.fill.mandatory.fields", (String[])new String[0]));
            return "";
        }
        try {
            EditDegree.run(this.getDegreeId(), name, nameEn, this.acronym, (DegreeType)FenixFramework.getDomainObject((String)this.getBolonhaDegreeType()), this.getEctsCredits(), GradeScale.valueOf(this.gradeScale), this.prevailingScientificArea, this.getSelectedExecutionYear(), this.getCode(), this.getMinistryCode());
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.editingDegree", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degree.edited", (String[])new String[0]));
        return "curricularPlansManagement";
    }

    public String deleteDegree() {
        try {
            DeleteDegree.run(this.getDegreeId());
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage());
            return "curricularPlansManagement";
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.deletingDegree", (String[])new String[0]));
            return "curricularPlansManagement";
        }
        this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degree.deleted", (String[])new String[0]));
        return "curricularPlansManagement";
    }

    public void setSelectedExecutionYearId(String executionYearId) {
        this.selectedExecutionYearID = executionYearId;
    }

    public void onChangeExecutionYear(ValueChangeEvent valueChangeEvent) {
        String executionYearId = (String)valueChangeEvent.getNewValue();
        if (!this.getSelectedExecutionYearId().equals(executionYearId) && this.getDegree() != null) {
            this.setSelectedExecutionYearId(executionYearId);
            ExecutionYear executionYear = this.getSelectedExecutionYear();
            DegreeInfo degreeInfo = this.getDegree().getMostRecentDegreeInfo(executionYear);
            if (degreeInfo == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.Degree.doesnot.have.degreeInfo.for.year", (String[])new String[]{executionYear.getName()}));
                degreeInfo = this.getDegree().getMostRecentDegreeInfo();
            }
            if (degreeInfo != null) {
                this.name = degreeInfo.getName().getContent(MultiLanguageString.pt);
                this.nameEn = degreeInfo.getName().getContent(MultiLanguageString.en);
                this.nameInputComponent.setValue((Object)degreeInfo.getName().getContent(MultiLanguageString.pt));
                this.nameEnInputComponent.setValue((Object)degreeInfo.getName().getContent(MultiLanguageString.en));
            }
        }
    }

    public String getSelectedExecutionYearId() {
        if (this.selectedExecutionYearID == null) {
            this.selectedExecutionYearID = this.getAndHoldStringParameter("selectedExecutionYearId");
            if (this.selectedExecutionYearID == null) {
                this.selectedExecutionYearID = ExecutionYear.readCurrentExecutionYear().getExternalId();
            }
        }
        return this.selectedExecutionYearID;
    }

    public ExecutionYear getSelectedExecutionYear() {
        return (ExecutionYear)FenixFramework.getDomainObject((String)this.getSelectedExecutionYearId());
    }

    public List<SelectItem> getOpenExecutionYears() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ExecutionYear executionYear : ExecutionYear.readNotClosedExecutionYears()) {
            selectItems.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
        }
        return selectItems;
    }

    public HtmlInputText getNameInputComponent() {
        if (this.nameInputComponent == null) {
            this.nameInputComponent = new HtmlInputText();
            ExecutionYear executionYear = this.getSelectedExecutionYear() != null ? this.getSelectedExecutionYear() : ExecutionYear.readCurrentExecutionYear();
            DegreeInfo degreeInfo = this.getDegreeInfo(executionYear);
            this.setSelectedExecutionYearId(degreeInfo.getExecutionYear().getExternalId());
            this.nameInputComponent.setValue((Object)degreeInfo.getName().getContent(MultiLanguageString.pt));
        }
        return this.nameInputComponent;
    }

    public void setNameInputComponent(HtmlInputText nameInputComponent) {
        this.nameInputComponent = nameInputComponent;
    }

    public HtmlInputText getNameEnInputComponent() {
        if (this.nameEnInputComponent == null) {
            this.nameEnInputComponent = new HtmlInputText();
            ExecutionYear executionYear = this.getSelectedExecutionYear() != null ? this.getSelectedExecutionYear() : ExecutionYear.readCurrentExecutionYear();
            DegreeInfo degreeInfo = this.getDegreeInfo(executionYear);
            this.nameEnInputComponent.setValue((Object)degreeInfo.getName().getContent(MultiLanguageString.en));
        }
        return this.nameEnInputComponent;
    }

    public void setNameEnInputComponent(HtmlInputText nameEnInputComponent) {
        this.nameEnInputComponent = nameEnInputComponent;
    }

    private DegreeInfo getDegreeInfo(ExecutionYear executionYear) {
        DegreeInfo degreeInfo = this.getDegree().getDegreeInfoFor(executionYear);
        if (degreeInfo == null) {
            degreeInfo = this.getDegree().getMostRecentDegreeInfo();
        }
        return degreeInfo;
    }

    public boolean isAbleToEditName() {
        return DegreeInfo.isEditable(this.getDegreeInfo(this.getSelectedExecutionYear()));
    }

    public OfficialPublicationBean getOfficialPublicationBean() {
        if (this.officialPublicationBean == null) {
            this.officialPublicationBean = new OfficialPublicationBean(this);
        }
        return this.officialPublicationBean;
    }

    public List<OfficialPubBeanPrint> getOfficialPublicationsBeanPrettyPrints() {
        Degree degree = this.getDegree();
        if (degree == null) {
            throw new RuntimeException("GONE!!!!");
        }
        if (this.officialPublicationsBeanPrettyPrints.size() == degree.getOfficialPublicationSet().size()) {
            return this.officialPublicationsBeanPrettyPrints;
        }
        this.officialPublicationsBeanPrettyPrints.clear();
        for (DegreeOfficialPublication degreeOfficialPublication : this.getDegree().getOfficialPublicationSet()) {
            this.officialPublicationsBeanPrettyPrints.add(new OfficialPubBeanPrint(degreeOfficialPublication));
        }
        return this.officialPublicationsBeanPrettyPrints;
    }

    public String getAcademicAdminOfficeId() {
        return this.academicAdminOfficeId;
    }

    public void setAcademicAdminOfficeId(String academicAdminOfficeId) {
        this.academicAdminOfficeId = academicAdminOfficeId;
    }

    public static class OfficialPublicationBean
    extends DegreeManagementBackingBean {
        private String date;
        private String officialReference;
        private String officialPubId;
        private DegreeOfficialPublication degreeOfficialPublication;
        private String newOfficialReference;
        private String specializationNameEng;
        private String specializationNamePt;
        private List<Pair> specializationNames;
        private String specializationIdToDelete;
        private DegreeSpecializationArea specializationAreaToDelete;
        private DegreeOfficialPublication degreeOfficialPublicationGoBack;
        private final DegreeManagementBackingBean degreeManagementBackingBean;

        public OfficialPublicationBean(DegreeManagementBackingBean degreeManagementBackingBean) {
            this.degreeManagementBackingBean = degreeManagementBackingBean;
            ((DegreeManagementBackingBean)this).pairsCreated = true;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getOfficialReference() {
            return this.officialReference;
        }

        public void setOfficialReference(String officialReference) {
            this.officialReference = officialReference;
        }

        public String makeAndInsertDegreeOfficialPublication() {
            if (this.date == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.protocol.invalidDates", (String[])new String[0]));
                return "";
            }
            String[] dateFields = this.date.split("/");
            if (dateFields.length != 3) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.protocol.invalidDates", (String[])new String[0]));
                return "";
            }
            if (dateFields[0].length() != 2 || dateFields[1].length() != 2 || dateFields[2].length() != 4) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.protocol.invalidDates", (String[])new String[0]));
                return "";
            }
            if (this.officialReference.isEmpty() || this.officialReference.compareTo("") == 0) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"confirm.error.edit.reference.officialPublication", (String[])new String[0]));
                return "";
            }
            LocalDate localDate = new LocalDate(Integer.parseInt(dateFields[2]), Integer.parseInt(dateFields[1]), Integer.parseInt(dateFields[0]));
            Degree degree = this.getDegree();
            try {
                CreateDegreeOfficialPublication.run(degree, localDate, this.officialReference);
            }
            catch (IllegalDataAccessException e) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
                return "";
            }
            catch (DomainException e) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
                return "";
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.addInfoMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"degreeOfficialPublication.created", (String[])new String[0]));
            return "editDegree";
        }

        public String getOfficialPubId() {
            return this.officialPubId == null ? (this.officialPubId = this.getAndHoldStringParameter("officialPubId")) : this.officialPubId;
        }

        public void setOfficialPubId(String officialPubId) {
            this.officialPubId = officialPubId;
        }

        public DegreeOfficialPublication getDegreeOfficialPublication() {
            this.degreeOfficialPublication = this.getOfficialPubId() == null ? null : (DegreeOfficialPublication)FenixFramework.getDomainObject((String)this.getOfficialPubId());
            return this.degreeOfficialPublication;
        }

        public void setDegreeOfficialPublication(DegreeOfficialPublication degreeOfficialPublication) {
            this.degreeOfficialPublication = degreeOfficialPublication;
        }

        public String getSpecializationNameEng() {
            return this.specializationNameEng;
        }

        public void setSpecializationNameEng(String specializationNameEng) {
            this.specializationNameEng = specializationNameEng;
        }

        public String getSpecializationNamePt() {
            return this.specializationNamePt;
        }

        public void setSpecializationNamePt(String specializationNamePt) {
            this.specializationNamePt = specializationNamePt;
        }

        public void addSpecializationArea() {
            try {
                CreateDegreeSpecializationArea.run(this.getDegreeOfficialPublication(), this.getSpecializationNameEng(), this.getSpecializationNamePt());
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public String getSpecializationIdToDelete() {
            return this.specializationIdToDelete == null ? (this.specializationIdToDelete = this.getAndHoldStringParameter("specializationId")) : this.specializationIdToDelete;
        }

        public void setSpecializationIdToDelete(String specializationIdToDelete) {
            this.specializationIdToDelete = specializationIdToDelete;
        }

        public DegreeSpecializationArea getSpecializationAreaToDelete() {
            this.specializationAreaToDelete = (DegreeSpecializationArea)(this.getSpecializationIdToDelete() == null ? null : FenixFramework.getDomainObject((String)this.getSpecializationIdToDelete()));
            if (this.getDegreeOfficialPublicationGoBack() == null && this.specializationAreaToDelete != null) {
                this.setDegreeOfficialPublicationGoBack(this.specializationAreaToDelete.getOfficialPublication());
            }
            return this.specializationAreaToDelete;
        }

        public void setSpecializationAreaToDelete(DegreeSpecializationArea specializationAreaToDelete) {
            this.specializationAreaToDelete = specializationAreaToDelete;
        }

        public String removeSpecializationAreaToDelete() {
            this.setDegreeOfficialPublicationGoBack(this.getSpecializationAreaToDelete().getOfficialPublication());
            try {
                DeleteDegreeSpecializationArea.run(this.getSpecializationAreaToDelete().getOfficialPublication(), this.getSpecializationAreaToDelete());
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return "editDegreeOfficialPublication";
        }

        public DegreeOfficialPublication getDegreeOfficialPublicationGoBack() {
            return this.degreeOfficialPublicationGoBack;
        }

        public void setDegreeOfficialPublicationGoBack(DegreeOfficialPublication degreeOfficialPublicationGoBack) {
            this.degreeOfficialPublicationGoBack = degreeOfficialPublicationGoBack;
        }

        public String getNewOfficialReference() {
            if (this.getDegreeOfficialPublication() != null && (this.newOfficialReference == null || this.newOfficialReference.isEmpty())) {
                this.newOfficialReference = this.getDegreeOfficialPublication().getOfficialReference();
            }
            return this.newOfficialReference;
        }

        public void setNewOfficialReference(String newOfficialReference) {
            this.newOfficialReference = newOfficialReference;
        }

        public List<Pair> getSpecializationNames() {
            ArrayList<Pair> specializations = null;
            if (this.getDegreeOfficialPublication() != null && this.specializationNames == null) {
                specializations = new ArrayList<Pair>();
                for (DegreeSpecializationArea area : this.getDegreeOfficialPublication().getSpecializationAreaSet()) {
                    specializations.add(new Pair(area));
                }
                this.specializationNames = specializations;
            }
            return this.specializationNames;
        }

        public void changeOfficialReference() {
            try {
                ChangeDegreeOfficialPublicationReference.run(this.getDegreeOfficialPublication(), this.getNewOfficialReference());
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public boolean arePairsDifferent() {
            List<Pair> pairs = this.specializationNames;
            for (Pair pair : pairs) {
                if (!pair.isModified()) continue;
                return true;
            }
            return false;
        }

        public String saveOfficialPublicationContent() throws FenixServiceException {
            String newOfficialReferece = this.getNewOfficialReference();
            String engName = this.getSpecializationNameEng();
            String portName = this.getSpecializationNamePt();
            DegreeOfficialPublication degreeOfficialPublication = this.getDegreeOfficialPublication();
            if (newOfficialReferece != null && newOfficialReferece.compareTo("") != 0 && newOfficialReferece.compareTo(this.getDegreeOfficialPublication().getOfficialReference()) != 0) {
                this.changeOfficialReference();
            }
            if (engName != null && engName.compareTo("") != 0 && portName != null && portName.compareTo("") != 0) {
                this.addSpecializationArea();
                this.specializationNames.clear();
            }
            return "editDegree";
        }

        public void removeOfficialPublication() {
            logger.info(this.degreeOfficialPublication.toString());
        }

        public static class Pair
        extends FenixBackingBean {
            private String firstValue;
            private String secondValue;
            private final DegreeSpecializationArea areaReference;

            public Pair(DegreeSpecializationArea area) {
                this.firstValue = area.getNameEn() == null ? "" : area.getNameEn();
                this.secondValue = area.getNamePt() == null ? "" : area.getNamePt();
                this.areaReference = area;
            }

            public String getFirstValue() {
                return this.firstValue;
            }

            public void setFirstValue(String firstValue) {
                this.firstValue = firstValue;
            }

            public String getSecondValue() {
                return this.secondValue;
            }

            public void setSecondValue(String secondValue) {
                this.secondValue = secondValue;
            }

            public void updateFirstValue() {
                this.firstValue = this.areaReference.getNameEn();
            }

            public void updateSecondValue() {
                this.secondValue = this.areaReference.getNamePt();
            }

            public DegreeSpecializationArea getAreaReference() {
                return this.areaReference;
            }

            public boolean isEnModified() {
                String nameEng = this.areaReference.getNameEn();
                if (nameEng != null) {
                    return nameEng.compareTo(this.firstValue) != 0;
                }
                return this.firstValue != null || this.firstValue.compareTo("") != 0;
            }

            public boolean isPtModified() {
                String namePt = this.areaReference.getNamePt();
                if (namePt != null) {
                    return namePt.compareTo(this.secondValue) != 0;
                }
                return this.secondValue != null || this.secondValue.compareTo("") != 0;
            }

            public boolean isModified() {
                return this.isEnModified() || this.isPtModified();
            }
        }
    }

    public class OfficialPubBeanPrint {
        private final DegreeOfficialPublication degreeOfficialPublication;
        private final String date;
        private final String officialReference;
        private final String specializationsAreas;

        public OfficialPubBeanPrint(DegreeOfficialPublication degreeOfficialPublication) {
            this.degreeOfficialPublication = degreeOfficialPublication;
            this.date = degreeOfficialPublication.getPublication().toString();
            this.officialReference = degreeOfficialPublication.getOfficialReference();
            this.specializationsAreas = this.fetchSpecializationAreas(degreeOfficialPublication);
        }

        public DegreeOfficialPublication getDegreeOfficialPublication() {
            return this.degreeOfficialPublication;
        }

        public String getOfficialReference() {
            return this.officialReference;
        }

        public String getSpecializationsAreas() {
            return this.specializationsAreas;
        }

        public String getDate() {
            return this.date;
        }

        public String fetchSpecializationAreas(DegreeOfficialPublication degreeOfficialPublication) {
            String specializationAreas = "";
            if (degreeOfficialPublication == null) {
                throw new RuntimeException("que bodega..");
            }
            for (DegreeSpecializationArea specializationArea : degreeOfficialPublication.getSpecializationAreaSet()) {
                specializationAreas = specializationAreas + (specializationAreas.compareTo("") == 0 ? "" : ", ") + specializationArea.getName().toString();
            }
            return specializationAreas;
        }
    }
}

