/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.base;

import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.ui.faces.components.UIViewState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.I18N;

public class FenixBackingBean {
    protected String errorMessage;
    protected String[] errorMessageArguments;
    private UIViewState viewState;
    protected static final Bennu rootDomainObject = Bennu.getInstance();

    public FenixBackingBean() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Locale locale = I18N.getLocale();
        facesContext.getViewRoot().setLocale(locale);
    }

    public User getUserView() {
        return Authenticate.getUser();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
    }

    protected String getRequestParameter(String parameterName) {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(parameterName);
    }

    protected String[] getRequestParameterValues(String parameterName) {
        return (String[])FacesContext.getCurrentInstance().getExternalContext().getRequestParameterValuesMap().get(parameterName);
    }

    protected Object getRequestAttribute(String attributeName) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(attributeName);
    }

    protected void setRequestAttribute(String attributeName, Object attributeValue) {
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(attributeName, attributeValue);
    }

    public String getContextPath() {
        return ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getContextPath();
    }

    public UIViewState getViewState() {
        if (this.viewState == null) {
            this.viewState = new UIViewState();
        }
        return this.viewState;
    }

    public void setViewState(UIViewState viewState) {
        this.viewState = viewState;
    }

    private void addMessage(FacesMessage.Severity facesMessage, String message) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage(facesMessage, message, null));
    }

    protected void addErrorMessage(String message) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, message);
    }

    protected void addInfoMessage(String message) {
        this.addMessage(FacesMessage.SEVERITY_INFO, message);
    }

    protected void addWarnMessage(String message) {
        this.addMessage(FacesMessage.SEVERITY_WARN, message);
    }

    protected Integer getAndHoldIntegerParameter(String parameterName) {
        Integer parameterValue;
        String parameterString = this.getRequestParameter(parameterName);
        if (parameterString != null && parameterString.length() > 0) {
            parameterValue = Integer.valueOf(parameterString);
            this.setRequestAttribute(parameterName, parameterValue);
        } else {
            parameterValue = null;
        }
        return parameterValue;
    }

    protected String getAndHoldStringParameter(String parameterName) {
        String parameterValue;
        String parameterString = this.getRequestParameter(parameterName);
        if (parameterString != null && parameterString.length() > 0) {
            parameterValue = parameterString;
            this.setRequestAttribute(parameterName, parameterValue);
        } else {
            parameterValue = null;
        }
        return parameterValue;
    }

    protected Boolean getAndHoldBooleanParameter(String parameterName) {
        Boolean parameterValue;
        String parameterString = this.getRequestParameter(parameterName);
        if (parameterString != null && parameterString.length() > 0) {
            parameterValue = Boolean.valueOf(parameterString);
            this.setRequestAttribute(parameterName, parameterValue);
        } else {
            parameterValue = null;
        }
        return parameterValue;
    }

    private String formatMessage(String message, String ... args) {
        if (message != null && args != null) {
            for (int i = 0; args.length > i; ++i) {
                String substring = "{" + i + "}";
                message = StringUtils.replace((String)message, (String)substring, (String)args[i]);
            }
        }
        return message;
    }

    protected Double getAndHoldDoubleParameter(String parameterName) {
        Double parameterValue;
        String parameterString = this.getRequestParameter(parameterName);
        if (parameterString != null && parameterString.length() > 0) {
            parameterValue = Double.valueOf(parameterString);
            this.setRequestAttribute(parameterName, parameterValue);
        } else {
            parameterValue = null;
        }
        return parameterValue;
    }

    public String[] getErrorMessageArguments() {
        return this.errorMessageArguments;
    }

    public String getErrorMessageArgument() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorMessageArguments != null) {
            for (String string : this.errorMessageArguments) {
                stringBuilder.append(" ").append(string);
            }
        }
        return stringBuilder.toString();
    }

    public void setErrorMessageArguments(String[] errorMessageArguments) {
        this.errorMessageArguments = errorMessageArguments;
    }

    public Boolean getRenderInEnglish() {
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        return locale.getLanguage().equals(Locale.ENGLISH.getLanguage());
    }

    public boolean isMessagesEmpty() {
        return FacesContext.getCurrentInstance().getMessages().hasNext();
    }

    public String getHasChecksumString() {
        return "<!-- NO_CHECKSUM -->";
    }

    public String getInstitutionUrl() {
        return Installation.getInstance() == null ? "" : Installation.getInstance().getInstituitionURL();
    }

    public String getInstitutionAcronym() {
        return Unit.getInstitutionAcronym();
    }

    public String getApplicationUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl();
    }
}

