/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.service.GOPSendMessageService$callable$requestChangeRoom;
import org.fenixedu.academic.service.GOPSendMessageService$callable$requestRoom;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.core.service.NotificationService;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.requests.OccupationComment;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GOPSendMessageService
implements NotificationService {
    private static final Logger logger;
    private static Sender GOP_SENDER;
    public static final Advice advice$requestRoom;
    public static final Advice advice$requestChangeRoom;

    private static Sender getGOPSender() {
        if (GOP_SENDER == null && (GOP_SENDER = GOPSendMessageService.initGOPSender()) == null) {
            logger.warn("WARN: GOPSender couldn't be found, using SystemSender ...");
            GOP_SENDER = Bennu.getInstance().getSystemSender();
        }
        return GOP_SENDER;
    }

    private static Sender initGOPSender() {
        for (Sender sender : Sender.getAvailableSenders()) {
            Group members = sender.getMembers();
            if (!members.equals((Object)RoleType.RESOURCE_ALLOCATION_MANAGER.actualGroup())) continue;
            return sender;
        }
        return null;
    }

    public static void requestRoom(WrittenTest writtenTest) {
        Object object = advice$requestRoom.perform((Callable)new GOPSendMessageService$callable$requestRoom(writtenTest));
    }

    static /* synthetic */ void advised$requestRoom(WrittenTest test) {
        String date = new SimpleDateFormat("dd/MM/yyyy").format(test.getDay().getTime());
        String time = new SimpleDateFormat("HH:mm").format(test.getBeginning().getTime());
        String endTime = new SimpleDateFormat("HH:mm").format(test.getEnd().getTime());
        HashSet<String> courseNames = new HashSet<String>();
        HashSet<String> degreeNames = new HashSet<String>();
        HashSet<ExecutionDegree> degrees = new HashSet<ExecutionDegree>();
        for (ExecutionCourse course : test.getAssociatedExecutionCoursesSet()) {
            courseNames.add(course.getName());
            degreeNames.add(course.getDegreePresentationString());
            degrees.addAll(course.getExecutionDegrees());
        }
        String degreesString = StringUtils.join(degreeNames, (String)",");
        String coursesString = StringUtils.join(courseNames, (String)",");
        String subject = BundleUtil.getString((String)"resources.ApplicationResources", (String)"email.request.room.subject", (String[])new String[]{coursesString, test.getDescription()});
        String body = BundleUtil.getString((String)"resources.ApplicationResources", (String)"email.request.room.body", (String[])new String[]{test.getDescription(), coursesString, date, time, degreesString, endTime});
        for (String email : GOPSendMessageService.getGOPEmail(degrees)) {
            new Message(GOPSendMessageService.getGOPSender(), email, subject, body);
        }
        test.setRequestRoomSentDate(new DateTime());
    }

    public static void requestChangeRoom(WrittenTest writtenTest, Date date, Date date2, Date date3) {
        Object object = advice$requestChangeRoom.perform((Callable)new GOPSendMessageService$callable$requestChangeRoom(writtenTest, date, date2, date3));
    }

    static /* synthetic */ void advised$requestChangeRoom(WrittenTest test, Date oldDay, Date oldBeginning, Date oldEnd) {
        String oldDate = new SimpleDateFormat("dd/MM/yyyy").format(oldDay);
        String oldStartTime = new SimpleDateFormat("HH:mm").format(oldBeginning);
        String oldEndTime = new SimpleDateFormat("HH:mm").format(oldEnd);
        String date = new SimpleDateFormat("dd/MM/yyyy").format(test.getDay().getTime());
        String startTime = new SimpleDateFormat("HH:mm").format(test.getBeginning().getTime());
        String endTime = new SimpleDateFormat("HH:mm").format(test.getEnd().getTime());
        HashSet<String> courseNames = new HashSet<String>();
        HashSet<String> degreeNames = new HashSet<String>();
        HashSet<ExecutionDegree> degrees = new HashSet<ExecutionDegree>();
        for (ExecutionCourse course : test.getAssociatedExecutionCoursesSet()) {
            courseNames.add(course.getName());
            degreeNames.add(course.getDegreePresentationString());
            degrees.addAll(course.getExecutionDegrees());
        }
        String coursesString = StringUtils.join(courseNames, (String)",");
        String degreesString = StringUtils.join(degreeNames, (String)",");
        String subject = BundleUtil.getString((String)"resources.ApplicationResources", (String)"email.request.room.subject.edit", (String[])new String[]{coursesString, test.getDescription()});
        String body = BundleUtil.getString((String)"resources.ApplicationResources", (String)"email.request.room.body.edit", (String[])new String[]{test.getDescription(), coursesString, degreesString, test.getRequestRoomSentDateString(), oldDate, oldStartTime, oldEndTime, date, startTime, endTime});
        for (String email : GOPSendMessageService.getGOPEmail(degrees)) {
            new Message(GOPSendMessageService.getGOPSender(), email, subject, body);
        }
        test.setRequestRoomSentDate(new DateTime());
    }

    private static Set<String> getGOPEmail(Collection<ExecutionDegree> degrees) {
        HashSet<String> emails = new HashSet<String>();
        for (ExecutionDegree executionDegree : degrees) {
            String emailFromApplicationResources = BundleUtil.getString((String)"resources.ApplicationResources", (String)("email.gop." + executionDegree.getCampus().getName()), (String[])new String[0]);
            if (StringUtils.isEmpty((String)emailFromApplicationResources)) continue;
            emails.add(emailFromApplicationResources);
        }
        return emails;
    }

    public boolean notify(OccupationRequest request) {
        MessageResources messages = MessageResources.getMessageResources((String)"resources/ResourceAllocationManagerResources");
        String body = messages.getMessage("message.room.reservation.solved") + "\n\n" + messages.getMessage("message.room.reservation.request.number") + "\n" + request.getIdentification() + "\n\n";
        body = body + messages.getMessage("message.room.reservation.request") + "\n";
        body = request.getSubject() != null ? body + request.getSubject() : body + "-";
        body = body + "\n\n" + messages.getMessage("label.rooms.reserve.periods") + ":";
        for (Occupation occupation : request.getOccupationSet()) {
            body = body + "\n\t" + occupation.getSummary() + " - " + occupation.getSpaces().stream().map(Space::getName).collect(Collectors.joining(" "));
        }
        if (request.getOccupationSet().isEmpty()) {
            body = body + "\n" + messages.getMessage("label.rooms.reserve.periods.none");
        }
        body = body + "\n\n" + messages.getMessage("message.room.reservation.description") + "\n";
        body = request.getDescription() != null ? body + request.getDescription() : body + "-";
        OccupationComment occupationComment = (OccupationComment)request.getCommentSet().stream().sorted(OccupationComment.COMPARATOR_BY_INSTANT.reversed()).findFirst().get();
        body = body + "\n\n" + messages.getMessage("message.room.reservation.last.comment") + "\n";
        body = occupationComment != null ? body + occupationComment.getDescription() : body + "-";
        this.sendEmail(request.getRequestor().getPerson().getEmailForSendingEmails(), messages.getMessage("message.room.reservation"), body);
        return true;
    }

    public boolean sendEmail(String emails, String subject, String body) {
        if (!Strings.isNullOrEmpty((String)emails)) {
            Sender sender = GOPSendMessageService.getGOPSender();
            new Message(sender, sender.getConcreteReplyTos(), null, subject, body, emails);
            return true;
        }
        return false;
    }

    static {
        advice$requestRoom = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$requestChangeRoom = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(GOPSendMessageService.class);
        GOP_SENDER = null;
    }
}

