/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DegreeFinalizationCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;

public class DegreeFinalizationCertificate
extends AdministrativeOfficeDocument {
    protected DegreeFinalizationCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected DegreeFinalizationCertificateRequest getDocumentRequest() {
        return (DegreeFinalizationCertificateRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.fillFirstParagraph();
        this.fillSecondParagraph();
        DegreeFinalizationCertificateRequest req = this.getDocumentRequest();
        this.addParameter("degreeFinalizationInfo", this.getDegreeFinalizationInfo(req));
        this.fillInstitutionAndStaffFields();
        this.setFooter((DocumentRequest)((Object)req));
        this.setBranchField();
    }

    private void fillSecondParagraph() {
        DegreeFinalizationCertificateRequest req = this.getDocumentRequest();
        StringBuilder result = new StringBuilder();
        result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"conclusion.document.concluded.lowercase", (String[])new String[0]));
        result.append(" ");
        result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.the.male", (String[])new String[0]));
        result.append(" ");
        result.append(this.getDegreeDescription());
        result.append(",");
        if (this.getDocumentRequest().getBranch() == null || this.getDocumentRequest().getBranch().isEmpty()) {
            result.append("");
        } else {
            result.append(",");
        }
        result.append(this.getDegreeFinalizationDate(req));
        result.append(this.getExceptionalConclusionInfo(req));
        if (req.getAverage().booleanValue()) {
            result.append(DegreeFinalizationCertificate.getDegreeFinalizationGrade(req.getFinalAverage(), this.getLocale()));
        }
        result.append(this.getDegreeFinalizationEcts(req));
        result.append(req.getGraduateTitle(req.getLanguage()));
        result.append(this.getDiplomaDescription());
        result.append(this.getDetailedInfoIntro(req));
        this.addParameter("secondParagraph", result.toString());
    }

    protected void fillFirstParagraph() {
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(this.getLocale()), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
        this.addParameter("certificate", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.academicDocument.standaloneEnrolmentCertificate.secondParagraph", (String[])new String[0]));
    }

    private void setBranchField() {
        String branch = this.getDocumentRequest().getBranch();
        if (branch == null || branch.isEmpty()) {
            this.addParameter("branch", "");
            return;
        }
        this.addParameter("branch", " " + this.getDocumentRequest().getBranch());
    }

    @Override
    protected String getDegreeDescription() {
        return this.getRegistration().getDegreeDescription(this.getDocumentRequest().getConclusionYear(), this.getDocumentRequest().getProgramConclusion(), this.getDocumentRequest().getLanguage());
    }

    private String getDegreeFinalizationDate(DegreeFinalizationCertificateRequest request) {
        StringBuilder result = new StringBuilder();
        if (!request.mustHideConclusionDate()) {
            result.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.onThe", (String[])new String[0]));
            result.append(" ").append(request.getConclusionDate().toString("dd MMMM yyyy", this.getLocale()));
        }
        return result.toString();
    }

    private String getExceptionalConclusionInfo(DegreeFinalizationCertificateRequest request) {
        StringBuilder result = new StringBuilder();
        if (request.hasExceptionalConclusionInfo()) {
            if (request.getTechnicalEngineer().booleanValue()) {
                result.append(" ");
                result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.exceptionalConclusionInfo.technicalEngineer", (String[])new String[0]));
            } else {
                String date = request.getExceptionalConclusionDate().toString("dd MMMM yyyy", this.getLocale());
                if (request.getInternshipAbolished().booleanValue()) {
                    result.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.in", (String[])new String[0]));
                    result.append(" ").append(date);
                    result.append(", ");
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.exceptionalConclusionInfo.internshipAbolished", (String[])new String[0]));
                } else if (request.getInternshipApproved().booleanValue()) {
                    result.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.in", (String[])new String[0]));
                    result.append(" ").append(date);
                    result.append(", ");
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.exceptionalConclusionInfo.internshipApproved", (String[])new String[0]));
                } else if (request.getStudyPlan().booleanValue()) {
                    result.append(" ");
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.exceptionalConclusionInfo.studyPlan.one", (String[])new String[0]));
                    result.append(" ").append(date);
                    result.append(" ");
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.exceptionalConclusionInfo.studyPlan.two", (String[])new String[0]));
                }
            }
        }
        return result.toString();
    }

    public static final String getDegreeFinalizationGrade(Integer finalGrade) {
        return DegreeFinalizationCertificate.getDegreeFinalizationGrade(finalGrade, I18N.getLocale());
    }

    public static final String getDegreeFinalizationGrade(Integer finalGrade, Locale locale) {
        StringBuilder result = new StringBuilder();
        result.append(", ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"documents.registration.final.arithmetic.mean", (String[])new String[0]));
        result.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"label.of.both", (String[])new String[0]));
        result.append(" ").append(finalGrade);
        result.append(" (").append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)finalGrade.toString(), (String[])new String[0]));
        result.append(") ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"values", (String[])new String[0]));
        return result.toString();
    }

    private final String getDegreeFinalizationEcts(DegreeFinalizationCertificateRequest request) {
        StringBuilder res = new StringBuilder();
        if (this.getDocumentRequest().isToShowCredits()) {
            res.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.creditsInfo", (String[])new String[0]));
            res.append(" ").append(String.valueOf(request.getEctsCredits())).append(this.getCreditsDescription());
        }
        return res.toString();
    }

    private final String getDiplomaDescription() {
        StringBuilder res = new StringBuilder();
        Degree degree = this.getDocumentRequest().getDegree();
        DegreeType degreeType = degree.getDegreeType();
        if (!this.getDocumentRequest().getProgramConclusion().getGraduationTitle().isEmpty()) {
            res.append(", ");
            if (this.getDocumentRequest().getRegistryCode() != null) {
                res.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.registryNumber", (String[])new String[0]));
                res.append(" ");
                res.append(this.getDocumentRequest().getRegistryCode().getCode());
            } else {
                res.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.diplomaDescription.one", (String[])new String[0]));
                if (!degreeType.isAdvancedFormationDiploma()) {
                    if (degreeType.isSpecializationDegree()) {
                        res.append(" ");
                        res.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.diplomaDescription.diploma", (String[])new String[0]));
                    } else {
                        res.append(" ");
                        res.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.diplomaDescription.letter", (String[])new String[0]));
                    }
                }
            }
        }
        return res.toString();
    }

    private final String getDetailedInfoIntro(DegreeFinalizationCertificateRequest request) {
        StringBuilder res = new StringBuilder();
        if (request.getDetailed().booleanValue()) {
            res.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"documents.DegreeFinalizationCertificate.detailedInfoIntro", (String[])new String[0])).append(":");
        } else {
            res.append(".");
        }
        return res.toString();
    }

    private final String getDegreeFinalizationInfo(DegreeFinalizationCertificateRequest request) {
        StringBuilder result = new StringBuilder();
        if (request.getDetailed().booleanValue()) {
            TreeSet<ICurriculumEntry> entries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            entries.addAll(request.getEntriesToReport());
            HashMap<Unit, String> academicUnitIdentifiers = new HashMap<Unit, String>();
            this.reportEntries(result, entries, academicUnitIdentifiers);
            if (this.getDocumentRequest().isToShowCredits()) {
                result.append(this.getRemainingCreditsInfo(request.getCurriculum()));
            }
            result.append(this.generateEndLine());
            if (!academicUnitIdentifiers.isEmpty()) {
                result.append("\n").append(this.getAcademicUnitInfo(academicUnitIdentifiers, request.getMobilityProgram()));
            }
        }
        return result.toString();
    }

    private final void reportEntries(StringBuilder result, SortedSet<ICurriculumEntry> entries, Map<Unit, String> academicUnitIdentifiers) {
        for (ICurriculumEntry entry : entries) {
            this.reportEntry(result, entry, academicUnitIdentifiers);
        }
    }

    private final void reportEntry(StringBuilder result, ICurriculumEntry entry, Map<Unit, String> unitIDs) {
        result.append(FenixStringTools.multipleLineRightPadWithSuffix(this.getCurriculumEntryName(unitIDs, entry), 64, '-', this.getCreditsAndGradeInfo(entry))).append("\n");
    }

    private final String getCreditsAndGradeInfo(ICurriculumEntry entry) {
        StringBuilder result = new StringBuilder();
        if (this.getDocumentRequest().isToShowCredits()) {
            this.getCreditsInfo(result, entry);
        }
        result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"label.with", (String[])new String[0]));
        Grade grade = entry.getGrade();
        result.append(" ").append(grade.getValue());
        result.append(StringUtils.rightPad((String)("(" + grade.getExtendedValue().getContent(this.getDocumentRequest().getLanguage()) + ")"), (int)12, (char)' '));
        String values = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getDocumentRequest().getLanguage(), (String)"values", (String[])new String[0]);
        result.append(grade.isNumeric() ? values : StringUtils.rightPad((String)"", (int)values.length(), (char)' '));
        return result.toString();
    }

    @Override
    protected void addPriceFields() {
        DegreeFinalizationCertificateRequest certificateRequest = this.getDocumentRequest();
        CertificateRequestPR certificateRequestPR = (CertificateRequestPR)((Object)this.getPostingRule());
        Money amountPerPage = certificateRequestPR.getAmountPerPage();
        Money baseAmountPlusAmountForUnits = certificateRequestPR.getBaseAmount().add(certificateRequestPR.getAmountForUnits(certificateRequest.getNumberOfUnits()));
        Money urgencyAmount = certificateRequest.getUrgentRequest() != false ? certificateRequestPR.getBaseAmount() : Money.ZERO;
        this.addParameter("amountPerPage", amountPerPage);
        this.addParameter("baseAmountPlusAmountForUnits", baseAmountPlusAmountForUnits);
        this.addParameter("urgencyAmount", urgencyAmount);
        this.addParameter("printPriceFields", this.printPriceParameters((CertificateRequest)((Object)certificateRequest)));
    }
}

