/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum.curriculumLine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.enrolment.CurriculumModuleMoveWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.CurriculumLineLocationBean;

public class MoveCurriculumLinesBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StudentCurricularPlan studentCurricularPlan;
    private List<CurriculumLineLocationBean> curriculumLineLocations = new ArrayList<CurriculumLineLocationBean>();
    private boolean withRules = true;

    public MoveCurriculumLinesBean() {
    }

    public MoveCurriculumLinesBean(StudentCurricularPlan studentCurricularPlan) {
        this();
        this.setStudentCurricularPlan(studentCurricularPlan);
    }

    public List<CurriculumLineLocationBean> getCurriculumLineLocations() {
        return this.curriculumLineLocations;
    }

    public void setCurriculumLineLocations(List<CurriculumLineLocationBean> curriculumLineLocations) {
        this.curriculumLineLocations = curriculumLineLocations;
    }

    public void addCurriculumLineLocation(CurriculumLineLocationBean curriculumLineLocationBean) {
        this.curriculumLineLocations.add(curriculumLineLocationBean);
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public Set<IDegreeModuleToEvaluate> getIDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>();
        for (CurriculumLineLocationBean bean : this.curriculumLineLocations) {
            result.add(CurriculumModuleMoveWrapper.create(bean.getCurriculumGroup(), executionSemester));
        }
        return result;
    }

    public static MoveCurriculumLinesBean buildFrom(List<CurriculumLine> curriculumLines, boolean withRules) {
        MoveCurriculumLinesBean result = new MoveCurriculumLinesBean();
        for (CurriculumLine curriculumLine : curriculumLines) {
            result.addCurriculumLineLocation(CurriculumLineLocationBean.buildFrom(curriculumLine, withRules));
        }
        return result;
    }

    public boolean isWithRules() {
        return this.withRules;
    }

    public void withRules(boolean value) {
        this.withRules = value;
    }
}

