/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Comparator;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.RegistrationRegime_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class RegistrationRegime
extends RegistrationRegime_Base {
    public static Comparator<RegistrationRegime> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<RegistrationRegime>(){

        @Override
        public int compare(RegistrationRegime o1, RegistrationRegime o2) {
            return o1.getExecutionYear().compareTo(o2.getExecutionYear());
        }
    };
    private static Supplier<RegistrationRegimeVerifier> REGISTRATION_REGIME_VERIFIER = () -> new RegistrationRegimeVerifier(){

        @Override
        public void checkEctsCredits(Registration registration, ExecutionYear executionYear, RegistrationRegimeType type) {
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            double enroledEctsCredits = 0.0;
            for (ExecutionSemester semester : executionYear.getExecutionPeriodsSet()) {
                enroledEctsCredits += studentCurricularPlan.getAccumulatedEctsCredits(semester);
            }
            if (enroledEctsCredits > 20.25) {
                throw new DomainException("error.RegistrationRegime.semester.has.more.ects.than.maximum.allowed", String.valueOf(enroledEctsCredits), executionYear.getQualifiedName(), String.valueOf(20.25));
            }
        }
    };
    private RegistrationRegimeVerifier registrationRegimeVerifier = REGISTRATION_REGIME_VERIFIER.get();

    private RegistrationRegime() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
    }

    public RegistrationRegime(Registration registration, ExecutionYear executionYear, RegistrationRegimeType type) {
        this();
        this.checkParameters(registration, executionYear, type);
        super.setRegistration(registration);
        super.setExecutionYear(executionYear);
        super.setRegimeType(type);
    }

    private void checkParameters(Registration registration, ExecutionYear executionYear, RegistrationRegimeType type) {
        if (registration == null) {
            throw new DomainException("error.RegistrationRegime.invalid.registration", new String[0]);
        }
        if (executionYear == null) {
            throw new DomainException("error.RegistrationRegime.invalid.executionYear", new String[0]);
        }
        if (type == null) {
            throw new DomainException("error.RegistrationRegime.invalid.regimeType", new String[0]);
        }
        if (registration.hasRegistrationRegime(executionYear, type)) {
            throw new DomainException("error.RegistrationRegime.already.has.regime.type.in.given.executionYear", new String[0]);
        }
        if (registration.getDegree().isEmpty()) {
            throw new DomainException("error.RegistrationRegime.cannot.apply.to.empty.degrees", new String[0]);
        }
        this.registrationRegimeVerifier.checkEctsCredits(registration, executionYear, type);
    }

    public static RegistrationRegimeVerifier getRegistrationRegimeVerifier() {
        return REGISTRATION_REGIME_VERIFIER.get();
    }

    public static void setRegistrationRegimeVerifier(Supplier<RegistrationRegimeVerifier> input) {
        REGISTRATION_REGIME_VERIFIER = input;
    }

    public boolean isPartTime() {
        return this.getRegimeType() == RegistrationRegimeType.PARTIAL_TIME;
    }

    public void delete() {
        this.setRegistration(null);
        this.setExecutionYear(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isFor(ExecutionYear executionYear) {
        return this.getExecutionYear() == executionYear;
    }

    public boolean hasRegime(RegistrationRegimeType type) {
        return this.getRegimeType() == type;
    }

    public static interface RegistrationRegimeVerifier {
        public void checkEctsCredits(Registration var1, ExecutionYear var2, RegistrationRegimeType var3);
    }
}

