/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.email;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmail$callable$createEmail;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmail_Base;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdIndividualProgramProcessEmail
extends PhdIndividualProgramProcessEmail_Base {
    public static final Advice advice$createEmail = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdIndividualProgramProcessEmail() {
    }

    protected PhdIndividualProgramProcessEmail(String subject, String message, String additionalTo, String additionalBcc, Person creator, PhdIndividualProgramProcess individualProcess) {
        this.init(subject, message, additionalTo, additionalBcc, creator, new DateTime());
        this.setPhdIndividualProgramProcess(individualProcess);
    }

    protected Collection<? extends ReplyTo> getReplyTos() {
        return this.getSender().getReplyTosSet();
    }

    protected Sender getSender() {
        return (Sender)((Object)this.getPhdIndividualProgramProcess().getAdministrativeOffice().getUnit().getUnitBasedSenderSet().iterator().next());
    }

    protected Collection<Recipient> getRecipients() {
        return null;
    }

    protected String getBccs() {
        return this.getAdditionalBcc();
    }

    public static PhdIndividualProgramProcessEmail createEmail(PhdIndividualProgramProcessEmailBean phdIndividualProgramProcessEmailBean) {
        return (PhdIndividualProgramProcessEmail)((Object)advice$createEmail.perform((Callable)new PhdIndividualProgramProcessEmail$callable$createEmail(phdIndividualProgramProcessEmailBean)));
    }

    static /* synthetic */ PhdIndividualProgramProcessEmail advised$createEmail(PhdIndividualProgramProcessEmailBean bean) {
        String errorWhileValidating = PhdIndividualProgramProcessEmail.validateEmailBean(bean);
        if (errorWhileValidating != null) {
            throw new DomainException(errorWhileValidating, new String[0]);
        }
        Person creator = AccessControl.getPerson();
        return new PhdIndividualProgramProcessEmail(bean.getSubject(), bean.getMessage(), null, bean.getBccsWithSelectedParticipants(), creator, bean.getProcess());
    }

    private static String validateEmailBean(PhdIndividualProgramProcessEmailBean bean) {
        if (bean.getParticipantsGroup().isEmpty() && bean.getSelectedParticipants().isEmpty() && StringUtils.isEmpty((String)bean.getBccs())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.no.recipients", (String[])new String[0]);
        }
        if (StringUtils.isEmpty((String)bean.getSubject())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.subject.empty", (String[])new String[0]);
        }
        if (StringUtils.isEmpty((String)bean.getMessage())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.message.empty", (String[])new String[0]);
        }
        return null;
    }
}

