/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy.feedbackRequest;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestDocument;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElement$callable$delete;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElementBean;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElement_Base;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdCandidacyFeedbackRequestElement
extends PhdCandidacyFeedbackRequestElement_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdCandidacyFeedbackRequestElement() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected PhdCandidacyFeedbackRequestElement init(PhdCandidacyFeedbackRequestProcess process2, PhdParticipant participant, PhdCandidacyFeedbackRequestElementBean bean) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdCandidacyFeedbackRequestElement.invalid.process", args);
        }
        this.checkParticipant(process2, participant);
        this.setProcess(process2);
        this.setParticipant(participant);
        this.setMailSubject(bean.getMailSubject());
        this.setMailBody(bean.getMailBody());
        return this;
    }

    private void checkParticipant(PhdCandidacyFeedbackRequestProcess process2, PhdParticipant participant) {
        String[] args = new String[]{};
        if (participant == null) {
            throw new DomainException("error.PhdCandidacyFeedbackRequestElement.participant.cannot.be.null", args);
        }
        for (PhdCandidacyFeedbackRequestElement element : participant.getCandidacyFeedbackRequestElementsSet()) {
            if (element.getProcess() == null || !element.getProcess().equals((Object)process2)) continue;
            throw new DomainException("error.PhdCandidacyFeedbackRequestElement.participant.already.has.jury.element.in.process", new String[0]);
        }
    }

    public PhdProgramCandidacyProcess getCandidacyProcess() {
        return this.getProcess().getCandidacyProcess();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PhdCandidacyFeedbackRequestElement$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PhdCandidacyFeedbackRequestElement this_) {
        this_.checkIfCanBeDeleted();
        this_.disconnect();
        this_.deleteDomainObject();
    }

    private void checkIfCanBeDeleted() {
        if (!this.getFeedbackDocumentsSet().isEmpty()) {
            throw new DomainException("error.PhdCandidacyFeedbackRequestElement.has.feedback.documents", new String[0]);
        }
    }

    private void disconnect() {
        PhdParticipant participant = this.getParticipant();
        this.setParticipant(null);
        participant.tryDelete();
        this.setProcess(null);
        this.setRootDomainObject(null);
    }

    public PhdCandidacyFeedbackRequestDocument getLastFeedbackDocument() {
        return !this.getFeedbackDocumentsSet().isEmpty() ? (PhdCandidacyFeedbackRequestDocument)((Object)Collections.max(this.getFeedbackDocumentsSet(), PhdProgramProcessDocument.COMPARATOR_BY_UPLOAD_TIME)) : null;
    }

    public String getNameWithTitle() {
        return this.getParticipant().getNameWithTitle();
    }

    public String getName() {
        return this.getParticipant().getName();
    }

    public String getEmail() {
        return this.getParticipant().getEmail();
    }

    public boolean isFeedbackSubmitted() {
        return !this.getFeedbackDocumentsSet().isEmpty();
    }

    public boolean isFor(PhdCandidacyFeedbackRequestProcess process2) {
        return this.getProcess().equals((Object)process2);
    }

    public boolean isFor(Person person) {
        return this.getParticipant().isFor(person);
    }

    public static PhdCandidacyFeedbackRequestElement create(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackRequestElementBean bean) {
        return new PhdCandidacyFeedbackRequestElement().init(process2, PhdParticipant.getUpdatedOrCreate(process2.getIndividualProgramProcess(), bean), bean);
    }

    public static PhdCandidacyFeedbackRequestElement create(PhdCandidacyFeedbackRequestProcess process2, PhdParticipant participant, PhdCandidacyFeedbackRequestElementBean bean) {
        return new PhdCandidacyFeedbackRequestElement().init(process2, participant, bean);
    }
}

