/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy.activities;

import java.util.Arrays;
import java.util.List;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessStateBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.PhdProgramCandidacyProcessActivity;
import org.fenixedu.bennu.core.domain.User;

public class RequestCandidacyReview
extends PhdProgramCandidacyProcessActivity {
    private static final List<PhdProgramCandidacyProcessState> PREVIOUS_STATE = Arrays.asList(PhdProgramCandidacyProcessState.PRE_CANDIDATE, PhdProgramCandidacyProcessState.STAND_BY_WITH_MISSING_INFORMATION, PhdProgramCandidacyProcessState.STAND_BY_WITH_COMPLETE_INFORMATION, PhdProgramCandidacyProcessState.REJECTED, PhdProgramCandidacyProcessState.WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION);

    @Override
    protected void activityPreConditions(PhdProgramCandidacyProcess process2, User userView) {
        if (PREVIOUS_STATE.contains(process2.getActiveState())) {
            return;
        }
        throw new PreConditionNotValidException();
    }

    @Override
    protected PhdProgramCandidacyProcess executeActivity(PhdProgramCandidacyProcess process2, User userView, Object object) {
        PhdIndividualProgramProcess mainProcess = process2.getIndividualProgramProcess();
        if (mainProcess.getPhdProgram() == null) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyProcess.RequestCandidacyReview.invalid.phd.program", new String[0]);
        }
        PhdProgramCandidacyProcessStateBean bean = (PhdProgramCandidacyProcessStateBean)object;
        process2.createState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION, userView.getPerson(), bean.getRemarks());
        if (bean.getGenerateAlert().booleanValue()) {
            AlertService.alertCoordinators(mainProcess, this.subject(), this.body(mainProcess));
        }
        return process2;
    }

    private AlertService.AlertMessage subject() {
        return AlertService.AlertMessage.create("message.phd.alert.candidacy.review.subject", new Object[0]);
    }

    private AlertService.AlertMessage body(PhdIndividualProgramProcess process2) {
        return AlertService.AlertMessage.create("message.phd.alert.candidacy.review.body", new Object[0]).args(process2.getProcessNumber(), process2.getPerson().getName(), Installation.getInstance().getInstituitionalEmailAddress("suporte"));
    }
}

