/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdStudyPlan;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntryType;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntry_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class PhdStudyPlanEntry
extends PhdStudyPlanEntry_Base {
    protected PhdStudyPlanEntry() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
        if (AccessControl.getPerson() != null) {
            this.setCreatedBy(AccessControl.getPerson().getUsername());
        }
    }

    protected PhdStudyPlanEntry(PhdStudyPlanEntryType type, PhdStudyPlan studyPlan) {
        this();
        this.init(type, studyPlan);
    }

    protected void init(PhdStudyPlanEntryType type, PhdStudyPlan studyPlan) {
        String[] args = new String[]{};
        if (type == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlanEntry.type.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (studyPlan == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlanEntry.studyPlan.cannot.be.null", args1);
        }
        super.setType(type);
        super.setStudyPlan(studyPlan);
    }

    public boolean isNormal() {
        return this.getType() == PhdStudyPlanEntryType.NORMAL;
    }

    public boolean isPropaedeutic() {
        return this.getType() == PhdStudyPlanEntryType.PROPAEDEUTIC;
    }

    public boolean isExtraCurricular() {
        return this.getType() == PhdStudyPlanEntryType.EXTRA_CURRICULAR;
    }

    public boolean isInternalEntry() {
        return false;
    }

    public boolean isExternalEntry() {
        return false;
    }

    public void delete() {
        super.setRootDomainObject(null);
        super.setStudyPlan(null);
        super.deleteDomainObject();
    }

    public abstract String getCourseDescription();

    public abstract boolean isSimilar(PhdStudyPlanEntry var1);

    static {
        PhdStudyPlanEntry.getRelationPhdStudyPlanPhdStudyPlanEntry().addListener((RelationListener)new RelationAdapter<PhdStudyPlan, PhdStudyPlanEntry>(){

            public void beforeAdd(PhdStudyPlan studyPlan, PhdStudyPlanEntry entry) {
                if (entry != null && studyPlan != null && studyPlan.hasSimilarEntry(entry)) {
                    throw new DomainException("error.phd.PhdStudyPlanEntry.found.similar.entry", new String[0]);
                }
            }
        });
    }
}

