/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class UniversityUnit
extends UniversityUnit_Base {
    private UniversityUnit() {
        super.setType(PartyTypeEnum.UNIVERSITY);
    }

    public boolean isUniversityUnit() {
        return true;
    }

    public static UniversityUnit createNewUniversityUnit(MultiLanguageString name, Unit parentUnit, Boolean official, String code, AcademicalInstitutionType institutionType) {
        UniversityUnit universityUnit = new UniversityUnit();
        universityUnit.setPartyName(name);
        universityUnit.setOfficial(official);
        universityUnit.setCode(code);
        universityUnit.setInstitutionType(institutionType);
        universityUnit.setBeginDateYearMonthDay(YearMonthDay.fromDateFields((Date)new GregorianCalendar().getTime()));
        universityUnit.setCanBeResponsibleOfSpaces(Boolean.FALSE);
        return UniversityUnit.createNewUnit(parentUnit, universityUnit);
    }

    public static UniversityUnit createNewUniversityUnit(MultiLanguageString universityName, String universityNameCard, Integer costCenterCode, String universityAcronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        UniversityUnit universityUnit = new UniversityUnit();
        universityUnit.init(universityName, universityNameCard, costCenterCode, universityAcronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        return UniversityUnit.createNewUnit(parentUnit, universityUnit);
    }

    private static UniversityUnit createNewUnit(Unit parentUnit, UniversityUnit universityUnit) {
        universityUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.GEOGRAPHIC));
        UniversityUnit.checkIfAlreadyExistsOneUniversityWithSameAcronymAndName((AcademicalInstitutionUnit)((Object)universityUnit));
        return universityUnit;
    }

    public void edit(MultiLanguageString name, String acronym) {
        super.edit(name, acronym);
        UniversityUnit.checkIfAlreadyExistsOneUniversityWithSameAcronymAndName((AcademicalInstitutionUnit)((Object)this));
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        UniversityUnit.checkIfAlreadyExistsOneUniversityWithSameAcronymAndName((AcademicalInstitutionUnit)((Object)this));
    }

    protected static void checkIfAlreadyExistsOneUniversityWithSameAcronymAndName(AcademicalInstitutionUnit universityUnit) {
        for (Unit parentUnit : universityUnit.getParentUnits()) {
            for (Unit unit : parentUnit.getAllSubUnits()) {
                if (unit.equals((Object)universityUnit) || !unit.isUniversityUnit() || (universityUnit.getAcronym() == null || !universityUnit.getAcronym().equalsIgnoreCase(unit.getAcronym())) && !universityUnit.getName().equalsIgnoreCase(unit.getName())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
            }
        }
    }

    public static final UniversityUnit getInstitutionsUniversityUnit() {
        return UniversityUnit.getInstitutionsUniversityUnitByDate(new DateTime());
    }

    public static final UniversityUnit getInstitutionsUniversityUnitByDate(DateTime dateTime) {
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        Collection parentUniversityUnits = institutionUnit.getParentPartiesByDates(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, UniversityUnit.class, dateTime);
        if (parentUniversityUnits.size() != 1) {
            throw new DomainException("UniversityUnit.unable.to.determine.single.university.unit.for.institution.unit", new String[0]);
        }
        return (UniversityUnit)((Object)parentUniversityUnits.iterator().next());
    }

    public final Person getCurrentPresident() {
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        if (!this.getChildParties(Unit.class).contains((Object)institutionUnit)) {
            throw new DomainException("UniversityUnit.not.parent.of.institution.unit", new String[0]);
        }
        return this.getPresident() != null ? this.getPresident().getPerson() : null;
    }

    public final Person getCurrentPrincipal() {
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        if (!this.getChildParties(Unit.class).contains((Object)institutionUnit)) {
            throw new DomainException("UniversityUnit.not.parent.of.institution.unit", new String[0]);
        }
        return this.getPrincipal() != null ? this.getPrincipal().getPerson() : null;
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (!(parentUnit == null || parentUnit.isOfficialExternal() && (parentUnit.isPlanetUnit() || parentUnit.isCountryUnit()))) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public String getFullPresentationName() {
        return this.getName();
    }
}

