/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.executionCourse;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degree.DegreeType;

public class ExecutionCourseWithNoEvaluationMethodSearchBean
implements Serializable {
    private ExecutionSemester executionSemester;
    private List<DegreeType> degreeTypes;
    private int withEvaluationMethod = 0;
    private int withoutEvaluationMethod = 0;
    private int total = 0;

    public Set getSearchResult() {
        this.withEvaluationMethod = 0;
        this.withoutEvaluationMethod = 0;
        this.total = 0;
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        List<DegreeType> degreeTypes = this.getDegreeTypes();
        if (executionSemester == null || degreeTypes == null) {
            return null;
        }
        TreeSet<ExecutionCourse> executionCourses = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            if (!this.isLecturedIn(executionCourse, degreeTypes)) continue;
            ++this.total;
            if (this.hasEvaluationMethod(executionCourse)) {
                ++this.withEvaluationMethod;
                continue;
            }
            ++this.withoutEvaluationMethod;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    private boolean hasEvaluationMethod(ExecutionCourse executionCourse) {
        String evaluationMethodText = executionCourse.getEvaluationMethodText();
        String evaluationMethodTextEn = executionCourse.getEvaluationMethodTextEn();
        return evaluationMethodText != null && evaluationMethodText.length() > 0 || evaluationMethodTextEn != null && evaluationMethodTextEn.length() > 0;
    }

    private boolean isLecturedIn(ExecutionCourse executionCourse, List<DegreeType> degreeTypes) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            Degree degree = curricularCourse.getDegree();
            DegreeType degreeType = degree.getDegreeType();
            if (!degreeTypes.contains(degreeType)) continue;
            return true;
        }
        return false;
    }

    public List<DegreeType> getDegreeTypes() {
        return this.degreeTypes;
    }

    public void setDegreeTypes(List<DegreeType> degreeTypes) {
        this.degreeTypes = degreeTypes;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public int getTotal() {
        return this.total;
    }

    public int getWithEvaluationMethod() {
        return this.withEvaluationMethod;
    }

    public int getWithoutEvaluationMethod() {
        return this.withoutEvaluationMethod;
    }
}

