/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.File;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean$callable$updatePersonalInformation;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PersonalInformationBean
implements Serializable {
    private static final LocalDate limitDate;
    public static Comparator<PersonalInformationBean> COMPARATOR_BY_DESCRIPTION;
    private static final long serialVersionUID = 1144682974757187722L;
    private PhdIndividualProgramProcess phdIndividualProgramProcess;
    private Registration registration;
    private Country countryOfResidence;
    private DistrictSubdivision districtSubdivisionOfResidence;
    private Boolean dislocatedFromPermanentResidence;
    private DistrictSubdivision schoolTimeDistrictSubdivisionOfResidence;
    private GrantOwnerType grantOwnerType;
    private Unit grantOwnerProvider;
    private String grantOwnerProviderName;
    private AcademicalInstitutionType highSchoolType;
    private MaritalStatus maritalStatus;
    private ProfessionType professionType;
    private ProfessionalSituationConditionType professionalCondition;
    private SchoolLevelType motherSchoolLevel;
    private ProfessionType motherProfessionType;
    private ProfessionalSituationConditionType motherProfessionalCondition;
    private SchoolLevelType fatherSchoolLevel;
    private ProfessionType fatherProfessionType;
    private ProfessionalSituationConditionType fatherProfessionalCondition;
    private String conclusionGrade;
    private Integer conclusionYear;
    private Integer numberOfEnroledCurricularCourses;
    private Unit institution;
    private String institutionName;
    private String degreeDesignation;
    private DegreeDesignation raidesDegreeDesignation;
    private Country countryWhereFinishedPreviousCompleteDegree;
    private Country countryWhereFinishedHighSchoolLevel;
    private SchoolLevelType schoolLevel;
    private String otherSchoolLevel;
    private DateTime lastModifiedDate;
    private boolean degreeChangeOrTransferOrErasmusStudent = false;
    private SchoolLevelType precedentSchoolLevel;
    private String otherPrecedentSchoolLevel;
    private Unit precedentInstitution;
    private String precedentInstitutionName;
    private String precedentDegreeDesignation;
    private DegreeDesignation precedentDegreeDesignationObject;
    private Integer numberOfPreviousYearEnrolmentsInPrecedentDegree;
    private SchoolPeriodDuration mobilityProgramDuration;
    private final Collection<File> documentFiles = new ArrayList<File>();
    public static final Advice advice$updatePersonalInformation;

    public static boolean isPastLimitDate() {
        return new LocalDate().isAfter((ReadablePartial)limitDate);
    }

    public PersonalInformationBean(Registration registration) {
        this.setRegistration(registration);
        this.initFromLatestPersonalIngressionData();
    }

    public PersonalInformationBean(PhdIndividualProgramProcess PhdProcess) {
        this.setPhdIndividualProgramProcess(PhdProcess);
        this.initFromLatestPersonalIngressionData();
    }

    public PersonalInformationBean(PrecedentDegreeInformation degreeInfo) {
        if (degreeInfo.getPhdIndividualProgramProcess() != null) {
            this.setPhdIndividualProgramProcess(degreeInfo.getPhdIndividualProgramProcess());
        } else {
            this.setRegistration(degreeInfo.getRegistration());
        }
        this.setSchoolLevel(degreeInfo.getSchoolLevel());
        this.setOtherSchoolLevel(degreeInfo.getOtherSchoolLevel());
        this.setConclusionGrade(degreeInfo.getConclusionGrade());
        this.setConclusionYear(degreeInfo.getConclusionYear());
        this.setCountryWhereFinishedPreviousCompleteDegree(degreeInfo.getCountry());
        this.setCountryWhereFinishedHighSchoolLevel(degreeInfo.getCountryHighSchool());
        Unit institution = degreeInfo.getInstitution();
        if (!this.isUnitFromRaidesListMandatory() || institution != null && !StringUtils.isEmpty((String)institution.getCode())) {
            this.setInstitution(institution);
            this.setDegreeDesignation(degreeInfo.getDegreeDesignation());
        }
        this.setPrecedentDegreeDesignation(degreeInfo.getPrecedentDegreeDesignation());
        this.setPrecedentInstitution(degreeInfo.getPrecedentInstitution());
        this.setPrecedentSchoolLevel(degreeInfo.getPrecedentSchoolLevel());
        this.setOtherPrecedentSchoolLevel(degreeInfo.getOtherPrecedentSchoolLevel());
        this.setNumberOfPreviousYearEnrolmentsInPrecedentDegree(degreeInfo.getNumberOfEnrolmentsInPreviousDegrees());
        this.setNumberOfEnroledCurricularCourses(degreeInfo.getNumberOfEnroledCurricularCourses());
        this.setMobilityProgramDuration(degreeInfo.getMobilityProgramDuration());
        if (this.getPrecedentDegreeDesignation() != null || this.getPrecedentInstitution() != null || this.getPrecedentSchoolLevel() != null || this.getNumberOfPreviousYearEnrolmentsInPrecedentDegree() != null) {
            this.setDegreeChangeOrTransferOrErasmusStudent(true);
        }
        if (this.isUnitFromRaidesListMandatory()) {
            this.setRaidesDegreeDesignation(DegreeDesignation.readByNameAndSchoolLevel(this.degreeDesignation, this.schoolLevel));
        }
        this.initFromLatestPersonalIngressionData();
    }

    public PersonalInformationBean() {
    }

    private void initFromLatestPersonalIngressionData() {
        PersonalIngressionData personalData = this.getStudent().getLatestPersonalIngressionData();
        if (personalData == null) {
            return;
        }
        this.setCountryOfResidence(personalData.getCountryOfResidence());
        this.setDistrictSubdivisionOfResidence(personalData.getDistrictSubdivisionOfResidence());
        this.setSchoolTimeDistrictSubdivisionOfResidence(personalData.getSchoolTimeDistrictSubDivisionOfResidence());
        this.setDislocatedFromPermanentResidence(personalData.getDislocatedFromPermanentResidence());
        this.setGrantOwnerType(personalData.getGrantOwnerType());
        this.setGrantOwnerProvider(personalData.getGrantOwnerProvider());
        this.setHighSchoolType(personalData.getHighSchoolType());
        this.setMaritalStatus(personalData.getMaritalStatus());
        this.setProfessionType(personalData.getProfessionType());
        this.setProfessionalCondition(personalData.getProfessionalCondition());
        this.setMotherSchoolLevel(personalData.getMotherSchoolLevel());
        this.setMotherProfessionType(personalData.getMotherProfessionType());
        this.setMotherProfessionalCondition(personalData.getMotherProfessionalCondition());
        this.setFatherSchoolLevel(personalData.getFatherSchoolLevel());
        this.setFatherProfessionType(personalData.getFatherProfessionType());
        this.setFatherProfessionalCondition(personalData.getFatherProfessionalCondition());
        this.setLastModifiedDate(personalData.getLastModifiedDate());
    }

    public LocalDate getLimitDate() {
        return limitDate;
    }

    public Integer getNumberOfEnroledCurricularCourses() {
        return this.numberOfEnroledCurricularCourses;
    }

    public void setNumberOfEnroledCurricularCourses(Integer numberOfEnroledCurricularCourses) {
        this.numberOfEnroledCurricularCourses = numberOfEnroledCurricularCourses;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public boolean hasRegistration() {
        return this.getRegistration() != null;
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.phdIndividualProgramProcess;
    }

    public void setPhdIndividualProgramProcess(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        this.phdIndividualProgramProcess = phdIndividualProgramProcess;
    }

    public boolean hasPhdIndividualProgramProcess() {
        return this.getPhdIndividualProgramProcess() != null;
    }

    public Country getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(Country country) {
        this.countryOfResidence = country;
    }

    public DistrictSubdivision getDistrictSubdivisionOfResidence() {
        return this.districtSubdivisionOfResidence;
    }

    public void setDistrictSubdivisionOfResidence(DistrictSubdivision districtSubdivision) {
        this.districtSubdivisionOfResidence = districtSubdivision;
    }

    public Boolean getDislocatedFromPermanentResidence() {
        return this.dislocatedFromPermanentResidence;
    }

    public void setDislocatedFromPermanentResidence(Boolean dislocatedFromPermanentResidence) {
        this.dislocatedFromPermanentResidence = dislocatedFromPermanentResidence;
    }

    public DistrictSubdivision getSchoolTimeDistrictSubdivisionOfResidence() {
        return this.schoolTimeDistrictSubdivisionOfResidence;
    }

    public void setSchoolTimeDistrictSubdivisionOfResidence(DistrictSubdivision districtSubdivision) {
        this.schoolTimeDistrictSubdivisionOfResidence = districtSubdivision;
    }

    public GrantOwnerType getGrantOwnerType() {
        return this.grantOwnerType;
    }

    public void setGrantOwnerType(GrantOwnerType grantOwnerType) {
        this.grantOwnerType = grantOwnerType;
    }

    public Unit getGrantOwnerProvider() {
        return this.grantOwnerProvider;
    }

    public void setGrantOwnerProvider(Unit grantOwnerProvider) {
        this.grantOwnerProvider = grantOwnerProvider;
    }

    public String getGrantOwnerProviderName() {
        return this.grantOwnerProviderName;
    }

    public void setGrantOwnerProviderName(String grantOwnerProviderName) {
        this.grantOwnerProviderName = grantOwnerProviderName;
    }

    public UnitName getGrantOwnerProviderUnitName() {
        return this.grantOwnerProvider == null ? null : this.grantOwnerProvider.getUnitName();
    }

    public void setGrantOwnerProviderUnitName(UnitName grantOwnerProviderUnitName) {
        this.grantOwnerProvider = grantOwnerProviderUnitName == null ? null : grantOwnerProviderUnitName.getUnit();
    }

    public AcademicalInstitutionType getHighSchoolType() {
        if (this.getSchoolLevel() != null && this.getSchoolLevel().isHighSchoolOrEquivalent()) {
            return this.highSchoolType;
        }
        return null;
    }

    public void setHighSchoolType(AcademicalInstitutionType highSchoolType) {
        this.highSchoolType = highSchoolType;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus == MaritalStatus.UNKNOWN ? null : maritalStatus;
    }

    public boolean hasMaritalStatus() {
        return this.getMaritalStatus() != null;
    }

    public ProfessionType getProfessionType() {
        return this.professionType;
    }

    public void setProfessionType(ProfessionType professionType) {
        this.professionType = professionType;
    }

    public boolean hasProfessionType() {
        return this.getProfessionType() != null;
    }

    public ProfessionalSituationConditionType getProfessionalCondition() {
        return this.professionalCondition;
    }

    public void setProfessionalCondition(ProfessionalSituationConditionType professionalCondition) {
        this.professionalCondition = professionalCondition;
    }

    public boolean hasProfessionalCondition() {
        return this.getProfessionalCondition() != null;
    }

    public SchoolLevelType getMotherSchoolLevel() {
        return this.motherSchoolLevel;
    }

    public void setMotherSchoolLevel(SchoolLevelType motherSchoolLevel) {
        this.motherSchoolLevel = motherSchoolLevel;
    }

    public boolean hasMotherSchoolLevel() {
        return this.getMotherSchoolLevel() != null;
    }

    public ProfessionType getMotherProfessionType() {
        return this.motherProfessionType;
    }

    public void setMotherProfessionType(ProfessionType motherProfessionType) {
        this.motherProfessionType = motherProfessionType;
    }

    public boolean hasMotherProfessionType() {
        return this.getMotherProfessionType() != null;
    }

    public ProfessionalSituationConditionType getMotherProfessionalCondition() {
        return this.motherProfessionalCondition;
    }

    public void setMotherProfessionalCondition(ProfessionalSituationConditionType motherProfessionalCondition) {
        this.motherProfessionalCondition = motherProfessionalCondition;
    }

    public boolean hasMotherProfessionalCondition() {
        return this.getMotherProfessionalCondition() != null;
    }

    public SchoolLevelType getFatherSchoolLevel() {
        return this.fatherSchoolLevel;
    }

    public void setFatherSchoolLevel(SchoolLevelType fatherSchoolLevel) {
        this.fatherSchoolLevel = fatherSchoolLevel;
    }

    public boolean hasFatherSchoolLevel() {
        return this.getFatherSchoolLevel() != null;
    }

    public ProfessionType getFatherProfessionType() {
        return this.fatherProfessionType;
    }

    public void setFatherProfessionType(ProfessionType fatherProfessionType) {
        this.fatherProfessionType = fatherProfessionType;
    }

    public boolean hasFatherProfessionType() {
        return this.getFatherProfessionType() != null;
    }

    public ProfessionalSituationConditionType getFatherProfessionalCondition() {
        return this.fatherProfessionalCondition;
    }

    public void setFatherProfessionalCondition(ProfessionalSituationConditionType fatherProfessionalCondition) {
        this.fatherProfessionalCondition = fatherProfessionalCondition;
    }

    public boolean hasFatherProfessionalCondition() {
        return this.getFatherProfessionalCondition() != null;
    }

    public String getConclusionGrade() {
        return this.conclusionGrade;
    }

    public void setConclusionGrade(String conclusionGrade) {
        this.conclusionGrade = conclusionGrade;
    }

    public Integer getConclusionYear() {
        return this.conclusionYear;
    }

    public void setConclusionYear(Integer conclusionYear) {
        this.conclusionYear = conclusionYear;
    }

    public Unit getInstitution() {
        return this.institution;
    }

    public void setInstitution(Unit institution) {
        this.institution = institution;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public UnitName getInstitutionUnitName() {
        return this.institution == null ? null : this.institution.getUnitName();
    }

    public void setInstitutionUnitName(UnitName institutionUnitName) {
        this.institution = institutionUnitName == null ? null : institutionUnitName.getUnit();
    }

    public String getDegreeDesignation() {
        if (this.isUnitFromRaidesListMandatory()) {
            return this.getRaidesDegreeDesignation() != null ? this.getRaidesDegreeDesignation().getDescription() : null;
        }
        return this.degreeDesignation;
    }

    public boolean isUnitFromRaidesListMandatory() {
        return this.getSchoolLevel() != null && this.getSchoolLevel().isHigherEducation() && this.getCountryWhereFinishedPreviousCompleteDegree() != null && this.getCountryWhereFinishedPreviousCompleteDegree().isDefaultCountry();
    }

    public void setDegreeDesignation(String degreeDesignation) {
        this.degreeDesignation = degreeDesignation;
    }

    public Country getCountryWhereFinishedPreviousCompleteDegree() {
        return this.countryWhereFinishedPreviousCompleteDegree;
    }

    public void setCountryWhereFinishedPreviousCompleteDegree(Country country) {
        if (this.getSchoolLevel() != null && this.getSchoolLevel().isHighSchoolOrEquivalent()) {
            this.setCountryWhereFinishedHighSchoolLevel(country);
        }
        this.countryWhereFinishedPreviousCompleteDegree = country;
    }

    public boolean isHightSchoolCountryFieldRequired() {
        return this.getSchoolLevel() != null && !this.getSchoolLevel().isHighSchoolOrEquivalent() && !this.getSchoolLevel().isSchoolLevelBasicCycle();
    }

    public Country getCountryWhereFinishedHighSchoolLevel() {
        return this.countryWhereFinishedHighSchoolLevel;
    }

    public void setCountryWhereFinishedHighSchoolLevel(Country country) {
        this.countryWhereFinishedHighSchoolLevel = country;
    }

    public SchoolLevelType getSchoolLevel() {
        return this.schoolLevel;
    }

    public void setSchoolLevel(SchoolLevelType schoolLevel) {
        this.schoolLevel = schoolLevel;
    }

    public boolean hasSchoolLevel() {
        return this.getSchoolLevel() != null;
    }

    public String getOtherSchoolLevel() {
        return this.otherSchoolLevel;
    }

    public void setOtherSchoolLevel(String otherSchoolLevel) {
        this.otherSchoolLevel = otherSchoolLevel;
    }

    public DateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(DateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set<String> validate() {
        HashSet<String> result = new HashSet<String>();
        if (!(this.getConclusionGrade() != null && this.getConclusionYear() != null && this.getCountryOfResidence() != null && this.getGrantOwnerType() != null && this.getDislocatedFromPermanentResidence() != null && this.isSchoolLevelValid() && this.isHighSchoolLevelValid() && this.isMaritalStatusValid() && this.isProfessionalConditionValid() && this.isProfessionTypeValid() && this.isMotherSchoolLevelValid() && this.isMotherProfessionTypeValid() && this.isMotherProfessionalConditionValid() && this.isFatherProfessionalConditionValid() && this.isFatherProfessionTypeValid() && this.isFatherSchoolLevelValid() && this.getCountryWhereFinishedPreviousCompleteDegree() != null && this.isCountryWhereFinishedHighSchoolValid() && (this.getDegreeDesignation() != null || this.isUnitFromRaidesListMandatory()) && (this.getInstitution() != null || !StringUtils.isEmpty((String)this.getInstitutionName())))) {
            result.add("error.CandidacyInformationBean.required.information.must.be.filled");
        }
        LocalDate now = new LocalDate();
        if (this.getConclusionYear() != null && now.getYear() < this.getConclusionYear()) {
            result.add("error.personalInformation.year.after.current");
        }
        int birthYear = this.getStudent().getPerson().getDateOfBirthYearMonthDay().getYear();
        if (this.getConclusionYear() != null && this.getConclusionYear() < birthYear) {
            result.add("error.personalInformation.year.before.birthday");
        }
        if (this.getSchoolLevel() != null && !this.getSchoolLevel().isSchoolLevelBasicCycle() && !this.getSchoolLevel().isOther() && this.getConclusionYear() != null && this.getConclusionYear() < birthYear + 15) {
            result.add("error.personalInformation.year.before.fifteen.years.old");
        }
        if (this.isUnitFromRaidesListMandatory()) {
            if (this.getInstitution() == null) {
                result.add("error.personalInformation.required.institution");
            }
            if (this.getDegreeDesignation() == null) {
                result.add("error.personalInformation.required.degreeDesignation");
            }
        }
        if (this.getCountryOfResidence() != null) {
            if (this.getCountryOfResidence().isDefaultCountry() && this.getDistrictSubdivisionOfResidence() == null) {
                result.add("error.CandidacyInformationBean.districtSubdivisionOfResidence.is.required.for.default.country");
            }
            if (!(this.getCountryOfResidence().isDefaultCountry() || this.getDislocatedFromPermanentResidence() != null && this.getDislocatedFromPermanentResidence().booleanValue())) {
                result.add("error.CandidacyInformationBean.foreign.students.must.select.dislocated.option");
            }
        }
        if (this.getDislocatedFromPermanentResidence() != null && this.getDislocatedFromPermanentResidence().booleanValue() && this.getSchoolTimeDistrictSubdivisionOfResidence() == null) {
            result.add("error.CandidacyInformationBean.schoolTimeDistrictSubdivisionOfResidence.is.required.for.dislocated.students");
        }
        if (this.getSchoolLevel() != null && this.getSchoolLevel() == SchoolLevelType.OTHER && StringUtils.isEmpty((String)this.getOtherSchoolLevel())) {
            result.add("error.CandidacyInformationBean.other.school.level.description.is.required");
        }
        if (this.isUnitFromRaidesListMandatory() && this.hasRaidesDegreeDesignation() && !this.getRaidesDegreeDesignation().getInstitutionUnitSet().contains((Object)this.getInstitution())) {
            result.add("error.CandidacyInformationBean.designation.must.match.institution");
        }
        if (this.getGrantOwnerType() != null && this.getGrantOwnerType() == GrantOwnerType.OTHER_INSTITUTION_GRANT_OWNER && this.getGrantOwnerProvider() == null) {
            result.add("error.CandidacyInformationBean.grantOwnerProviderInstitutionUnitName.is.required.for.other.institution.grant.ownership");
        }
        return result;
    }

    public Set<String> validateForAcademicService() {
        Set<String> result = this.validate();
        if (!result.isEmpty()) {
            return result;
        }
        if (this.isDegreeChangeOrTransferOrErasmusStudent()) {
            if (StringUtils.isEmpty((String)this.getPrecedentDegreeDesignation()) || this.getPrecedentInstitution() == null && StringUtils.isEmpty((String)this.getPrecedentInstitutionName()) || this.getPrecedentSchoolLevel() == null || this.getNumberOfPreviousYearEnrolmentsInPrecedentDegree() == null) {
                result.add("error.PersonInformationBean.precedentDegree.fields.mandatory");
            }
            if (SchoolLevelType.OTHER.equals((Object)this.getPrecedentSchoolLevel()) && StringUtils.isEmpty((String)this.getOtherPrecedentSchoolLevel())) {
                result.add("error.other.precedent.school.level.description.is.required");
            }
        }
        return result;
    }

    public boolean isEditableByAcademicService() {
        Set<String> result = this.validate();
        if (!result.isEmpty()) {
            return true;
        }
        return this.getPrecedentDegreeDesignation() == null || this.getPrecedentInstitution() == null || this.getPrecedentSchoolLevel() == null || this.getNumberOfPreviousYearEnrolmentsInPrecedentDegree() == null || this.getMobilityProgramDuration() == null;
    }

    public boolean isMaritalStatusValid() {
        return this.hasMaritalStatus() && this.getMaritalStatus() != MaritalStatus.UNKNOWN;
    }

    public boolean isSchoolLevelValid() {
        return this.hasSchoolLevel() && this.getSchoolLevel().isForStudent();
    }

    private boolean isCountryWhereFinishedHighSchoolValid() {
        if (this.getSchoolLevel() == null) {
            return false;
        }
        return this.getCountryWhereFinishedHighSchoolLevel() != null && !this.getSchoolLevel().isSchoolLevelBasicCycle() || this.getCountryWhereFinishedHighSchoolLevel() == null && this.getSchoolLevel().isSchoolLevelBasicCycle();
    }

    public boolean isHighSchoolLevelValid() {
        return !this.getSchoolLevel().isHighSchoolOrEquivalent() || this.getHighSchoolType() != null;
    }

    public boolean isProfessionTypeValid() {
        return this.hasProfessionType() && this.getProfessionType().isActive();
    }

    public boolean isProfessionalConditionValid() {
        return this.hasProfessionalCondition() && this.getProfessionalCondition() != ProfessionalSituationConditionType.MILITARY_SERVICE && this.getProfessionalCondition() != ProfessionalSituationConditionType.UNKNOWN;
    }

    public boolean isMotherProfessionTypeValid() {
        return this.hasMotherProfessionType() && this.getMotherProfessionType().isActive();
    }

    public boolean isMotherProfessionalConditionValid() {
        return this.hasMotherProfessionalCondition() && this.getMotherProfessionalCondition() != ProfessionalSituationConditionType.MILITARY_SERVICE && this.getMotherProfessionalCondition() != ProfessionalSituationConditionType.UNKNOWN;
    }

    public boolean isMotherSchoolLevelValid() {
        return this.hasMotherSchoolLevel() && this.getMotherSchoolLevel().isForStudentHousehold();
    }

    public boolean isFatherProfessionTypeValid() {
        return this.hasFatherProfessionType() && this.getFatherProfessionType().isActive();
    }

    public boolean isFatherProfessionalConditionValid() {
        return this.hasFatherProfessionalCondition() && this.getFatherProfessionalCondition() != ProfessionalSituationConditionType.MILITARY_SERVICE && this.getFatherProfessionalCondition() != ProfessionalSituationConditionType.UNKNOWN;
    }

    public boolean isFatherSchoolLevelValid() {
        return this.hasFatherSchoolLevel() && this.getFatherSchoolLevel().isForStudentHousehold();
    }

    public boolean isValid() {
        return this.validate().isEmpty();
    }

    public boolean isValidForAcademicService() {
        return this.validateForAcademicService().isEmpty();
    }

    public void addDocumentFile(File file) {
        this.documentFiles.add(file);
    }

    public Collection<File> getDocumentFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : this.documentFiles) {
            result.add(file);
        }
        return result;
    }

    public void resetInstitutionAndDegree() {
        this.setInstitution(null);
        this.setInstitutionName(null);
        this.setDegreeDesignation(null);
        this.setRaidesDegreeDesignation(null);
    }

    public void resetDegree() {
        this.setDegreeDesignation(null);
        this.setRaidesDegreeDesignation(null);
    }

    public String getFormattedValues() {
        Formatter result = new Formatter();
        Student student = this.getStudent();
        result.format("Student Number: %d\n", student.getNumber());
        result.format("Name: %s\n", student.getPerson().getName());
        if (this.hasPhdIndividualProgramProcess()) {
            result.format("Degree: %s\n", this.getPhdIndividualProgramProcess().getDisplayName());
        } else {
            result.format("Degree: %s\n", this.getRegistration().getDegree().getPresentationName());
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersonalInformationBean)) {
            return false;
        }
        PersonalInformationBean other = (PersonalInformationBean)obj;
        if (this.hasPhdIndividualProgramProcess() && other.hasPhdIndividualProgramProcess()) {
            return this.getPhdIndividualProgramProcess().equals((Object)other.getPhdIndividualProgramProcess());
        }
        if (this.hasRegistration() && other.hasRegistration()) {
            return this.getRegistration().equals((Object)other.getRegistration());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this.hasPhdIndividualProgramProcess() ? 37 * result + this.getPhdIndividualProgramProcess().hashCode() : 37 * result + this.getRegistration().hashCode();
        return result;
    }

    public String getDescription() {
        if (this.hasPhdIndividualProgramProcess()) {
            return BundleUtil.getString((String)"resources.GEPResources", (String)"label.personal.ingression.data.viewer.phd.program.name", (String[])new String[0]) + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.in", (String[])new String[0]) + " " + this.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent();
        }
        return this.getRegistration().getDegreeNameWithDescription();
    }

    public void setRaidesDegreeDesignation(DegreeDesignation raidesDegreeDesignation) {
        this.raidesDegreeDesignation = raidesDegreeDesignation;
    }

    public DegreeDesignation getRaidesDegreeDesignation() {
        return this.raidesDegreeDesignation;
    }

    public boolean hasRaidesDegreeDesignation() {
        return this.raidesDegreeDesignation != null;
    }

    public void setDegreeChangeOrTransferOrErasmusStudent(boolean degreeChangeOrTransferOrErasmusStudent) {
        this.degreeChangeOrTransferOrErasmusStudent = degreeChangeOrTransferOrErasmusStudent;
    }

    public boolean isDegreeChangeOrTransferOrErasmusStudent() {
        return this.degreeChangeOrTransferOrErasmusStudent;
    }

    public SchoolLevelType getPrecedentSchoolLevel() {
        return this.precedentSchoolLevel;
    }

    public void setPrecedentSchoolLevel(SchoolLevelType precedentSchoolLevel) {
        this.precedentSchoolLevel = precedentSchoolLevel;
    }

    public void setOtherPrecedentSchoolLevel(String otherPrecedentSchoolLevel) {
        this.otherPrecedentSchoolLevel = otherPrecedentSchoolLevel;
    }

    public String getOtherPrecedentSchoolLevel() {
        return this.otherPrecedentSchoolLevel;
    }

    public Unit getPrecedentInstitution() {
        return this.precedentInstitution;
    }

    public void setPrecedentInstitution(Unit precedentInstitution) {
        this.precedentInstitution = precedentInstitution;
    }

    public String getPrecedentInstitutionName() {
        return this.precedentInstitutionName;
    }

    public void setPrecedentInstitutionName(String precedentInstitutionName) {
        this.precedentInstitutionName = precedentInstitutionName;
    }

    public UnitName getPrecedentInstitutionUnitName() {
        return this.getPrecedentInstitution() == null ? null : this.getPrecedentInstitution().getUnitName();
    }

    public void setPrecedentInstitutionUnitName(UnitName institutionUnitName) {
        this.setPrecedentInstitution(institutionUnitName == null ? null : institutionUnitName.getUnit());
    }

    public String getPrecedentDegreeDesignation() {
        return this.getPrecedentDegreeDesignationObject() != null ? this.getPrecedentDegreeDesignationObject().getDescription() : this.precedentDegreeDesignation;
    }

    public void setPrecedentDegreeDesignation(String precedentDegreeDesignation) {
        this.precedentDegreeDesignation = precedentDegreeDesignation;
    }

    public void setPrecedentDegreeDesignationObject(DegreeDesignation precedentDegreeDesignationObject) {
        this.precedentDegreeDesignationObject = precedentDegreeDesignationObject;
    }

    public DegreeDesignation getPrecedentDegreeDesignationObject() {
        return this.precedentDegreeDesignationObject;
    }

    public Integer getNumberOfPreviousYearEnrolmentsInPrecedentDegree() {
        return this.numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public void setNumberOfPreviousYearEnrolmentsInPrecedentDegree(Integer numberOfPreviousYearEnrolmentsInPrecedentDegree) {
        this.numberOfPreviousYearEnrolmentsInPrecedentDegree = numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public SchoolPeriodDuration getMobilityProgramDuration() {
        return this.mobilityProgramDuration;
    }

    public void setMobilityProgramDuration(SchoolPeriodDuration mobilityProgramDuration) {
        this.mobilityProgramDuration = mobilityProgramDuration;
    }

    private PrecedentDegreeInformation getPrecedentDegreeInformation() {
        if (this.hasPhdIndividualProgramProcess()) {
            return this.getPhdIndividualProgramProcess().getPrecedentDegreeInformation(ExecutionYear.readCurrentExecutionYear());
        }
        return this.getRegistration().getPrecedentDegreeInformation(ExecutionYear.readCurrentExecutionYear());
    }

    public Student getStudent() {
        if (this.hasPhdIndividualProgramProcess()) {
            return this.getPhdIndividualProgramProcess().getPerson().getStudent();
        }
        return this.getRegistration().getStudent();
    }

    public void updatePersonalInformation(boolean bl) {
        Object object = advice$updatePersonalInformation.perform((Callable)new PersonalInformationBean$callable$updatePersonalInformation(this, bl));
    }

    static /* synthetic */ void advised$updatePersonalInformation(PersonalInformationBean this_, boolean isStudentEditing) {
        PersonalIngressionData personalData;
        PrecedentDegreeInformation precedentInfo = this_.getPrecedentDegreeInformation();
        if (precedentInfo == null) {
            precedentInfo = new PrecedentDegreeInformation();
            if (this_.hasPhdIndividualProgramProcess()) {
                precedentInfo.setPhdIndividualProgramProcess(this_.getPhdIndividualProgramProcess());
            } else {
                precedentInfo.setRegistration(this_.getRegistration());
            }
            ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
            personalData = this_.getStudent().getPersonalIngressionDataByExecutionYear(currentExecutionYear);
            if (personalData == null) {
                personalData = new PersonalIngressionData(this_.getStudent(), currentExecutionYear, precedentInfo);
            } else {
                personalData.addPrecedentDegreesInformations(precedentInfo);
            }
        } else {
            personalData = precedentInfo.getPersonalIngressionData();
        }
        precedentInfo.edit(this_, isStudentEditing);
        personalData.edit(this_);
    }

    static {
        advice$updatePersonalInformation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        limitDate = new LocalDate(2014, 12, 16);
        COMPARATOR_BY_DESCRIPTION = new Comparator<PersonalInformationBean>(){

            @Override
            public int compare(PersonalInformationBean o1, PersonalInformationBean o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }
        };
    }
}

