/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Strings;
import java.util.Optional;
import org.fenixedu.academic.domain.TeacherCategory_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;

public class TeacherCategory
extends TeacherCategory_Base
implements Comparable<TeacherCategory> {
    protected TeacherCategory() {
        this.setRoot(Bennu.getInstance());
    }

    public TeacherCategory(String code, LocalizedString name, Integer weight) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setWeight(weight);
    }

    public static Optional<TeacherCategory> findByCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return Optional.empty();
        }
        return Bennu.getInstance().getTeacherCategorySet().stream().filter(c -> code.equals(c.getCode())).findAny();
    }

    @Override
    public int compareTo(TeacherCategory o) {
        int weigth = this.getWeight().compareTo(o.getWeight());
        if (weigth != 0) {
            return -weigth;
        }
        int byName = this.getName().compareTo(o.getName());
        if (byName != 0) {
            return byName;
        }
        return this.getExternalId().compareTo(o.getExternalId());
    }

    public void setCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            throw new DomainException("teacher.category.code.empty", code);
        }
        Optional<TeacherCategory> category = TeacherCategory.findByCode(code);
        if (category.isPresent() && !this.equals(category.get())) {
            throw new DomainException("teacher.category.code.already.exists", code);
        }
        super.setCode(code);
    }
}

