/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Objects;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization_Base;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;

public class TeacherAuthorization
extends TeacherAuthorization_Base
implements Comparable<TeacherAuthorization> {
    protected TeacherAuthorization() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCreationDate(DateTime.now());
    }

    protected TeacherAuthorization(Teacher teacher, Department department, ExecutionSemester executionSemester, TeacherCategory teacherCategory, Boolean contracted, Double lessonHours, Double workPercentageInInstitution) {
        this();
        this.setTeacher(teacher);
        this.setDepartment(department);
        this.setExecutionSemester(executionSemester);
        this.setTeacherCategory(teacherCategory);
        this.setContracted(contracted);
        this.setLessonHours(lessonHours);
        this.setWorkPercentageInInstitution(workPercentageInInstitution);
        this.setAuthorizer(Authenticate.getUser());
    }

    public static TeacherAuthorization createOrUpdate(Teacher teacher, Department department, ExecutionSemester executionSemester, TeacherCategory teacherCategory, Boolean contracted, Double lessonHours, Double workPercentageInInstitution) {
        Objects.requireNonNull(teacher);
        Objects.requireNonNull(department);
        Objects.requireNonNull(executionSemester);
        Objects.requireNonNull(teacherCategory);
        Objects.requireNonNull(contracted);
        Objects.requireNonNull(lessonHours);
        TeacherAuthorization existing = teacher.getTeacherAuthorization(executionSemester.getAcademicInterval()).orElse(null);
        if (existing != null) {
            if (existing.getDepartment().equals((Object)department) && existing.getContracted().equals(contracted) && existing.getLessonHours().equals(lessonHours)) {
                return existing;
            }
            existing.revoke();
        }
        return new TeacherAuthorization(teacher, department, executionSemester, teacherCategory, contracted, lessonHours, workPercentageInInstitution);
    }

    public DateTime getCreationDate() {
        return super.getCreationDate();
    }

    public void revoke() {
        this.setRevokedTeacher(this.getTeacher());
        this.setTeacher(null);
        this.setRevokedDepartment(this.getDepartment());
        this.setDepartment(null);
        this.setRevokedExecutionSemester(this.getExecutionSemester());
        this.setExecutionSemester(null);
        this.setRevoker(Authenticate.getUser());
        this.setRevokeTime(new DateTime());
        this.setRevokedRootDomainObject(this.getRootDomainObject());
        this.setRootDomainObject(null);
    }

    public Department getDepartment() {
        if (this.getRevokedRootDomainObject() != null) {
            return this.getRevokedDepartment();
        }
        return super.getDepartment();
    }

    public ExecutionSemester getExecutionSemester() {
        if (this.getRevokedRootDomainObject() != null) {
            return this.getRevokedExecutionSemester();
        }
        return super.getExecutionSemester();
    }

    public Teacher getTeacher() {
        if (this.getRevokedRootDomainObject() != null) {
            return this.getRevokedTeacher();
        }
        return super.getTeacher();
    }

    public TeacherCategory getTeacherCategory() {
        return super.getTeacherCategory();
    }

    public boolean isContracted() {
        return super.getContracted();
    }

    public Double getLessonHours() {
        return super.getLessonHours();
    }

    public Double getWorkPercentageInInstitution() {
        return super.getWorkPercentageInInstitution();
    }

    public User getAuthorizer() {
        return super.getAuthorizer();
    }

    public User getRevoker() {
        return super.getRevoker();
    }

    public DateTime getRevokeTime() {
        return super.getRevokeTime();
    }

    @Override
    public int compareTo(TeacherAuthorization o) {
        int semester = this.getExecutionSemester().compareTo(o.getExecutionSemester());
        if (semester != 0) {
            return semester;
        }
        int category = this.getTeacherCategory().compareTo(o.getTeacherCategory());
        if (category != 0) {
            return category;
        }
        return this.getExternalId().compareTo(o.getExternalId());
    }
}

