/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.enrollments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.ReadClassTimeTableByStudent;
import org.fenixedu.academic.service.services.enrollment.shift.WriteStudentAttendingCourse;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.student.ReadStudentTimeTable;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixTransactionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="resourceAllocationManager", path="/studentShiftEnrollmentManagerLookup", input="/studentShiftEnrollmentManager.do?method=prepare", formBean="studentShiftEnrollmentForm", validate=false, functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="prepareShiftEnrollment", path="/resourceAllocationManager/studentShiftEnrollmentManager.do?method=prepareShiftEnrollment"), @Forward(name="prepareEnrollmentViewWarning", path="/resourceAllocationManager/studentShiftEnrollmentManager.do?method=prepareStartViewWarning"), @Forward(name="showShiftsToEnroll", path="/student/enrollment/showShiftsToEnroll.jsp"), @Forward(name="beginTransaction", path="/resourceAllocationManager/studentShiftEnrollmentManager.do?method=start&firstTime=true")})
@Exceptions(value={@ExceptionHandling(type=FenixTransactionException.class, key="error.transaction.enrolment", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=NotAuthorizedException.class, key="error.message.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=ClassEnrollmentAuthorizationFilter.CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan.class, key="error.message.CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=ClassEnrollmentAuthorizationFilter.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan.class, key="error.message.OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan", handler=FenixErrorExceptionHandler.class, scope="request")})
public class ShiftStudentEnrollmentManagerLookupDispatchAction
extends FenixDispatchAction {
    private Registration getAndSetRegistration(HttpServletRequest request) {
        Registration registration = (Registration)FenixFramework.getDomainObject((String)this.getStringFromRequest(request, "registrationOID"));
        if (!registration.getPerson().getStudent().getRegistrationsToEnrolInShiftByStudent().contains((Object)registration)) {
            return null;
        }
        request.setAttribute("registration", (Object)registration);
        request.setAttribute("registrationOID", (Object)registration.getExternalId().toString());
        request.setAttribute("ram", (Object)Boolean.TRUE);
        return registration;
    }

    public ActionForward addCourses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixTransactionException {
        this.validateToken(request, actionForm, mapping, "error.transaction.enrollment");
        Registration registration = this.getAndSetRegistration(request);
        if (registration == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        this.checkParameter(request);
        User userView = ShiftStudentEnrollmentManagerLookupDispatchAction.getUserView(request);
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionCourseId = (String)form.get("wantedCourse");
        try {
            WriteStudentAttendingCourse.runWriteStudentAttendingCourse(registration, executionCourseId);
        }
        catch (NotAuthorizedException exception) {
            this.addActionMessage(request, "error.attend.curricularCourse.impossibleToEnroll");
            return mapping.getInputForward();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("prepareShiftEnrollment");
        }
        catch (FenixServiceException exception) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        return mapping.findForward("prepareShiftEnrollment");
    }

    public ActionForward removeCourses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixTransactionException {
        this.validateToken(request, actionForm, mapping, "error.transaction.enrollment");
        Registration registration = this.getAndSetRegistration(request);
        if (registration == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        this.checkParameter(request);
        DynaActionForm form = (DynaActionForm)actionForm;
        Integer executionCourseId = (Integer)form.get("removedCourse");
        if (executionCourseId == null) {
            return mapping.findForward("prepareShiftEnrollment");
        }
        throw new UnsupportedOperationException("Service DeleteStudentAttendingCourse no longer exists!");
    }

    public ActionForward proceedToShiftEnrolment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.checkParameter(request);
        this.keepInRequest(request, "executionSemesterID");
        String classIdSelected = this.readClassSelected(request);
        Registration registration = this.getAndSetRegistration(request);
        if (registration == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        List<SchoolClass> schoolClassesToEnrol = this.readStudentSchoolClassesToEnrolUsingExecutionCourse(request, registration, executionCourse);
        request.setAttribute("schoolClassesToEnrol", schoolClassesToEnrol);
        if (schoolClassesToEnrol.isEmpty()) {
            return mapping.findForward("prepareShiftEnrollment");
        }
        SchoolClass schoolClass = this.setSelectedSchoolClass(request, classIdSelected, schoolClassesToEnrol);
        User userView = ShiftStudentEnrollmentManagerLookupDispatchAction.getUserView(request);
        List<InfoShowOccupation> infoClasslessons = ReadClassTimeTableByStudent.runReadClassTimeTableByStudent(registration, schoolClass, executionCourse);
        request.setAttribute("infoClasslessons", infoClasslessons);
        request.setAttribute("infoClasslessonsEndTime", (Object)this.getEndTime(infoClasslessons));
        List<InfoShowOccupation> infoLessons = ReadStudentTimeTable.run(registration, null);
        request.setAttribute("person", (Object)registration.getPerson());
        request.setAttribute("infoLessons", infoLessons);
        request.setAttribute("infoLessonsEndTime", (Object)this.getEndTime(infoLessons));
        return mapping.findForward("showShiftsToEnroll");
    }

    private SchoolClass setSelectedSchoolClass(HttpServletRequest request, String classIdSelected, List<SchoolClass> schoolClassesToEnrol) {
        SchoolClass schoolClass = classIdSelected != null ? this.searchSchoolClassFrom(schoolClassesToEnrol, classIdSelected) : schoolClassesToEnrol.iterator().next();
        request.setAttribute("selectedSchoolClass", (Object)schoolClass);
        return schoolClass;
    }

    private SchoolClass searchSchoolClassFrom(List<SchoolClass> schoolClassesToEnrol, final String classId) {
        return (SchoolClass)((Object)CollectionUtils.find(schoolClassesToEnrol, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((SchoolClass)((Object)object)).getExternalId().equals(classId);
            }
        }));
    }

    private List<SchoolClass> readStudentSchoolClassesToEnrolUsingExecutionCourse(HttpServletRequest request, Registration registration, ExecutionCourse executionCourse) {
        ArrayList<SchoolClass> schoolClassesToEnrol = new ArrayList<SchoolClass>();
        if (executionCourse != null) {
            request.setAttribute("executionCourse", (Object)executionCourse);
            schoolClassesToEnrol.addAll(registration.getSchoolClassesToEnrolBy(executionCourse));
        } else {
            schoolClassesToEnrol.addAll(registration.getSchoolClassesToEnrol());
        }
        Collections.sort(schoolClassesToEnrol, SchoolClass.COMPARATOR_BY_NAME);
        return schoolClassesToEnrol;
    }

    private ExecutionCourse getExecutionCourse(HttpServletRequest request) {
        if (!StringUtils.isEmpty((String)request.getParameter("executionCourseID"))) {
            return (ExecutionCourse)FenixFramework.getDomainObject((String)request.getParameter("executionCourseID"));
        }
        return null;
    }

    private int getEndTime(List<InfoShowOccupation> infoShowOccupations) {
        int endTime = 0;
        for (InfoShowOccupation infoShowOccupation : infoShowOccupations) {
            int tempEnd = infoShowOccupation.getLastHourOfDay();
            if (endTime >= tempEnd) continue;
            endTime = tempEnd;
        }
        return endTime;
    }

    private void checkParameter(HttpServletRequest request) {
        String selectCourses = request.getParameter("selectCourses");
        if (selectCourses != null) {
            request.setAttribute("selectCourses", (Object)selectCourses);
        }
    }

    private String readClassSelected(HttpServletRequest request) {
        String classIdSelectedString = request.getParameter("classId");
        String classIdSelected = null;
        classIdSelected = classIdSelectedString != null ? classIdSelectedString : (String)request.getAttribute("classId");
        return classIdSelected;
    }

    public ActionForward prepareStartViewWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getAndSetRegistration(request) == null) {
            this.addActionMessage(request, "errors.impossible.operation");
            return mapping.getInputForward();
        }
        return mapping.findForward("prepareEnrollmentViewWarning");
    }

    protected void validateToken(HttpServletRequest request, ActionForm form, ActionMapping mapping, String errorMessageKey) throws FenixTransactionException {
        if (!this.isTokenValid(request)) {
            form.reset(mapping, request);
            throw new FenixTransactionException(errorMessageKey);
        }
        this.generateToken(request);
        this.saveToken(request);
    }
}

