/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.enrollments;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.enrollment.shift.ShiftEnrollmentErrorReport;
import org.fenixedu.academic.service.services.enrollment.shift.EnrollStudentInShifts;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="resourceAllocationManager", path="/enrollStudentInShifts", input="/studentShiftEnrollmentManagerLookup.do?method=proceedToShiftEnrolment", formBean="studentShiftEnrollmentForm", validate=false, functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="enrollmentConfirmation", path="/resourceAllocationManager/studentShiftEnrollmentManagerLookup.do?method=proceedToShiftEnrolment")})
public class EnrollStudentInShiftsAction
extends FenixAction {
    private static final Logger logger = LoggerFactory.getLogger(EnrollStudentInShiftsAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String shiftId = request.getParameter("shiftId");
        if (!StringUtils.isEmpty((String)request.getParameter("executionCourseID"))) {
            request.setAttribute("executionCourseID", (Object)request.getParameter("executionCourseID"));
        }
        try {
            ShiftEnrollmentErrorReport errorReport = EnrollStudentInShifts.runEnrollStudentInShifts(this.getRegistration(request), shiftId);
            if (errorReport.getUnAvailableShifts().size() > 0) {
                for (Shift shift : errorReport.getUnAvailableShifts()) {
                    if (shift.getLotacao() == 0) {
                        this.addActionMessage(request, "error.shift.enrollment.capacityLocked", shift.getNome());
                        continue;
                    }
                    this.addActionMessage(request, "error.shift.enrollment.capacityExceded", shift.getNome());
                }
            }
            if (errorReport.getUnExistingShifts().size() > 0) {
                this.addActionMessage(request, "error.shift.enrollment.nonExistingShift", new String[0]);
            }
        }
        catch (EnrollStudentInShifts.StudentNotFoundServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.addActionMessage(request, "error.shift.enrollment.nonExistingStudent", new String[0]);
            return mapping.getInputForward();
        }
        catch (FenixServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.addActionMessage(request, e.getMessage(), new String[0]);
            return mapping.getInputForward();
        }
        this.saveMessages(request);
        return mapping.findForward("enrollmentConfirmation");
    }

    private Registration getRegistration(HttpServletRequest request) {
        return (Registration)FenixFramework.getDomainObject((String)request.getParameter("registrationOID"));
    }
}

