/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.student.enrolments;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.phd.student.PhdStudentEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentOptionalEnrollmentBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.student.enrollment.StudentEnrollmentManagementDA;
import org.fenixedu.academic.ui.struts.action.student.enrollment.bolonha.BolonhaStudentEnrollmentDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/phdStudentEnrolment", module="student", functionality=StudentEnrollmentManagementDA.class)
@Forwards(value={@Forward(name="showWelcome", path="/phd/student/enrolments/showWelcome.jsp"), @Forward(name="showDegreeModulesToEnrol", path="/phd/student/enrolments/showDegreeModulesToEnrol.jsp"), @Forward(name="chooseOptionalCurricularCourseToEnrol", path="/phd/student/enrolments/chooseOptionalCurricularCourseToEnrol.jsp")})
public class PhdStudentEnrolmentDA
extends BolonhaStudentEnrollmentDispatchAction {
    private Registration getRegistration(HttpServletRequest request) {
        Registration registration = (Registration)((Object)request.getAttribute("registration"));
        if (registration != null) {
            return registration;
        }
        registration = (Registration)((Object)this.getDomainObject(request, "registrationOid"));
        if (registration != null) {
            return registration;
        }
        BolonhaStudentEnrollmentBean bean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        if (bean != null && bean.getRegistration() != null) {
            return bean.getRegistration();
        }
        BolonhaStudentOptionalEnrollmentBean optionalBean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        if (optionalBean != null && optionalBean.getRegistration() != null) {
            return optionalBean.getRegistration();
        }
        return null;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = this.getRegistration(request);
        if (registration != null && registration.getPhdIndividualProgramProcess() == null) {
            ActionMessages actionMessages = new ActionMessages();
            request.setAttribute("FENIX_ACTION_MESSAGES", (Object)actionMessages);
            this.addActionMessage(request, "label.phd.registration.without.phd.program.process");
            this.saveMessages(request, actionMessages);
            return mapping.findForward("enrollmentCannotProceed");
        }
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    protected BolonhaStudentEnrollmentBean createStudentEnrolmentBean(ActionForm form, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        return new PhdStudentEnrolmentBean(studentCurricularPlan, executionSemester, this.getCurricularYearForCurricularCourses(), this.getCurricularRuleLevel(form));
    }

    @Override
    public ActionForward showWelcome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)request.getAttribute("registration"));
        ExecutionSemester semester = ExecutionSemester.readActualExecutionSemester();
        EnrolmentPeriodInCurricularCourses period = registration.getLastDegreeCurricularPlan().getEnrolmentPeriodInCurricularCoursesBy(semester);
        if (period != null) {
            request.setAttribute("enrolmentPeriod", (Object)period);
        }
        super.showWelcome(mapping, form, request, response);
        return mapping.findForward("showWelcome");
    }

    private void addCompetenceCoursesAvalailableToEnrol(HttpServletRequest request, StudentCurricularPlan studentCurricularPlan) {
        request.setAttribute("competenceCoursesAvailableToEnrol", studentCurricularPlan.getRegistration().getPhdIndividualProgramProcess().getCompetenceCoursesAvailableToEnrol());
    }

    @Override
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        this.addCompetenceCoursesAvalailableToEnrol(request, studentCurricularPlan);
        return super.prepareShowDegreeModulesToEnrol(mapping, form, request, response, studentCurricularPlan, executionSemester);
    }

    @Override
    public ActionForward prepareChooseOptionalCurricularCourseToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentEnrollmentBean bean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        this.addCompetenceCoursesAvalailableToEnrol(request, bean.getStudentCurricularPlan());
        return super.prepareChooseOptionalCurricularCourseToEnrol(mapping, form, request, response);
    }

    @Override
    public ActionForward updateParametersToSearchOptionalCurricularCourses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentOptionalEnrollmentBean bean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        this.addCompetenceCoursesAvalailableToEnrol(request, bean.getStudentCurricularPlan());
        return super.updateParametersToSearchOptionalCurricularCourses(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward enrolInOptionalCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        BolonhaStudentOptionalEnrollmentBean bean = this.getBolonhaStudentOptionalEnrollmentBeanFromViewState();
        this.addCompetenceCoursesAvalailableToEnrol(request, bean.getStudentCurricularPlan());
        return super.enrolInOptionalCurricularCourse(mapping, form, request, response);
    }

    @Override
    public ActionForward prepareChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        throw new RuntimeException("error.PhdStudentEnrolmentBean.unsupported.operation");
    }

    @Override
    public ActionForward enrolInCycleCourseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        throw new RuntimeException("error.PhdStudentEnrolmentBean.unsupported.operation");
    }

    @Override
    protected void enroledWithSuccess(HttpServletRequest request, BolonhaStudentEnrollmentBean bean) {
        if (bean.getStudentCurricularPlan().hasAnyEnrolmentForExecutionPeriod(bean.getExecutionPeriod())) {
            this.addActionMessage("warning", request, "message.phd.enrolments.waiting.for.approval");
        }
    }
}

