/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadNotClosedPublicExecutionPeriodsByExecutionYear;
import org.fenixedu.academic.service.services.publico.ReadPublicExecutionDegreeByDCPID;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.utils.ContextUtils;

public abstract class FenixContextAction
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextUtils.setExecutionPeriodContext(request);
        ContextUtils.prepareChangeExecutionDegreeAndCurricularYear(request);
        return super.execute(mapping, actionForm, request, response);
    }

    protected List<LabelValueBean> buildExecutionPeriodsLabelValueList(String degreeCurricularPlanId) throws FenixActionException {
        List<Object> infoExecutionDegreeList = new ArrayList();
        try {
            infoExecutionDegreeList = ReadPublicExecutionDegreeByDCPID.run(degreeCurricularPlanId);
        }
        catch (Exception e) {
            throw new FenixActionException(e);
        }
        ArrayList<LabelValueBean> result = new ArrayList<LabelValueBean>();
        for (InfoExecutionDegree infoExecutionDegree : infoExecutionDegreeList) {
            try {
                List infoExecutionPeriodsList = ReadNotClosedPublicExecutionPeriodsByExecutionYear.run(infoExecutionDegree.getInfoExecutionYear());
                for (InfoExecutionPeriod infoExecutionPeriodIter : infoExecutionPeriodsList) {
                    result.add(new LabelValueBean(infoExecutionPeriodIter.getName() + " - " + infoExecutionPeriodIter.getInfoExecutionYear().getYear(), infoExecutionPeriodIter.getExternalId().toString()));
                }
            }
            catch (Exception e) {
                throw new FenixActionException(e);
            }
        }
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("value"));
        Collections.sort(result, comparatorChain);
        Collections.reverse(result);
        return result;
    }
}

