/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.EditExternalEnrolmentBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.ExternalCurricularCourseResultBean;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.ExternalCurricularCourseEnrolmentBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.administrativeOffice.enrolment.CreateExternalEnrolments;
import org.fenixedu.academic.service.services.administrativeOffice.enrolment.DeleteExternalEnrolments;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.EditExternalEnrolment;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/studentExternalEnrolments", module="academicAdministration", formBean="studentExternalEnrolmentsForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="manageExternalEnrolments", path="/academicAdminOffice/student/enrollment/bolonha/manageExternalEnrolments.jsp"), @Forward(name="prepareEditExternalEnrolment", path="/academicAdminOffice/student/enrollment/bolonha/editExternalEnrolment.jsp"), @Forward(name="chooseExternalUnit", path="/academicAdminOffice/student/enrollment/bolonha/chooseExternalUnit.jsp"), @Forward(name="chooseExternalCurricularCourses", path="/academicAdminOffice/student/enrollment/bolonha/chooseExternalCurricularCourses.jsp"), @Forward(name="createExternalEnrolments", path="/academicAdminOffice/student/enrollment/bolonha/createExternalEnrolments.jsp"), @Forward(name="viewRegistrationDetails", path="/academicAdminOffice/student/registration/viewRegistrationDetails.jsp")})
public class StudentExternalEnrolmentsDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("contextInformation", (Object)this.getContextInformation());
        request.setAttribute("parameters", (Object)this.getParameters(request));
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward manageExternalEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        return mapping.findForward("manageExternalEnrolments");
    }

    public ActionForward chooseExternalUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        String unitId = (String)this.getFromRequest(request, "unitId");
        if (StringUtils.isNotBlank((String)unitId)) {
            request.setAttribute("unit", (Object)FenixFramework.getDomainObject((String)unitId));
        }
        return mapping.findForward("chooseExternalUnit");
    }

    public ActionForward chooseExternalCurricularCourses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Unit externalUnit = this.getExternalUnit(request, actionForm);
        request.setAttribute("externalUnit", (Object)externalUnit);
        request.setAttribute("externalCurricularCourseBeans", this.buildExternalCurricularCourseResultBeans(externalUnit));
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        return mapping.findForward("chooseExternalCurricularCourses");
    }

    private Set<ExternalCurricularCourseResultBean> buildExternalCurricularCourseResultBeans(Unit unit) {
        TreeSet<ExternalCurricularCourseResultBean> result = new TreeSet<ExternalCurricularCourseResultBean>((Comparator<ExternalCurricularCourseResultBean>)new BeanComparator("fullName"));
        for (ExternalCurricularCourse externalCurricularCourse : unit.getAllExternalCurricularCourses()) {
            result.add(new ExternalCurricularCourseResultBean(externalCurricularCourse));
        }
        return result;
    }

    public ActionForward prepareCreateExternalEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String[] externalCurricularCourseIDs = ((DynaActionForm)actionForm).getStrings("selectedExternalCurricularCourses");
        if (externalCurricularCourseIDs == null || externalCurricularCourseIDs.length == 0) {
            this.addActionMessage(request, "error.StudentEnrolmentDA.must.choose.externalCurricularCourses");
            return this.chooseExternalCurricularCourses(mapping, actionForm, request, response);
        }
        request.setAttribute("externalCurricularCourseEnrolmentBeans", this.buildExternalCurricularCourseEnrolmentBeans(externalCurricularCourseIDs));
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        request.setAttribute("externalUnit", (Object)this.getExternalUnit(request, actionForm));
        return mapping.findForward("createExternalEnrolments");
    }

    private List<ExternalCurricularCourseEnrolmentBean> buildExternalCurricularCourseEnrolmentBeans(String[] externalCurricularCourseIDs) {
        ArrayList<ExternalCurricularCourseEnrolmentBean> result = new ArrayList<ExternalCurricularCourseEnrolmentBean>(externalCurricularCourseIDs.length);
        for (String externalCurricularCourseID : externalCurricularCourseIDs) {
            result.add(new ExternalCurricularCourseEnrolmentBean(this.getExternalCurricularCourseByID(externalCurricularCourseID)));
        }
        return result;
    }

    public ActionForward createExternalEnrolmentsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("externalCurricularCourseEnrolmentBeans", this.getRenderedObject());
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        request.setAttribute("externalUnit", (Object)this.getExternalUnit(request, actionForm));
        return mapping.findForward("createExternalEnrolments");
    }

    public ActionForward createExternalEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        List externalCurricularCourseEnrolmentBeans = (List)this.getRenderedObject("externalCurricularCourseEnrolmentBeans");
        Registration registration = this.getRegistration(request, actionForm);
        try {
            CreateExternalEnrolments.run(registration, externalCurricularCourseEnrolmentBeans);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
            request.setAttribute("externalCurricularCourseEnrolmentBeans", (Object)externalCurricularCourseEnrolmentBeans);
            request.setAttribute("externalUnit", (Object)this.getExternalUnit(request, actionForm));
            return mapping.findForward("createExternalEnrolments");
        }
        return this.backToMainPage(mapping, actionForm, request, response);
    }

    public ActionForward deleteExternalEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String[] externalEnrolmentIDs = ((DynaActionForm)actionForm).getStrings("externalEnrolmentsToDelete");
        Registration registration = this.getRegistration(request, actionForm);
        request.setAttribute("registration", (Object)registration);
        try {
            DeleteExternalEnrolments.run(registration, externalEnrolmentIDs);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
        }
        return mapping.findForward("manageExternalEnrolments");
    }

    public ActionForward prepareEditExternalEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExternalEnrolment externalEnrolment = this.getExternalEnrolment(request, actionForm);
        request.setAttribute("registration", (Object)externalEnrolment.getRegistration());
        request.setAttribute("externalEnrolmentBean", (Object)new EditExternalEnrolmentBean(externalEnrolment));
        return mapping.findForward("prepareEditExternalEnrolment");
    }

    public ActionForward editExternalEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EditExternalEnrolmentBean externalEnrolmentBean = (EditExternalEnrolmentBean)this.getRenderedObject();
        ExternalEnrolment externalEnrolment = externalEnrolmentBean.getExternalEnrolment();
        try {
            EditExternalEnrolment.run(externalEnrolmentBean, externalEnrolment.getRegistration());
            return this.manageExternalEnrolments(mapping, actionForm, request, response);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("externalEnrolmentBean", (Object)externalEnrolmentBean);
        return mapping.findForward("prepareEditExternalEnrolment");
    }

    public ActionForward backToMainPage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.manageExternalEnrolments(mapping, actionForm, request, response);
    }

    public ActionForward cancelExternalEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", (Object)this.getRegistration(request, actionForm));
        return mapping.findForward("viewRegistrationDetails");
    }

    protected String getContextInformation() {
        return "/studentExternalEnrolments.do?";
    }

    protected String getParameters(HttpServletRequest request) {
        return "";
    }

    protected Registration getRegistration(HttpServletRequest request, ActionForm form) {
        return (Registration)FenixFramework.getDomainObject((String)this.getStringFromRequestOrForm(request, (DynaActionForm)form, "registrationId"));
    }

    protected Unit getExternalUnit(HttpServletRequest request, ActionForm actionForm) {
        return (Unit)FenixFramework.getDomainObject((String)this.getStringFromRequestOrForm(request, (DynaActionForm)actionForm, "externalUnitId"));
    }

    protected ExternalCurricularCourse getExternalCurricularCourseByID(String externalCurricularCourseID) {
        return (ExternalCurricularCourse)FenixFramework.getDomainObject((String)externalCurricularCourseID);
    }

    protected ExternalEnrolment getExternalEnrolment(HttpServletRequest request, ActionForm actionForm) {
        return (ExternalEnrolment)FenixFramework.getDomainObject((String)this.getStringFromRequestOrForm(request, (DynaActionForm)actionForm, "externalEnrolmentId"));
    }

    protected String getStringFromRequestOrForm(HttpServletRequest request, DynaActionForm form, String name) {
        String value = this.getStringFromRequest(request, name);
        return value != null ? value : form.getString(name);
    }
}

