/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.ManageStudentCurricularPlansDA$callable$createService;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.ManageStudentCurricularPlansDA$callable$deleteService;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.ManageStudentCurricularPlansDA$callable$editService;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Mapping(path="/manageStudentCurricularPlans", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="viewRegistrationDetails", path="/academicAdminOffice/student/registration/viewRegistrationDetails.jsp"), @Forward(name="create", path="/academicAdminOffice/student/registration/manageStudentCurricularPlans/createStudentCurricularPlan.jsp"), @Forward(name="edit", path="/academicAdminOffice/student/registration/manageStudentCurricularPlans/editStudentCurricularPlan.jsp")})
public class ManageStudentCurricularPlansDA
extends FenixDispatchAction {
    public static final Advice advice$createService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$deleteService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$editService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", (Object)this.getRegistration(request));
        return mapping.findForward("viewRegistrationDetails");
    }

    public ActionForward prepareCreate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlanBean bean = new StudentCurricularPlanBean(this.getRegistration(request));
        request.setAttribute("studentCurricularPlanBean", (Object)bean);
        return mapping.findForward("create");
    }

    public ActionForward prepareCreateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentCurricularPlanBean", this.getRenderedObject("studentCurricularPlanBean"));
        return mapping.findForward("create");
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlanBean bean = (StudentCurricularPlanBean)this.getRenderedObject("studentCurricularPlanBean");
        try {
            this.createService(bean);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            request.setAttribute("studentCurricularPlanBean", (Object)bean);
            return mapping.findForward("create");
        }
        request.setAttribute("registrationId", (Object)bean.getRegistration().getExternalId());
        return this.list(mapping, form, request, response);
    }

    private void createService(StudentCurricularPlanBean studentCurricularPlanBean) {
        Object object = advice$createService.perform((Callable)new ManageStudentCurricularPlansDA$callable$createService(this, studentCurricularPlanBean));
    }

    static /* synthetic */ void advised$createService(ManageStudentCurricularPlansDA this_, StudentCurricularPlanBean bean) {
        bean.getRegistration().createStudentCurricularPlan(bean.getDegreeCurricularPlan(), ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, bean.getExecutionInterval()));
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        Registration registration = studentCurricularPlan.getRegistration();
        try {
            this.deleteService(studentCurricularPlan);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
        }
        request.setAttribute("registrationId", (Object)registration.getExternalId());
        return this.list(mapping, form, request, response);
    }

    private void deleteService(StudentCurricularPlan studentCurricularPlan) {
        Object object = advice$deleteService.perform((Callable)new ManageStudentCurricularPlansDA$callable$deleteService(this, studentCurricularPlan));
    }

    static /* synthetic */ void advised$deleteService(ManageStudentCurricularPlansDA this_, StudentCurricularPlan studentCurricularPlan) {
        studentCurricularPlan.delete();
    }

    public ActionForward prepareEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlanBean bean = new StudentCurricularPlanBean(this.getStudentCurricularPlan(request));
        request.setAttribute("studentCurricularPlanBean", (Object)bean);
        return mapping.findForward("edit");
    }

    public ActionForward prepareEditInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentCurricularPlanBean", this.getRenderedObject("studentCurricularPlanBean"));
        return mapping.findForward("edit");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlanBean bean = (StudentCurricularPlanBean)this.getRenderedObject("studentCurricularPlanBean");
        try {
            this.editService(bean);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            request.setAttribute("studentCurricularPlanBean", (Object)bean);
            return mapping.findForward("edit");
        }
        request.setAttribute("registrationId", (Object)bean.getRegistration().getExternalId());
        return this.list(mapping, form, request, response);
    }

    private void editService(StudentCurricularPlanBean studentCurricularPlanBean) {
        Object object = advice$editService.perform((Callable)new ManageStudentCurricularPlansDA$callable$editService(this, studentCurricularPlanBean));
    }

    static /* synthetic */ void advised$editService(ManageStudentCurricularPlansDA this_, StudentCurricularPlanBean bean) {
        bean.getStudentCurricularPlan().setStartDate(new YearMonthDay((Object)bean.getStartDate()));
    }

    private StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "studentCurricularPlanId"));
    }

    private Registration getRegistration(HttpServletRequest request) {
        return (Registration)((Object)this.getDomainObject(request, "registrationId"));
    }

    public static class StudentCurricularPlanBean
    implements Serializable {
        private Registration registration;
        private DegreeCurricularPlan degreeCurricularPlan;
        private StudentCurricularPlan studentCurricularPlan;
        private ExecutionInterval executionInterval;
        private LocalDate startDate;

        public StudentCurricularPlanBean(Registration registration) {
            this.registration = registration;
        }

        public StudentCurricularPlanBean(StudentCurricularPlan studentCurricularPlan) {
            this.studentCurricularPlan = studentCurricularPlan;
            this.registration = studentCurricularPlan.getRegistration();
            this.degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
            this.startDate = studentCurricularPlan.getStartDateYearMonthDay().toLocalDate();
        }

        public Registration getRegistration() {
            return this.registration;
        }

        public void setRegistration(Registration registration) {
            this.registration = registration;
        }

        public DegreeCurricularPlan getDegreeCurricularPlan() {
            return this.degreeCurricularPlan;
        }

        public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
            this.degreeCurricularPlan = degreeCurricularPlan;
        }

        public StudentCurricularPlan getStudentCurricularPlan() {
            return this.studentCurricularPlan;
        }

        public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
            this.studentCurricularPlan = studentCurricularPlan;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public void setStartDate(LocalDate startDate) {
            this.startDate = startDate;
        }

        public ExecutionInterval getExecutionInterval() {
            return this.executionInterval;
        }

        public void setExecutionInterval(ExecutionInterval executionInterval) {
            this.executionInterval = executionInterval;
        }

        public Collection<? extends ExecutionInterval> getExecutionIntervalOptions() {
            return ExecutionYear.readExecutionYears(this.getRegistration().getStartExecutionYear(), ExecutionYear.readLastExecutionYear());
        }

        public Collection<DegreeCurricularPlan> getDegreeCurricularPlanOptions() {
            return this.getRegistration().getDegree().getDegreeCurricularPlansSet();
        }
    }
}

