/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementEditBean;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.EditMarkSheet;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetSearchDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/editMarkSheet", module="academicAdministration", formBean="markSheetManagementForm", input="/markSheetManagement.do?method=prepareSearchMarkSheet", functionality=MarkSheetSearchDispatchAction.class)
@Forwards(value={@Forward(name="editMarkSheet", path="/academicAdministration/gradeSubmission/editMarkSheet.jsp"), @Forward(name="searchMarkSheetFilled", path="/academicAdministration/markSheetManagement.do?method=prepareSearchMarkSheetFilled")})
public class MarkSheetEditDispatchAction
extends MarkSheetDispatchAction {
    public ActionForward prepareEditMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementEditBean editBean = new MarkSheetManagementEditBean();
        this.fillMarkSheetBean(actionForm, request, editBean);
        DynaActionForm form = (DynaActionForm)actionForm;
        MarkSheet markSheet = (MarkSheet)((Object)this.getDomainObject(form, "msID"));
        editBean.setTeacherId(markSheet.getResponsibleTeacher().getPerson().getUsername());
        editBean.setEvaluationDate(markSheet.getEvaluationDateDateTime().toDate());
        editBean.setMarkSheet(markSheet);
        editBean.setEnrolmentEvaluationBeansToEdit(this.getEnrolmentEvaluationBeansToEdit(markSheet));
        if (markSheet.getMarkSheetState() == MarkSheetState.NOT_CONFIRMED) {
            editBean.setEnrolmentEvaluationBeansToAppend(this.getEnrolmentEvaluationBeansToAppend(markSheet));
        }
        return mapping.findForward("editMarkSheet");
    }

    public ActionForward updateMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MarkSheetManagementEditBean editBean = this.getMarkSheetManagementEditBean();
        request.setAttribute("edit", (Object)editBean);
        ActionMessages actionMessages = this.createActionMessages();
        this.checkIfTeacherIsResponsibleOrCoordinator(editBean.getCurricularCourse(), editBean.getExecutionPeriod(), editBean.getTeacherId(), editBean.getTeacher(), request, editBean.getMarkSheet().getEvaluationSeason(), actionMessages);
        this.checkIfEvaluationDateIsInExamsPeriod(editBean.getDegreeCurricularPlan(), editBean.getExecutionPeriod(), editBean.getEvaluationDate(), editBean.getMarkSheet().getEvaluationSeason(), request, actionMessages);
        if (actionMessages.isEmpty()) {
            try {
                EditMarkSheet.run(editBean.getMarkSheet(), editBean.getTeacher(), editBean.getEvaluationDate());
                editBean.setEnrolmentEvaluationBeansToEdit(this.getEnrolmentEvaluationBeansToEdit(editBean.getMarkSheet()));
                RenderUtils.invalidateViewState((String)"edit-marksheet-enrolments");
                editBean.setEnrolmentEvaluationBeansToAppend(this.getEnrolmentEvaluationBeansToAppend(editBean.getMarkSheet()));
                RenderUtils.invalidateViewState((String)"append-enrolments");
            }
            catch (InvalidArgumentsServiceException e) {
                this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
            }
            catch (DomainException e) {
                this.addMessage(request, actionMessages, e.getMessage(), e.getArgs());
            }
        }
        return mapping.findForward("editMarkSheet");
    }

    public ActionForward editMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MarkSheetManagementEditBean editBean = this.getMarkSheetManagementEditBean();
        ActionMessages actionMessages = this.createActionMessages();
        try {
            EditMarkSheet.run(editBean);
            return mapping.findForward("searchMarkSheetFilled");
        }
        catch (InvalidArgumentsServiceException e) {
            this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
        }
        catch (DomainException e) {
            this.addMessage(request, actionMessages, e.getMessage(), e.getArgs());
        }
        request.setAttribute("edit", (Object)editBean);
        return mapping.findForward("editMarkSheet");
    }

    private MarkSheetManagementEditBean getMarkSheetManagementEditBean() {
        return (MarkSheetManagementEditBean)RenderUtils.getViewState((String)"edit-markSheet").getMetaObject().getObject();
    }

    private Collection<MarkSheetEnrolmentEvaluationBean> getEnrolmentEvaluationBeansToEdit(MarkSheet markSheet) {
        HashSet<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeansToEdit = new HashSet<MarkSheetEnrolmentEvaluationBean>();
        for (EnrolmentEvaluation enrolmentEvaluation : markSheet.getEnrolmentEvaluationsSet()) {
            MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean = new MarkSheetEnrolmentEvaluationBean();
            enrolmentEvaluationBean.setGradeValue(enrolmentEvaluation.getGradeValue());
            enrolmentEvaluationBean.setEvaluationDate(enrolmentEvaluation.getExamDate());
            enrolmentEvaluationBean.setEnrolment(enrolmentEvaluation.getEnrolment());
            enrolmentEvaluationBean.setEnrolmentEvaluation(enrolmentEvaluation);
            enrolmentEvaluationBeansToEdit.add(enrolmentEvaluationBean);
        }
        return enrolmentEvaluationBeansToEdit;
    }

    private Collection<MarkSheetEnrolmentEvaluationBean> getEnrolmentEvaluationBeansToAppend(MarkSheet markSheet) {
        Set<Enrolment> enrolments = markSheet.getCurricularCourse().getEnrolmentsNotInAnyMarkSheet(markSheet.getEvaluationSeason(), markSheet.getExecutionPeriod());
        HashSet<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeansToAppend = new HashSet<MarkSheetEnrolmentEvaluationBean>();
        for (Enrolment enrolment : enrolments) {
            MarkSheetEnrolmentEvaluationBean markSheetEnrolmentEvaluationBean = new MarkSheetEnrolmentEvaluationBean();
            markSheetEnrolmentEvaluationBean.setEnrolment(enrolment);
            markSheetEnrolmentEvaluationBean.setEvaluationDate(markSheet.getEvaluationDate());
            enrolmentEvaluationBeansToAppend.add(markSheetEnrolmentEvaluationBean);
        }
        return enrolmentEvaluationBeansToAppend;
    }
}

