/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.department;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.RemoveDegreeFromDepartment;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminDCPApp.class, path="department-degrees", titleKey="label.manage.department.degrees", accessGroup="academic(MANAGE_DEGREE_CURRICULAR_PLANS)")
@Mapping(module="academicAdministration", path="/manageDepartmentDegrees", input="/manageDepartmentDegrees.do?method=prepare")
@Forwards(value={@Forward(name="manageDepartmentDegrees", path="/academicAdministration/department/manageDepartmentDegrees.jsp")})
public class DepartmentDegreesDAForAcademicAdministration
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        DepartmentDegreeBean departmentDegreeBean = (DepartmentDegreeBean)this.getRenderedObject();
        if (departmentDegreeBean == null) {
            departmentDegreeBean = new DepartmentDegreeBean();
        }
        return this.forwardToPage(mapping, request, departmentDegreeBean);
    }

    public ActionForward associate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        this.executeFactoryMethod();
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        String departmentString = request.getParameter("departmentID");
        String degreeString = request.getParameter("degreeID");
        Department department = (Department)FenixFramework.getDomainObject((String)departmentString);
        Degree degree = (Degree)FenixFramework.getDomainObject((String)degreeString);
        RemoveDegreeFromDepartment.run(department, degree);
        DepartmentDegreeBean departmentDegreeBean = new DepartmentDegreeBean();
        departmentDegreeBean.setDepartment(department);
        return this.forwardToPage(mapping, request, departmentDegreeBean);
    }

    private ActionForward forwardToPage(ActionMapping mapping, HttpServletRequest request, DepartmentDegreeBean departmentDegreeBean) {
        request.setAttribute("departmentDegreeBean", (Object)departmentDegreeBean);
        return mapping.findForward("manageDepartmentDegrees");
    }

    public static class DepartmentDegreeBean
    implements FactoryExecutor,
    Serializable {
        private Department department;
        private Degree degree;

        public Department getDepartment() {
            return this.department;
        }

        public void setDepartment(Department department) {
            this.department = department;
        }

        public Degree getDegree() {
            return this.degree;
        }

        public void setDegree(Degree degree) {
            this.degree = degree;
        }

        @Override
        public Object execute() {
            Department department = this.getDepartment();
            Degree degree = this.getDegree();
            if (department != null && degree != null) {
                department.getDegreesSet().add(degree);
            }
            return null;
        }
    }
}

