/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.executionDegree;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.dto.administrativeOffice.ExecutionDegreeBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreesToCreateRegistration
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        Set allowed = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.CREATE_REGISTRATION, Authenticate.getUser()).collect(Collectors.toSet());
        ExecutionYear year = source instanceof ExecutionDegreeBean ? ((ExecutionDegreeBean)source).getExecutionYear() : null;
        Set executed = year != null && !year.getExecutionDegreesSet().isEmpty() ? ((ExecutionDegreeBean)source).getExecutionYear().getExecutionDegreesSet().stream().map(i -> i.getDegree()).collect(Collectors.toSet()) : Bennu.getInstance().getExecutionDegreesSet().stream().map(i -> i.getDegree()).collect(Collectors.toSet());
        return Sets.intersection(executed, allowed).stream().sorted(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID).collect(Collectors.toList());
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

