/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.Collections;
import java.util.Properties;
import org.fenixedu.academic.ui.struts.action.publico.KaptchaAction;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.Face;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;

public class CaptchaRenderer
extends InputRenderer {
    private static final String DEFAULT_IMAGE_STYLE = "border: 1px solid rgb(187, 187, 187); padding: 5px;";
    private static final String DEFAULT_TEXT_STYLE = "mbottom05";
    private String imageStyle = "border: 1px solid rgb(187, 187, 187); padding: 5px;";
    private String textStyle = "mbottom05";
    private String jcaptchaUrl;

    public String getImageStyle() {
        return this.imageStyle;
    }

    public void setImageStyle(String imageStyle) {
        this.imageStyle = imageStyle;
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String textStyle) {
        this.textStyle = textStyle;
    }

    public String getJcaptchaUrl() {
        return this.jcaptchaUrl;
    }

    public void setJcaptchaUrl(String jcaptchaUrl) {
        this.jcaptchaUrl = jcaptchaUrl;
    }

    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            protected String getResourceMessage(String message) {
                return RenderUtils.getResourceString((String)"RENDERER_RESOURCES", (String)message);
            }

            public HtmlComponent createComponent(Object object, Class type) {
                this.addValidator();
                MetaSlotKey key = (MetaSlotKey)CaptchaRenderer.this.getInputContext().getMetaObject().getKey();
                HtmlBlockContainer container = new HtmlBlockContainer();
                HtmlImage image = new HtmlImage();
                image.setSource(CaptchaRenderer.this.getContext().getViewState().getRequest().getContextPath() + CaptchaRenderer.this.getJcaptchaUrl());
                image.setStyle(CaptchaRenderer.this.getImageStyle());
                container.addChild((HtmlComponent)image);
                HtmlText text = new HtmlText(this.getResourceMessage("fenix.renderers.captcha.process"));
                text.setFace(Face.PARAGRAPH);
                text.setClasses(CaptchaRenderer.this.getTextStyle());
                container.addChild((HtmlComponent)text);
                HtmlTextInput input = new HtmlTextInput();
                input.setName(key.toString() + "_response");
                input.setTargetSlot(key);
                container.addChild((HtmlComponent)input);
                return container;
            }

            private void addValidator() {
                MetaObject metaObject = CaptchaRenderer.this.getInputContext().getMetaObject();
                if (metaObject != null && metaObject instanceof MetaSlot) {
                    MetaSlot metaSlot = (MetaSlot)metaObject;
                    Class<CaptchaValidator> defaultValidator = CaptchaValidator.class;
                    Properties properties = new Properties();
                    metaSlot.setValidators(Collections.singletonList(new ValidatorProperties(defaultValidator, properties)));
                }
            }
        };
    }

    public static class CaptchaValidator
    extends HtmlValidator {
        private static final long serialVersionUID = 5199426957775725692L;

        public CaptchaValidator() {
            this.setMessage("renderers.validator.invalid.captcha.value");
        }

        public CaptchaValidator(HtmlChainValidator htmlChainValidator) {
            super(htmlChainValidator);
            this.setMessage("renderers.validator.invalid.captcha.value");
        }

        public void performValidation() {
            HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
            String value = component.getValue();
            if (value == null || value.length() == 0) {
                this.setMessage("renderers.validator.captcha.required");
                this.setValid(false);
            } else if (!KaptchaAction.validateResponse(RenderersRequestProcessorImpl.getCurrentRequest().getSession(), value)) {
                this.setMessage("renderers.validator.invalid.captcha.value");
                this.setValid(false);
            } else {
                this.setValid(true);
            }
        }
    }
}

