/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.util.DateFormatUtil;

public class CalendarLink {
    private Calendar objectOccurrence;
    private String objectLinkLabel;
    private Map<String, String> linkParameters = new HashMap<String, String>();
    private boolean asLink;
    private static final MessageResources messages = MessageResources.getMessageResources((String)"resources.PublicDegreeInformation");

    public CalendarLink(boolean asLink) {
        this.setAsLink(asLink);
    }

    public CalendarLink() {
        this(true);
    }

    public CalendarLink(ExecutionCourse executionCourse, WrittenEvaluation writtenEvaluation, Locale locale) {
        this.setObjectOccurrence(writtenEvaluation.getDay());
        this.setObjectLinkLabel(this.constructCalendarPresentation(executionCourse, writtenEvaluation, locale));
    }

    public CalendarLink(ExecutionCourse executionCourse, Project project, Date date, String tail, Locale locale) {
        this.setObjectOccurrence(date);
        this.setObjectLinkLabel(this.constructCalendarPresentation(executionCourse, project, date, tail, locale));
    }

    public void setObjectOccurrence(Calendar objectOccurrence) {
        this.objectOccurrence = objectOccurrence;
    }

    public void setObjectOccurrence(Date objectOccurrence) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(objectOccurrence);
        this.objectOccurrence = calendar;
    }

    public Calendar getObjectOccurrence() {
        return this.objectOccurrence;
    }

    public void setObjectLinkLabel(String objectLinkLabel) {
        this.objectLinkLabel = objectLinkLabel;
    }

    public String getObjectLinkLabel() {
        return this.objectLinkLabel;
    }

    public void setLinkParameters(Map<String, String> linkParameters) {
        this.linkParameters = linkParameters;
    }

    public String giveLink(String editLinkPage) {
        StringBuilder linkParameters = new StringBuilder();
        linkParameters.append(editLinkPage);
        if (this.linkParameters != null && !this.linkParameters.isEmpty()) {
            linkParameters.append(editLinkPage.indexOf(63) > 0 ? (char)'&' : '?');
            Iterator<Map.Entry<String, String>> iterator = this.linkParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                linkParameters.append(entry.getKey());
                linkParameters.append('=');
                linkParameters.append(entry.getValue());
                if (!iterator.hasNext()) continue;
                linkParameters.append('&');
            }
        }
        return linkParameters.toString();
    }

    public void addLinkParameter(String key, String value) {
        this.linkParameters.put(key, value);
    }

    private String constructCalendarPresentation(ExecutionCourse executionCourse, WrittenEvaluation writtenEvaluation, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (writtenEvaluation instanceof WrittenTest) {
            stringBuilder.append(messages.getMessage(locale, "label.evaluation.shortname.test"));
        } else if (writtenEvaluation instanceof Exam) {
            stringBuilder.append(messages.getMessage(locale, "label.evaluation.shortname.exam"));
        }
        stringBuilder.append(" ");
        stringBuilder.append(executionCourse.getSigla());
        stringBuilder.append(" (");
        stringBuilder.append(DateFormatUtil.format("HH:mm", writtenEvaluation.getBeginningDate()));
        stringBuilder.append("-");
        stringBuilder.append(DateFormatUtil.format("HH:mm", writtenEvaluation.getEndDate()));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String constructCalendarPresentation(ExecutionCourse executionCourse, Project project, Date time, String tail, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(messages.getMessage(locale, "label.evaluation.shortname.project"));
        stringBuilder.append(" ");
        stringBuilder.append(executionCourse.getSigla());
        stringBuilder.append(" (");
        stringBuilder.append(DateFormatUtil.format("HH:mm", time));
        stringBuilder.append(") ");
        stringBuilder.append(tail);
        return stringBuilder.toString();
    }

    public boolean isAsLink() {
        return this.asLink;
    }

    public void setAsLink(boolean asLink) {
        this.asLink = asLink;
    }
}

