/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.degreeStructure;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeModule;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class UICourseGroup
extends UIDegreeModule {
    private static final String EXPAND_GROUP_ID_PARAM = "expandGroupId";
    public static final String COMPONENT_TYPE = "org.fenixedu.academic.ui.faces.components.degreeStructure.UICourseGroup";
    public static final String COMPONENT_FAMILY = "org.fenixedu.academic.ui.faces.components.degreeStructure.UICourseGroup";
    private final CourseGroup courseGroup;
    private Boolean onlyStructure;
    private Boolean toOrder;
    private Boolean hideCourses;
    private Boolean reportsAvailable;

    public UICourseGroup() {
        this.courseGroup = (CourseGroup)((Object)this.degreeModule);
    }

    public UICourseGroup(DegreeModule courseGroup, Context previousContext, Boolean toEdit, Boolean showRules, int depth, String tabs, Boolean onlyStructure, Boolean toOrder, Boolean hideCourses, Boolean reportsAvailable, ExecutionYear executionYear, String module, String currentPage, Boolean expandable) throws IOException {
        super(courseGroup, previousContext, toEdit, showRules, depth, tabs, executionYear, module, currentPage, expandable);
        if (!(!toOrder.booleanValue() || onlyStructure.booleanValue() && toEdit.booleanValue())) {
            throw new IOException("incorrect.component.usage");
        }
        this.courseGroup = (CourseGroup)((Object)this.degreeModule);
        this.onlyStructure = onlyStructure;
        this.toOrder = toOrder;
        this.hideCourses = hideCourses;
        this.reportsAvailable = reportsAvailable;
    }

    @Override
    public String getFamily() {
        return "org.fenixedu.academic.ui.faces.components.degreeStructure.UICourseGroup";
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.encodeCourseGroup(facesContext);
    }

    private void encodeCourseGroup(FacesContext facesContext) throws IOException {
        this.facesContext = facesContext;
        this.writer = facesContext.getResponseWriter();
        if (this.courseGroup.isRoot()) {
            this.encodeVisibleRoot();
        } else {
            this.encodeSelf();
            this.encodeChildCourseGroups();
        }
    }

    private void encodeVisibleRoot() throws IOException {
        if (this.onlyStructure.booleanValue()) {
            this.writer.startElement("table", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"showinfo3 mbottom0 mtop05", null);
            this.encodeHeader();
            this.encodeChildCourseGroups();
            this.writer.endElement("table");
        } else {
            this.writer.startElement("table", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"showinfo3 mvert0", null);
            this.writer.writeAttribute("style", (Object)"width: 70em;", null);
            this.encodeHeader();
            if (!this.courseGroup.getChildContextsSet().isEmpty()) {
                if (this.showRules.booleanValue() && !this.courseGroup.getCurricularRulesSet().isEmpty()) {
                    this.encodeCurricularRules();
                }
                this.writer.endElement("table");
                if (!this.hideCourses.booleanValue() && this.courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.executionYear).size() > 0) {
                    this.encodeChildCurricularCourses(70, (this.depth + 1) * 3);
                }
                this.encodeChildCourseGroups();
            } else {
                this.writer.startElement("table", (UIComponent)this);
                this.writer.startElement("tr", (UIComponent)this);
                this.writer.startElement("td", (UIComponent)this);
                this.writer.writeAttribute("align", (Object)"center", null);
                this.writer.startElement("i", (UIComponent)this);
                this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"empty.curricularPlan", (String[])new String[0]));
                this.writer.endElement("i");
                this.writer.endElement("td");
                this.writer.endElement("tr");
                this.writer.endElement("table");
            }
        }
    }

    private void encodeChildCourseGroups() throws IOException {
        for (Context context : this.courseGroup.getSortedOpenChildContextsWithCourseGroups(this.executionYear)) {
            new UICourseGroup(context.getChildDegreeModule(), context, this.toEdit, this.showRules, this.depth + 1, this.tabs + "\t", this.onlyStructure, this.toOrder, this.hideCourses, this.reportsAvailable, this.executionYear, this.module, this.currentPage, this.expandable).encodeBegin(this.facesContext);
        }
    }

    private void encodeSelf() throws IOException {
        int width = this.onlyStructure != false ? 50 : 70;
        int courseGroupIndent = this.depth * 3;
        if (!this.onlyStructure.booleanValue()) {
            this.writer.startElement("div", (UIComponent)this);
            this.writer.writeAttribute("style", (Object)("padding-left: " + courseGroupIndent + "em;"), null);
            this.writer.startElement("table", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"showinfo3 mvert0", null);
            this.writer.writeAttribute("style", (Object)("width: " + String.valueOf(width - this.depth * 3) + "em;"), null);
        }
        this.encodeHeader();
        if (!this.onlyStructure.booleanValue()) {
            if (this.showRules.booleanValue() && !this.courseGroup.getCurricularRulesSet().isEmpty()) {
                this.encodeCurricularRules();
            }
            this.writer.endElement("table");
            this.writer.endElement("div");
            if (!this.hideCourses.booleanValue() && this.courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.executionYear).size() > 0) {
                this.encodeChildCurricularCourses(width, courseGroupIndent);
            }
        }
    }

    private void encodeHeader() throws IOException {
        this.writer.startElement("tr", (UIComponent)this);
        this.encodeName(this.reportsAvailable);
        if (this.toEdit.booleanValue()) {
            if (this.onlyStructure.booleanValue()) {
                if (this.toOrder.booleanValue()) {
                    if (!this.courseGroup.isRoot()) {
                        this.encodeOrderOptions();
                    }
                } else {
                    this.encodeEditOptions();
                }
            } else {
                this.encodeCourseGroupOptions();
            }
        }
        this.writer.endElement("tr");
    }

    private void encodeName(boolean linkable) throws IOException {
        if (this.onlyStructure.booleanValue()) {
            this.writer.startElement("td", (UIComponent)this);
            if (this.courseGroup.isRoot()) {
                this.writer.startElement("strong", (UIComponent)this);
            } else {
                this.writer.writeAttribute("style", (Object)("padding-left: " + String.valueOf(this.depth + 2) + "em;"), null);
            }
        } else {
            this.writer.writeAttribute("class", (Object)"bgcolor2", null);
            this.writer.startElement("th", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"aleft", null);
            this.writer.writeAttribute("colspan", (Object)(this.toEdit != false ? 3 : 5), null);
        }
        if (linkable) {
            this.writer.startElement("a", (UIComponent)this);
            this.encodeLinkHref(this.module + "/curricularPlans/courseGroupReport.faces", "&courseGroupID=" + this.courseGroup.getExternalId(), true);
            this.appendCodeAndName();
            this.writer.endElement("a");
        } else {
            this.appendCodeAndName();
        }
        if (this.onlyStructure.booleanValue()) {
            if (this.courseGroup.isRoot()) {
                this.writer.endElement("strong");
            }
            this.writer.endElement("td");
        } else {
            this.writer.endElement("th");
        }
    }

    private void encodeOrderOptions() throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        if (this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
            this.writer.append((CharSequence)"(");
            this.encodeOrderOption(0, "top", false);
            this.encodeOrderOption(this.previousContext.getParentCourseGroup().getChildContextsSet().size() - 1, "end", false);
            this.encodeOrderOption(this.previousContext.getChildOrder() - 1, "up", false);
            this.encodeOrderOption(this.previousContext.getChildOrder() + 1, "down", true);
            this.writer.append((CharSequence)") ");
        }
    }

    private void encodeOrderOption(Integer posToTest, String label, boolean lastOption) throws IOException {
        this.encodeLink(this.module + "/orderCourseGroup.faces", "&courseGroupID=" + this.courseGroup.getExternalId() + "&contextID=" + this.previousContext.getExternalId() + "&pos=" + posToTest + "&toOrder=true", false, label);
        if (!lastOption) {
            this.writer.append((CharSequence)" , ");
        }
    }

    private void encodeEditOptions() throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"aleft", null);
        String createAssociateAditionalParameters = "&parentCourseGroupID=" + this.courseGroup.getExternalId() + "&toOrder=false";
        String editAndDeleteAditionalParameters = "&courseGroupID=" + this.courseGroup.getExternalId() + (!this.courseGroup.isRoot() ? "&contextID=" + this.previousContext.getExternalId() : "") + "&toOrder=false";
        if (this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
            this.writer.append((CharSequence)"(");
            this.encodeLink(this.module + "/createCourseGroup.faces", createAssociateAditionalParameters, false, "create.course.group");
            if (!this.courseGroup.isRoot() && !this.courseGroup.isBranchCourseGroup()) {
                this.writer.append((CharSequence)" , ");
                this.encodeLink(this.module + "/createBranchCourseGroup.faces", createAssociateAditionalParameters, false, "create.branch.group");
            }
            this.writer.append((CharSequence)" , ");
            this.encodeLink(this.module + "/editCourseGroup.faces", editAndDeleteAditionalParameters, false, "edit");
            if (!this.courseGroup.isRoot()) {
                this.writer.append((CharSequence)" , ");
                this.encodeLink(this.module + "/deleteCourseGroup.faces", editAndDeleteAditionalParameters, false, "delete");
            }
            if (this.courseGroup.isCycleCourseGroup()) {
                this.writer.append((CharSequence)" , ");
                this.encodeLink(this.module + "/editCycleCourseGroupInformation.faces", editAndDeleteAditionalParameters, false, "editInformation");
            }
            this.writer.append((CharSequence)") ");
        }
        this.writer.endElement("td");
    }

    private void encodeCourseGroupOptions() throws IOException {
        this.writer.startElement("th", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"aright", null);
        this.writer.writeAttribute("colspan", (Object)3, null);
        boolean expandOptionAvailable = false;
        if (this.expandable.booleanValue() && !this.isToRenderExpanded() && !this.courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.executionYear).isEmpty()) {
            this.encodeLink(this.module + "/" + this.currentPage, "&expandGroupId=" + this.courseGroup.getExternalId(), false, "label.expand");
            expandOptionAvailable = true;
        }
        if (this.showRules.booleanValue()) {
            if (!this.courseGroup.isRoot() || this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
                if (expandOptionAvailable) {
                    this.writer.append((CharSequence)" , ");
                }
                this.encodeLink(this.module + "/curricularRules/createCurricularRule.faces", "&degreeModuleID=" + this.courseGroup.getExternalId(), false, "setCurricularRule");
            }
        } else {
            if (expandOptionAvailable) {
                this.writer.append((CharSequence)" , ");
            }
            this.encodeLink(this.module + "/createCurricularCourse.faces", "&courseGroupID=" + this.courseGroup.getExternalId(), false, "create.curricular.course");
            this.writer.append((CharSequence)" , ");
            this.encodeLink(this.module + "/associateCurricularCourse.faces", "&courseGroupID=" + this.courseGroup.getExternalId(), false, "associate.curricular.course");
        }
        this.writer.endElement("th");
    }

    private void encodeChildCurricularCourses(int width, int courseGroupIndent) throws IOException {
        this.writer.startElement("div", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)(this.courseGroup.isRoot() ? "indent3" : "indent" + (courseGroupIndent + 3)), null);
        this.writer.startElement("table", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"showinfo3 mvert0", null);
        this.writer.writeAttribute("style", (Object)("width: " + (width - this.depth * 3 - 3) + "em;"), null);
        if (!this.expandable.booleanValue() || this.isToRenderExpanded()) {
            for (Context context : this.courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.executionYear)) {
                new UICurricularCourse(context.getChildDegreeModule(), context, this.toEdit, this.showRules, this.depth, this.tabs + "\t", this.executionYear, this.module, null, false).encodeBegin(this.facesContext);
            }
        }
        this.writer.endElement("table");
        this.writer.endElement("div");
    }

    private boolean isToRenderExpanded() {
        String expandGroupId = this.getExpandGroupId();
        return expandGroupId != null && expandGroupId.equals(this.courseGroup.getExternalId());
    }

    protected String getExpandGroupId() {
        return ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getParameter(EXPAND_GROUP_ID_PARAM);
    }

    @Override
    protected void appendCodeAndName() throws IOException {
        ProgramConclusion programConclusion;
        super.appendCodeAndName();
        if (this.degreeModule.isCourseGroup() && (programConclusion = ((CourseGroup)((Object)this.degreeModule)).getProgramConclusion()) != null) {
            String name = programConclusion.getName().getContent();
            String description = programConclusion.getDescription().getContent();
            this.writer.startElement("strong", (UIComponent)this);
            this.writer.append((CharSequence)" [");
            this.writer.append((CharSequence)name);
            if (!Strings.isNullOrEmpty((String)description)) {
                this.writer.append((CharSequence)" - ");
                this.writer.append((CharSequence)description);
            }
            this.writer.append((CharSequence)"]");
            this.writer.endElement("strong");
        }
        if (this.toEdit.booleanValue()) {
            if (this.degreeModule.isOptionalCourseGroup()) {
                this.writer.startElement("strong", (UIComponent)this);
                this.writer.append((CharSequence)" (");
                this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"optional", (String[])new String[0]));
                this.writer.append((CharSequence)")");
                this.writer.endElement("strong");
            }
            if (this.degreeModule.isBranchCourseGroup()) {
                this.writer.startElement("strong", (UIComponent)this);
                this.writer.append((CharSequence)" (");
                this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"branchCourseGroup", (String[])new String[0]));
                this.writer.append((CharSequence)")");
                this.writer.endElement("strong");
            }
        }
    }
}

