/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.student.enrolment.bolonha;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.MDCandidacy;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.student.AffinityCyclesManagement;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentPreConditions;
import org.fenixedu.academic.dto.student.enrollment.bolonha.CycleEnrolmentBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolInAffinityCycle$callable$run;
import org.fenixedu.academic.service.services.student.enrolment.bolonha.EnrolInAffinityCycle$callable$run$1;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrolInAffinityCycle {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$run$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(Person person, CycleEnrolmentBean cycleEnrolmentBean) {
        Object object = advice$run.perform((Callable)new EnrolInAffinityCycle$callable$run(person, cycleEnrolmentBean));
    }

    static /* synthetic */ void advised$run(Person person, CycleEnrolmentBean cycleBean) {
        StudentCurricularPlan studentCurricularPlan = cycleBean.getStudentCurricularPlan();
        studentCurricularPlan.enrolInAffinityCycle(cycleBean.getCycleCourseGroupToEnrol(), cycleBean.getExecutionPeriod());
    }

    public static Registration run(Person person, StudentCurricularPlan studentCurricularPlan, CycleCourseGroup cycleCourseGroup, ExecutionSemester executionSemester) throws FenixServiceException {
        return (Registration)((Object)advice$run$1.perform((Callable)new EnrolInAffinityCycle$callable$run$1(person, studentCurricularPlan, cycleCourseGroup, executionSemester)));
    }

    static /* synthetic */ Registration advised$run(Person person, StudentCurricularPlan studentCurricularPlan, CycleCourseGroup cycleCourseGroupToEnrol, ExecutionSemester executionSemester) throws FenixServiceException {
        EnrolInAffinityCycle.checkConditionsToEnrol(studentCurricularPlan, executionSemester);
        CycleCurriculumGroup secondCycle = studentCurricularPlan.getSecondCycle();
        if (secondCycle == null) {
            if (EnrolInAffinityCycle.studentCurricularPlanAllowAffinityCycle(studentCurricularPlan, cycleCourseGroupToEnrol)) {
                studentCurricularPlan.enrolInAffinityCycle(cycleCourseGroupToEnrol, executionSemester);
                return studentCurricularPlan.getRegistration();
            }
            Student student = studentCurricularPlan.getRegistration().getStudent();
            if (student.hasActiveRegistrationFor(cycleCourseGroupToEnrol.getParentDegreeCurricularPlan())) {
                throw new FenixServiceException("error");
            }
            MDCandidacy candidacy = EnrolInAffinityCycle.createMDCandidacy(student, cycleCourseGroupToEnrol, executionSemester);
            Registration newRegistration = new Registration(student.getPerson(), cycleCourseGroupToEnrol.getParentDegreeCurricularPlan(), (StudentCandidacy)((Object)candidacy), RegistrationProtocol.getDefault(), cycleCourseGroupToEnrol.getCycleType());
            newRegistration.setSourceRegistration(studentCurricularPlan.getRegistration());
            newRegistration.getActiveState().setResponsiblePerson(null);
            newRegistration.setIngressionType(IngressionType.findByPredicate(IngressionType::isDirectAccessFrom1stCycle).orElse(null));
            EnrolInAffinityCycle.markOldRegistrationWithConcludedState(studentCurricularPlan);
            return newRegistration;
        }
        if (secondCycle.isExternal()) {
            return new AffinityCyclesManagement(studentCurricularPlan).enrol(cycleCourseGroupToEnrol);
        }
        return studentCurricularPlan.getRegistration();
    }

    private static void markOldRegistrationWithConcludedState(StudentCurricularPlan studentCurricularPlan) {
        if (studentCurricularPlan.getRegistration().hasState(RegistrationStateType.CONCLUDED)) {
            return;
        }
        Registration registration = studentCurricularPlan.getRegistration();
        RegistrationState state = RegistrationState.createRegistrationState(registration, null, new DateTime(), RegistrationStateType.CONCLUDED);
        state.setResponsiblePerson(null);
    }

    private static boolean studentCurricularPlanAllowAffinityCycle(StudentCurricularPlan studentCurricularPlan, CycleCourseGroup cycleCourseGroupToEnrol) {
        return studentCurricularPlan.getCycleTypes().contains((Object)cycleCourseGroupToEnrol.getCycleType()) && studentCurricularPlan.getDegreeCurricularPlan() == cycleCourseGroupToEnrol.getParentDegreeCurricularPlan();
    }

    private static MDCandidacy createMDCandidacy(Student student, CycleCourseGroup cycleCourseGroupToEnrol, ExecutionSemester executionSemester) {
        return new MDCandidacy(student.getPerson(), cycleCourseGroupToEnrol.getParentDegreeCurricularPlan().getExecutionDegreeByAcademicInterval(executionSemester.getExecutionYear().getAcademicInterval()));
    }

    private static void checkConditionsToEnrol(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) throws FenixServiceException {
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkPreConditionsToEnrol(studentCurricularPlan, executionSemester);
        if (!result.isValid()) {
            throw new FenixServiceException(result.message(), result.args());
        }
    }
}

