/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.commons.StringNormalizer;

public abstract class AbstractSearchObjects<T> {
    protected Collection<T> process(Collection<T> objects, String value, int limit, Map<String, String> arguments) {
        ArrayList<T> result;
        String slotName = arguments.get("slot");
        if (value == null) {
            result = (ArrayList<T>)objects;
        } else {
            result = new ArrayList<T>();
            String[] values = StringNormalizer.normalize((String)value).split("\\p{Space}+");
            block4: for (T object : objects) {
                try {
                    String objectValue = (String)PropertyUtils.getProperty(object, (String)slotName);
                    if (objectValue == null) continue;
                    String normalizedValue = StringNormalizer.normalize((String)objectValue);
                    for (int i = 0; i < values.length; ++i) {
                        String part = values[i];
                        if (!normalizedValue.contains(part)) continue block4;
                    }
                    result.add(object);
                    if (result.size() < limit) continue;
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new DomainException("searchObject.type.notFound", e, new String[0]);
                }
                catch (InvocationTargetException e) {
                    throw new DomainException("searchObject.failed.read", e, new String[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new DomainException("searchObject.failed.read", e, new String[0]);
                }
            }
        }
        Collections.sort(result, new BeanComparator(slotName));
        return result;
    }
}

