/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.administrativeOffice.enrolment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.log.CurriculumLineLog;
import org.fenixedu.academic.domain.log.EnrolmentLog;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.EnrolmentAction;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class MultiSemesterEnrolmentReporter {
    private final int hoursToReport;
    private final int semesterToReport;
    private final Map<ExecutionSemester, Set<Registration>> registrationsBySemester = new HashMap<ExecutionSemester, Set<Registration>>();
    private SortedMap<ExecutionSemester, SortedMap<Long, int[]>> stats = new TreeMap<ExecutionSemester, SortedMap<Long, int[]>>();

    public MultiSemesterEnrolmentReporter(int hoursToReportFromStart, int semesterToReport) {
        this.hoursToReport = hoursToReportFromStart;
        this.semesterToReport = semesterToReport;
    }

    public void report(int year, int month, int day, int hour) {
        DateTime enrolmentStartTime = new DateTime(year, month, day, hour, 0, 0, 0);
        ExecutionSemester semester = ExecutionSemester.readByDateTime(enrolmentStartTime);
        DateTime endTimeToReport = enrolmentStartTime.plusHours(this.hoursToReport);
        if (semester.getSemester() == this.semesterToReport) {
            semester.getCurriculumLineLogsSet().stream().filter(l -> l instanceof EnrolmentLog).filter(l -> !l.getDateDateTime().isBefore((ReadableInstant)enrolmentStartTime) && !l.getDateDateTime().isAfter((ReadableInstant)endTimeToReport)).sorted((l1, l2) -> l1.getDateDateTime().compareTo((ReadableInstant)l2.getDateDateTime())).forEach(l -> this.process(semester, enrolmentStartTime, (CurriculumLineLog)((Object)l)));
            semester.getAssociatedExecutionCoursesSet().stream().flatMap(ec -> ec.getCourseLoadsSet().stream()).flatMap(cl -> cl.getShiftsSet().stream()).flatMap(s -> s.getShiftEnrolmentsSet().stream()).map(se -> se.getCreatedOn()).filter(dt -> !dt.isBefore((ReadableInstant)enrolmentStartTime) && !dt.isAfter((ReadableInstant)endTimeToReport)).map(dt -> new Interval((ReadableInstant)enrolmentStartTime, (ReadableInstant)dt).toDuration().getStandardSeconds()).forEach(seconds -> this.add(semester, (Long)seconds, new int[]{0, 0, 1}));
        }
    }

    public JsonArray getStats() {
        return this.getStats("registrations", "enrolments", "shifts");
    }

    protected void process(ExecutionSemester semester, DateTime enrolmentStartTime, CurriculumLineLog log) {
        Long seconds = new Interval((ReadableInstant)enrolmentStartTime, (ReadableInstant)log.getDateDateTime()).toDuration().getStandardSeconds();
        int regCount = this.countRegistration(semester, log.getStudent()) ? 1 : 0;
        int enrolCount = log.getAction().equals(EnrolmentAction.ENROL) ? 1 : -1;
        this.add(semester, seconds, new int[]{regCount, enrolCount, 0});
    }

    private boolean countRegistration(ExecutionSemester semester, Registration registration) {
        Set<Registration> registrations = this.getRegistrations(semester);
        if (registrations.contains((Object)registration)) {
            return false;
        }
        registrations.add(registration);
        return true;
    }

    private Set<Registration> getRegistrations(ExecutionSemester semester) {
        if (!this.registrationsBySemester.containsKey(semester)) {
            this.registrationsBySemester.put(semester, new HashSet());
        }
        return this.registrationsBySemester.get(semester);
    }

    public void add(ExecutionSemester semester, Long seconds, int[] counts) {
        SortedMap<Long, int[]> values = MultiSemesterEnrolmentReporter.get(this.stats, semester);
        if (!values.containsKey(seconds)) {
            values.put(seconds, new int[counts.length]);
        }
        int[] ia = (int[])values.get(seconds);
        int i = 0;
        while (i < counts.length) {
            int n = i;
            ia[n] = ia[n] + counts[i++];
        }
    }

    private static SortedMap<Long, int[]> get(SortedMap<ExecutionSemester, SortedMap<Long, int[]>> map, ExecutionSemester semester) {
        if (!map.containsKey(semester)) {
            map.put(semester, new TreeMap());
        }
        return (SortedMap)map.get(semester);
    }

    private JsonArray getStats(String ... labels) {
        JsonArray result = new JsonArray();
        for (Map.Entry<ExecutionSemester, SortedMap<Long, int[]>> e : this.stats.entrySet()) {
            String semester = e.getKey().getQualifiedName();
            int[] accumulatedValues = new int[labels.length];
            for (Map.Entry<Long, int[]> v : e.getValue().entrySet()) {
                Long second = v.getKey();
                int[] values = v.getValue();
                JsonObject obj = new JsonObject();
                obj.addProperty("label", semester);
                obj.addProperty("second", (Number)second);
                for (int i = 0; i < labels.length; ++i) {
                    int n = i;
                    int n2 = accumulatedValues[n] + values[i];
                    accumulatedValues[n] = n2;
                    int a = n2;
                    obj.addProperty(labels[i], (Number)a);
                }
                result.add((JsonElement)obj);
            }
        }
        return result;
    }
}

