/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.accounting.gratuity.paymentPlan;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.installments.InstallmentForFirstTimeStudents;
import org.fenixedu.academic.domain.accounting.installments.InstallmentWithMonthlyPenalty;
import org.fenixedu.academic.domain.accounting.installments.PartialRegimeInstallment;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlanForAliens;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlanForFirstTimeInstitutionStudents;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlanForPartialRegime;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityForStudentsInSecondCurricularYear;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityForStudentsInSecondCurricularYearForPartialRegime;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlanForPartialRegimeEnroledOnlyInSecondSemester;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlanForStudentsEnroledOnlyInSecondSemester;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.PaymentPlanBean;
import org.fenixedu.academic.service.services.accounting.gratuity.paymentPlan.GratuityPaymentPlanManager$callable$create;
import org.fenixedu.academic.service.services.accounting.gratuity.paymentPlan.GratuityPaymentPlanManager$callable$delete;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GratuityPaymentPlanManager {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void create(PaymentPlanBean paymentPlanBean) {
        Object object = advice$create.perform((Callable)new GratuityPaymentPlanManager$callable$create(paymentPlanBean));
    }

    static /* synthetic */ void advised$create(PaymentPlanBean paymentPlanBean) {
        for (DegreeCurricularPlan degreeCurricularPlan : paymentPlanBean.getDegreeCurricularPlans()) {
            GratuityPaymentPlanManager.createInstallments(GratuityPaymentPlanManager.makePaymentPlan(paymentPlanBean, degreeCurricularPlan), paymentPlanBean.getInstallments());
        }
    }

    private static PaymentPlan makePaymentPlan(PaymentPlanBean paymentPlanBean, DegreeCurricularPlan degreeCurricularPlan) {
        if (paymentPlanBean.isForAlien()) {
            return new FullGratuityPaymentPlanForAliens(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
        }
        if (paymentPlanBean.isForPartialRegime()) {
            if (paymentPlanBean.isForSecondCurricularYear()) {
                return new GratuityForStudentsInSecondCurricularYearForPartialRegime(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
            }
            if (paymentPlanBean.isForStudentEnroledOnSecondSemesterOnly()) {
                return new GratuityPaymentPlanForPartialRegimeEnroledOnlyInSecondSemester(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
            }
            return new FullGratuityPaymentPlanForPartialRegime(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
        }
        if (paymentPlanBean.isForStudentEnroledOnSecondSemesterOnly()) {
            return new GratuityPaymentPlanForStudentsEnroledOnlyInSecondSemester(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
        }
        if (paymentPlanBean.isForFirstTimeInstitutionStudents()) {
            return new FullGratuityPaymentPlanForFirstTimeInstitutionStudents(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
        }
        if (paymentPlanBean.isForSecondCurricularYear()) {
            return new GratuityForStudentsInSecondCurricularYear(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
        }
        return new FullGratuityPaymentPlan(paymentPlanBean.getExecutionYear(), degreeCurricularPlan.getServiceAgreementTemplate(), paymentPlanBean.isMain());
    }

    private static void createInstallments(PaymentPlan paymentPlan, List<InstallmentBean> installmentsToCreate) {
        for (InstallmentBean each : installmentsToCreate) {
            if (paymentPlan.isForPartialRegime()) {
                if (each.isPenaltyAppliable()) {
                    new PartialRegimeInstallment((FullGratuityPaymentPlanForPartialRegime)((Object)paymentPlan), each.getAmount(), each.getStartDate(), each.getEndDate(), each.getMontlyPenaltyPercentage(), each.getWhenToStartApplyPenalty(), each.getMaxMonthsToApplyPenalty(), each.getEctsForAmount(), new ArrayList<ExecutionSemester>(each.getExecutionSemesters()));
                    continue;
                }
                new PartialRegimeInstallment((FullGratuityPaymentPlanForPartialRegime)((Object)paymentPlan), each.getAmount(), each.getStartDate(), each.getEndDate(), each.getEctsForAmount(), new ArrayList<ExecutionSemester>(each.getExecutionSemesters()));
                continue;
            }
            if (paymentPlan.isForFirstTimeInstitutionStudents() && each.isForFirstTimeInstitutionStudents()) {
                new InstallmentForFirstTimeStudents(paymentPlan, each.getAmount(), each.getStartDate(), each.getEndDate(), each.getMontlyPenaltyPercentage(), each.getMaxMonthsToApplyPenalty(), each.getNumberOfDaysToStartApplyingPenalty());
                continue;
            }
            if (each.isPenaltyAppliable()) {
                new InstallmentWithMonthlyPenalty(paymentPlan, each.getAmount(), each.getStartDate(), each.getEndDate(), each.getMontlyPenaltyPercentage(), each.getWhenToStartApplyPenalty(), each.getMaxMonthsToApplyPenalty());
                continue;
            }
            new Installment(paymentPlan, each.getAmount(), each.getStartDate(), each.getEndDate());
        }
    }

    public static void delete(PaymentPlan paymentPlan) {
        Object object = advice$delete.perform((Callable)new GratuityPaymentPlanManager$callable$delete(paymentPlan));
    }

    static /* synthetic */ void advised$delete(PaymentPlan paymentPlan) {
        paymentPlan.delete();
    }
}

