/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.factory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoOccupation;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.dto.InfoSiteRoomTimeTable;
import org.fenixedu.academic.dto.InfoWrittenTest;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

@Deprecated
public class RoomSiteComponentBuilder {
    public static InfoSiteRoomTimeTable getInfoSiteRoomTimeTable(Calendar day, Space room, ExecutionSemester executionSemester) {
        ArrayList<InfoObject> infoShowOccupations = new ArrayList<InfoObject>();
        Calendar startDay = Calendar.getInstance();
        startDay.setTimeInMillis(day.getTimeInMillis());
        startDay.add(5, 2 - day.get(7));
        Calendar endDay = Calendar.getInstance();
        endDay.setTimeInMillis(startDay.getTimeInMillis());
        endDay.add(5, 6);
        YearMonthDay weekStartYearMonthDay = YearMonthDay.fromCalendarFields((Calendar)startDay);
        YearMonthDay weekEndYearMonthDay = YearMonthDay.fromCalendarFields((Calendar)endDay);
        Interval search = new Interval((ReadableInstant)weekStartYearMonthDay.toDateTimeAtMidnight(), (ReadableInstant)weekEndYearMonthDay.toDateTimeAtMidnight());
        for (Occupation roomOccupation : room.getOccupationSet()) {
            if (roomOccupation instanceof WrittenEvaluationSpaceOccupation) {
                Set writtenEvaluations = ((WrittenEvaluationSpaceOccupation)roomOccupation).getWrittenEvaluationsSet();
                RoomSiteComponentBuilder.getWrittenEvaluationRoomOccupations(infoShowOccupations, weekStartYearMonthDay, weekEndYearMonthDay, writtenEvaluations);
                continue;
            }
            if (roomOccupation instanceof LessonSpaceOccupation) {
                Lesson lesson = ((LessonSpaceOccupation)roomOccupation).getLesson();
                RoomSiteComponentBuilder.getLessonOccupations(infoShowOccupations, weekStartYearMonthDay, weekEndYearMonthDay, lesson);
                continue;
            }
            if (roomOccupation instanceof LessonInstanceSpaceOccupation) {
                Set lessonInstances = ((LessonInstanceSpaceOccupation)roomOccupation).getLessonInstancesSet();
                RoomSiteComponentBuilder.getLessonInstanceOccupations(infoShowOccupations, weekStartYearMonthDay, weekEndYearMonthDay, lessonInstances);
                continue;
            }
            for (Interval interval : roomOccupation.getIntervals()) {
                if (!search.overlaps((ReadableInterval)interval)) continue;
                infoShowOccupations.add(new InfoOccupation(roomOccupation, interval));
            }
        }
        InfoSiteRoomTimeTable component = new InfoSiteRoomTimeTable();
        component.setInfoShowOccupation(infoShowOccupations);
        component.setInfoRoom(InfoRoom.newInfoFromDomain(room));
        return component;
    }

    private static void getLessonOccupations(List<InfoObject> infoShowOccupations, YearMonthDay weekStartYearMonthDay, YearMonthDay weekEndYearMonthDay, Lesson lesson) {
        if (lesson != null && lesson.getShift() != null && lesson.containsWithoutCheckInstanceDates(new Interval((ReadableInstant)weekStartYearMonthDay.toDateTimeAtMidnight(), (ReadableInstant)weekEndYearMonthDay.toDateTimeAtMidnight()))) {
            infoShowOccupations.add(InfoLesson.newInfoFromDomain(lesson));
        }
    }

    private static void getLessonInstanceOccupations(List<InfoObject> infoShowOccupations, YearMonthDay weekStartYearMonthDay, YearMonthDay weekEndYearMonthDay, Collection<LessonInstance> lessonInstances) {
        if (lessonInstances != null) {
            for (LessonInstance lessonInstance : lessonInstances) {
                YearMonthDay lessonInstanceDay = lessonInstance.getDay();
                if (lessonInstanceDay.isBefore((ReadablePartial)weekStartYearMonthDay) || lessonInstanceDay.isAfter((ReadablePartial)weekEndYearMonthDay)) continue;
                InfoLessonInstance infoLessonInstance = new InfoLessonInstance(lessonInstance);
                infoShowOccupations.add(infoLessonInstance);
            }
        }
    }

    private static void getWrittenEvaluationRoomOccupations(List<InfoObject> infoShowOccupations, YearMonthDay weekStartYearMonthDay, YearMonthDay weekEndYearMonthDay, Collection<WrittenEvaluation> writtenEvaluations) {
        if (writtenEvaluations != null) {
            for (WrittenEvaluation writtenEvaluation : writtenEvaluations) {
                YearMonthDay evaluationDate = writtenEvaluation.getDayDateYearMonthDay();
                if (evaluationDate.isBefore((ReadablePartial)weekStartYearMonthDay) || evaluationDate.isAfter((ReadablePartial)weekEndYearMonthDay)) continue;
                if (writtenEvaluation instanceof Exam) {
                    Exam exam = (Exam)((Object)writtenEvaluation);
                    infoShowOccupations.add(InfoExam.newInfoFromDomain(exam));
                    continue;
                }
                if (!(writtenEvaluation instanceof WrittenTest)) continue;
                WrittenTest writtenTest = (WrittenTest)((Object)writtenEvaluation);
                infoShowOccupations.add(InfoWrittenTest.newInfoFromDomain(writtenTest));
            }
        }
    }
}

