/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalCourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.NumberToWordsConverter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;

public class ExternalCourseLoadRequestDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 10L;

    protected ExternalCourseLoadRequestDocument(ExternalCourseLoadRequest documentRequest) {
        super((IDocumentRequest)((Object)documentRequest));
    }

    protected ExternalCourseLoadRequest getDocumentRequest() {
        return (ExternalCourseLoadRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        this.setPersonFields();
        this.addParametersInformation();
    }

    private void addParametersInformation() {
        this.addParameter("studentNumber", this.getStudentNumber());
        this.addParameter("degreeDescription", this.getDegreeDescription());
        AdministrativeOffice administrativeOffice = this.getAdministrativeOffice();
        Person activeUnitCoordinator = administrativeOffice.getCoordinator().getPerson();
        this.addParameter("administrativeOfficeCoordinatorName", activeUnitCoordinator.getName());
        this.addParameter("administrativeOfficeName", this.getI18NText(administrativeOffice.getName()));
        this.addParameter("institutionName", Bennu.getInstance().getInstitutionUnit().getName());
        this.addParameter("universityName", UniversityUnit.getInstitutionsUniversityUnit().getName());
        this.addParameter("day", new LocalDate().toString("dd MMMM yyyy", this.getLocale()));
        this.addParameter("numberOfCourseLoads", NumberToWordsConverter.convert(this.getDocumentRequest().getNumberOfCourseLoads()));
        this.addParameter("externalInstitutionName", this.getDocumentRequest().getInstitution().getName());
    }

    private String getStudentNumber() {
        String agreementInformation;
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getRegistrationProtocol().isMilitaryAgreement() && !StringUtils.isEmpty((String)(agreementInformation = registration.getAgreementInformation()))) {
            return registration.getRegistrationProtocol().getCode() + " " + agreementInformation;
        }
        return registration.getStudent().getNumber().toString();
    }

    @Override
    protected boolean showPriceFields() {
        return false;
    }

    @Override
    protected void setPersonFields() {
        this.addParameter("name", this.getDocumentRequest().getPerson().getName());
    }
}

