/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.DomainObject;

public class AccessControl {
    public static Person getPerson() {
        User userView = Authenticate.getUser();
        return userView == null ? null : userView.getPerson();
    }

    public static <T extends DomainObject> void check(T c, AccessControlPredicate<T> predicate) {
        Person requester = AccessControl.getPerson();
        boolean result = false;
        if (!(result |= predicate != null && predicate.evaluate(c))) {
            StringBuilder message = new StringBuilder();
            message.append("User ").append(requester == null ? "" : requester.getUsername()).append(" tried to execute access content instance number").append(c.getExternalId());
            message.append("but he/she is not authorized to do so");
            throw new IllegalDataAccessException(message.toString(), requester);
        }
    }

    public static <T> void check(T c, AccessControlPredicate<T> predicate) {
        Person requester = AccessControl.getPerson();
        boolean result = false;
        if (!(result |= predicate != null && predicate.evaluate(c))) {
            StringBuilder message = new StringBuilder();
            message.append("User ").append(requester.getUsername()).append(" tried to execute access content instance number").append(c.toString());
            message.append("but he/she is not authorized to do so");
            throw new IllegalDataAccessException(message.toString(), requester);
        }
    }

    public static void check(AccessControlPredicate<?> predicate) {
        Person requester = AccessControl.getPerson();
        boolean result = false;
        if (!(result |= predicate != null && predicate.evaluate(null))) {
            StringBuilder message = new StringBuilder();
            String username = requester == null ? "<nobody>" : requester.getUsername();
            message.append("User ");
            message.append(username);
            message.append(" tried to execute method but he/she is not authorized to do so");
            throw new IllegalDataAccessException(message.toString(), requester);
        }
    }
}

