/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.dto.accounting.CreditNoteEntryDTO;

public class CreateCreditNoteBean
implements Serializable {
    private List<CreditNoteEntryDTO> creditNoteEntryDTOs;
    private Receipt receipt;

    public CreateCreditNoteBean(Receipt receipt) {
        this.setReceipt(receipt);
        this.setCreditNoteEntryDTOs(this.buildCreditNoteEntryDTOs(receipt));
    }

    public Receipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(Receipt receipt) {
        this.receipt = receipt;
    }

    public List<CreditNoteEntryDTO> getCreditNoteEntryDTOs() {
        return this.creditNoteEntryDTOs;
    }

    public void setCreditNoteEntryDTOs(List<CreditNoteEntryDTO> creditNoteEntryDTOs) {
        this.creditNoteEntryDTOs = creditNoteEntryDTOs;
    }

    private List<CreditNoteEntryDTO> buildCreditNoteEntryDTOs(Receipt receipt) {
        ArrayList<CreditNoteEntryDTO> result = new ArrayList<CreditNoteEntryDTO>();
        for (Entry entry : receipt.getReimbursableEntries()) {
            result.add(new CreditNoteEntryDTO(entry));
        }
        return result;
    }

    public List<CreditNoteEntryDTO> getSelectedEntries() {
        ArrayList<CreditNoteEntryDTO> result = new ArrayList<CreditNoteEntryDTO>();
        for (CreditNoteEntryDTO creditNoteEntryDTO : this.getCreditNoteEntryDTOs()) {
            if (!creditNoteEntryDTO.isSelected()) continue;
            result.add(creditNoteEntryDTO);
        }
        return result;
    }
}

